/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.authn.Authenticator;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.configuration.AuthenticatorConfiguration;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.jndi.LdapJndiProperties;
import org.apache.directory.server.core.jndi.ServerContext;
import org.apache.directory.shared.ldap.exception.LdapAuthenticationException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationService
extends BaseInterceptor {
    private static final Logger log = LoggerFactory.getLogger((Class)AuthenticationService.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    public Map authenticators = new HashMap();
    private DirectoryServiceConfiguration factoryCfg;

    public void init(DirectoryServiceConfiguration factoryCfg, InterceptorConfiguration cfg) throws NamingException {
        this.factoryCfg = factoryCfg;
        Iterator i = factoryCfg.getStartupConfiguration().getAuthenticatorConfigurations().iterator();
        while (i.hasNext()) {
            try {
                this.register((AuthenticatorConfiguration)i.next());
            }
            catch (Exception e) {
                this.destroy();
                throw (NamingException)new NamingException("Failed to register authenticator.").initCause(e);
            }
        }
    }

    public void destroy() {
        Iterator i = new ArrayList(this.authenticators.values()).iterator();
        while (i.hasNext()) {
            Iterator j = new ArrayList((Collection)i.next()).iterator();
            while (j.hasNext()) {
                this.unregister((Authenticator)j.next());
            }
        }
        this.authenticators.clear();
    }

    private void register(AuthenticatorConfiguration cfg) throws NamingException {
        cfg.getAuthenticator().init(this.factoryCfg, cfg);
        ArrayList<Authenticator> authenticatorList = this.getAuthenticators(cfg.getAuthenticator().getAuthenticatorType());
        if (authenticatorList == null) {
            authenticatorList = new ArrayList<Authenticator>();
            this.authenticators.put(cfg.getAuthenticator().getAuthenticatorType(), authenticatorList);
        }
        authenticatorList.add(cfg.getAuthenticator());
    }

    private void unregister(Authenticator authenticator) {
        Collection authenticatorList = this.getAuthenticators(authenticator.getAuthenticatorType());
        if (authenticatorList == null) {
            return;
        }
        authenticatorList.remove(authenticator);
        try {
            authenticator.destroy();
        }
        catch (Throwable t) {
            log.warn("Failed to destroy an authenticator.", t);
        }
    }

    private Collection getAuthenticators(String type) {
        Collection result = (Collection)this.authenticators.get(type);
        if (result != null && result.size() > 0) {
            return result;
        }
        return null;
    }

    public void add(NextInterceptor next, LdapDN normName, Attributes entry) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Adding the entry " + AttributeUtils.toString((Attributes)entry) + " for DN = '" + normName.getUpName() + "'");
        }
        this.checkAuthenticated();
        next.add(normName, entry);
    }

    public void delete(NextInterceptor next, LdapDN name) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Deleting name = '" + name.toString() + "'");
        }
        this.checkAuthenticated();
        next.delete(name);
        this.invalidateAuthenticatorCaches(name);
    }

    public LdapDN getMatchedName(NextInterceptor next, LdapDN dn) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Matching name = '" + dn.toString() + "'");
        }
        this.checkAuthenticated();
        return next.getMatchedName(dn);
    }

    public Attributes getRootDSE(NextInterceptor next) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Getting root DSE");
        }
        this.checkAuthenticated();
        return next.getRootDSE();
    }

    public LdapDN getSuffix(NextInterceptor next, LdapDN dn) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Getting suffix for name = '" + dn.toString() + "'");
        }
        this.checkAuthenticated();
        return next.getSuffix(dn);
    }

    public boolean hasEntry(NextInterceptor next, LdapDN name) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Testing if entry name = '" + name.toString() + "' exists");
        }
        this.checkAuthenticated();
        return next.hasEntry(name);
    }

    public boolean isSuffix(NextInterceptor next, LdapDN name) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Testing suffix for name = '" + name.toString() + "'");
        }
        this.checkAuthenticated();
        return next.isSuffix(name);
    }

    public NamingEnumeration list(NextInterceptor next, LdapDN base) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Listing base = '" + base.toString() + "'");
        }
        this.checkAuthenticated();
        return next.list(base);
    }

    public Iterator listSuffixes(NextInterceptor next) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Listing suffixes");
        }
        this.checkAuthenticated();
        return next.listSuffixes();
    }

    public Attributes lookup(NextInterceptor next, LdapDN dn, String[] attrIds) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Lookup name = '" + dn.toString() + "', attributes = " + attrIds);
        }
        this.checkAuthenticated();
        return next.lookup(dn, attrIds);
    }

    public Attributes lookup(NextInterceptor next, LdapDN name) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Lookup name = '" + name.toString() + "'");
        }
        this.checkAuthenticated();
        return next.lookup(name);
    }

    private void invalidateAuthenticatorCaches(LdapDN principalDn) {
        Iterator jj = this.authenticators.keySet().iterator();
        while (jj.hasNext()) {
            String authMech = (String)jj.next();
            Collection authenticators = this.getAuthenticators(authMech);
            Iterator ii = authenticators.iterator();
            while (ii.hasNext()) {
                Authenticator authenticator = (Authenticator)ii.next();
                authenticator.invalidateCache(AuthenticationService.getPrincipal().getJndiName());
            }
        }
    }

    public void modify(NextInterceptor next, LdapDN name, int modOp, Attributes mods) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Modifying name = '" + name.toString() + "', modifs = " + AttributeUtils.toString((Attributes)mods));
        }
        this.checkAuthenticated();
        next.modify(name, modOp, mods);
        this.invalidateAuthenticatorCaches(name);
    }

    public void modify(NextInterceptor next, LdapDN name, ModificationItemImpl[] mods) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Modifying name = '" + name.toString() + "'");
        }
        this.checkAuthenticated();
        next.modify(name, mods);
        this.invalidateAuthenticatorCaches(name);
    }

    public void modifyRn(NextInterceptor next, LdapDN name, String newRn, boolean deleteOldRn) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Modifying name = '" + name.toString() + "', new RDN = '" + newRn + "', oldRDN = '" + deleteOldRn + "'");
        }
        this.checkAuthenticated();
        next.modifyRn(name, newRn, deleteOldRn);
        this.invalidateAuthenticatorCaches(name);
    }

    public void move(NextInterceptor next, LdapDN oriChildName, LdapDN newParentName, String newRn, boolean deleteOldRn) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Moving name = '" + oriChildName.toString() + "' to name = '" + newParentName + "', new RDN = '" + newRn + "', oldRDN = '" + deleteOldRn + "'");
        }
        this.checkAuthenticated();
        next.move(oriChildName, newParentName, newRn, deleteOldRn);
        this.invalidateAuthenticatorCaches(oriChildName);
    }

    public void move(NextInterceptor next, LdapDN oriChildName, LdapDN newParentName) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Moving name = '" + oriChildName.toString() + " to name = '" + newParentName + "'");
        }
        this.checkAuthenticated();
        next.move(oriChildName, newParentName);
        this.invalidateAuthenticatorCaches(oriChildName);
    }

    public NamingEnumeration search(NextInterceptor next, LdapDN base, Map env, ExprNode filter, SearchControls searchCtls) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Search for base = '" + base.toString() + "'");
        }
        this.checkAuthenticated();
        return next.search(base, env, filter, searchCtls);
    }

    private void checkAuthenticated() throws NamingException {
        ServerContext ctx = (ServerContext)InvocationStack.getInstance().peek().getCaller();
        if (ctx.getPrincipal() != null) {
            if (ctx.getEnvironment().containsKey("java.naming.security.credentials")) {
                ctx.removeFromEnvironment("java.naming.security.credentials");
            }
            return;
        }
        throw new IllegalStateException("Attempted operation by unauthenticated caller.");
    }

    public void bind(NextInterceptor next, LdapDN bindDn, byte[] credentials, List mechanisms, String saslAuthId) throws NamingException {
        ServerContext ctx = (ServerContext)InvocationStack.getInstance().peek().getCaller();
        if (ctx.getPrincipal() != null) {
            if (ctx.getEnvironment().containsKey("java.naming.security.credentials")) {
                ctx.removeFromEnvironment("java.naming.security.credentials");
            }
            return;
        }
        Collection authenticators = null;
        for (int ii = 0; ii < mechanisms.size() && (authenticators = this.getAuthenticators((String)mechanisms.get(ii))) == null; ++ii) {
        }
        if (authenticators == null) {
            log.debug("No authenticators found, delegating bind to the nexus.");
            next.bind(bindDn, credentials, mechanisms, saslAuthId);
            log.debug("Nexus succeeded on bind operation.");
            ctx.setPrincipal(new TrustedPrincipalWrapper(new LdapPrincipal((Name)bindDn, LdapJndiProperties.getAuthenticationLevel(ctx.getEnvironment()))));
            ctx.removeFromEnvironment("java.naming.security.credentials");
            return;
        }
        Iterator i = authenticators.iterator();
        while (i.hasNext()) {
            Authenticator authenticator = (Authenticator)i.next();
            try {
                LdapPrincipal authorizationId = authenticator.authenticate(bindDn, ctx);
                ctx.setPrincipal(new TrustedPrincipalWrapper(authorizationId));
                ctx.removeFromEnvironment("java.naming.security.credentials");
                return;
            }
            catch (LdapAuthenticationException e) {
                if (!log.isInfoEnabled()) continue;
                log.info("Authenticator " + authenticator.getClass() + " failed to authenticate " + bindDn);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) continue;
                log.warn("Unexpected exception from " + authenticator.getClass() + " for principal " + bindDn, (Throwable)e);
            }
        }
        throw new LdapAuthenticationException();
    }

    public final class TrustedPrincipalWrapper {
        private final LdapPrincipal principal;

        private TrustedPrincipalWrapper(LdapPrincipal principal) {
            this.principal = principal;
        }

        public LdapPrincipal getPrincipal() {
            return this.principal;
        }
    }
}

