/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authn;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.WeakHashMap;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.authn.AbstractAuthenticator;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.jndi.ServerContext;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.shared.ldap.aci.AuthenticationLevel;
import org.apache.directory.shared.ldap.exception.LdapAuthenticationException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.ArrayUtils;
import org.apache.directory.shared.ldap.util.Base64;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAuthenticator
extends AbstractAuthenticator {
    private static final Logger log = LoggerFactory.getLogger((Class)SimpleAuthenticator.class);
    private static final Collection USERLOOKUP_BYPASS;
    private WeakHashMap credentialCache = new WeakHashMap(1000);

    public SimpleAuthenticator() {
        super("simple");
    }

    public LdapPrincipal authenticate(LdapDN principalDn, ServerContext ctx) throws NamingException {
        Object creds = ctx.getEnvironment().get("java.naming.security.credentials");
        if (creds == null) {
            creds = ArrayUtils.EMPTY_BYTE_ARRAY;
        } else if (creds instanceof String) {
            creds = StringTools.getBytesUtf8((String)((String)creds));
        }
        byte[] userPassword = null;
        userPassword = this.credentialCache.containsKey(principalDn.getNormName()) ? (byte[])this.credentialCache.get(principalDn.getNormName()) : this.lookupUserPassword(principalDn);
        boolean credentialsMatch = false;
        if (this.isPasswordOneWayEncrypted(userPassword)) {
            try {
                String algorithm = this.getAlgorithmForHashedPassword(userPassword);
                String digestedCredits = this.createDigestedPassword(algorithm, creds);
                credentialsMatch = ArrayUtils.isEquals((Object)StringTools.getBytesUtf8((String)digestedCredits), (Object)userPassword);
            }
            catch (NoSuchAlgorithmException nsae) {
                log.warn("Password stored with unknown algorithm.", (Throwable)nsae);
            }
            catch (IllegalArgumentException e) {
                log.warn("Exception during authentication", (Throwable)e);
            }
        } else {
            credentialsMatch = ArrayUtils.isEquals(creds, (Object)userPassword);
        }
        if (credentialsMatch) {
            LdapPrincipal principal = new LdapPrincipal((Name)principalDn, AuthenticationLevel.SIMPLE);
            this.credentialCache.put(principalDn.getNormName(), userPassword);
            return principal;
        }
        throw new LdapAuthenticationException();
    }

    protected byte[] lookupUserPassword(LdapDN principalDn) throws NamingException {
        Object userPassword;
        Attributes userEntry;
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        try {
            userEntry = proxy.lookup(principalDn, new String[]{"userPassword"}, USERLOOKUP_BYPASS);
            if (userEntry == null) {
                throw new LdapAuthenticationException("Failed to lookup user for authentication: " + principalDn);
            }
        }
        catch (Exception cause) {
            log.error("Authentication error : " + cause.getMessage());
            LdapAuthenticationException e = new LdapAuthenticationException();
            e.setRootCause((Throwable)e);
            throw e;
        }
        Attribute userPasswordAttr = userEntry.get("userPassword");
        if (userPasswordAttr == null) {
            userPassword = ArrayUtils.EMPTY_BYTE_ARRAY;
        } else {
            userPassword = userPasswordAttr.get();
            if (userPassword instanceof String) {
                userPassword = StringTools.getBytesUtf8((String)((String)userPassword));
            }
        }
        return userPassword;
    }

    protected boolean isPasswordOneWayEncrypted(Object password) {
        boolean result = false;
        try {
            String algorithm = this.getAlgorithmForHashedPassword(password);
            result = algorithm != null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return result;
    }

    protected String getAlgorithmForHashedPassword(Object password) throws IllegalArgumentException {
        String result = null;
        String sPassword = null;
        if (password instanceof byte[]) {
            sPassword = new String((byte[])password);
        } else if (password instanceof String) {
            sPassword = (String)password;
        } else {
            throw new IllegalArgumentException("password is neither a String nor a byte-Array.");
        }
        if (sPassword != null && sPassword.length() > 2 && sPassword.charAt(0) == '{' && sPassword.indexOf(125) > -1) {
            int algPosEnd = sPassword.indexOf(125);
            String algorithm = sPassword.substring(1, algPosEnd);
            try {
                MessageDigest.getInstance(algorithm);
                result = algorithm;
            }
            catch (NoSuchAlgorithmException e) {
                log.warn("Unknown message digest algorithm in password: " + algorithm, (Throwable)e);
            }
        }
        return result;
    }

    protected String createDigestedPassword(String algorithm, Object password) throws NoSuchAlgorithmException, IllegalArgumentException {
        byte[] data = null;
        if (password instanceof byte[]) {
            data = (byte[])password;
        } else if (password instanceof String) {
            data = StringTools.getBytesUtf8((String)((String)password));
        } else {
            throw new IllegalArgumentException("password is neither a String nor a byte-Array.");
        }
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalArgumentException(nsae.getMessage());
        }
        byte[] fingerPrint = digest.digest(data);
        char[] encoded = Base64.encode((byte[])fingerPrint);
        StringBuffer result = new StringBuffer();
        result.append('{');
        result.append(algorithm);
        result.append('}');
        result.append(encoded);
        return result.toString();
    }

    public void invalidateCache(LdapDN bindDn) {
        this.credentialCache.remove(bindDn.getNormName());
    }

    static {
        HashSet<String> c = new HashSet<String>();
        c.add("normalizationService");
        c.add("collectiveAttributeService");
        c.add("authenticationService");
        c.add("authorizationService");
        c.add("defaultAuthorizationService");
        c.add("schemaService");
        c.add("subentryService");
        c.add("operationalAttributeService");
        c.add("eventService");
        USERLOOKUP_BYPASS = Collections.unmodifiableCollection(c);
    }
}

