/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.enumeration.SearchResultFilter;
import org.apache.directory.server.core.enumeration.SearchResultFilteringEnumeration;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.jndi.ServerContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.shared.ldap.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.LdapDN;

public class DefaultAuthorizationService
extends BaseInterceptor {
    private static LdapDN USER_BASE_DN;
    private static LdapDN USER_BASE_DN_NORMALIZED;
    private static LdapDN GROUP_BASE_DN;
    private static LdapDN GROUP_BASE_DN_NORMALIZED;
    private static LdapDN ADMIN_GROUP_DN;
    private static LdapDN ADMIN_GROUP_DN_NORMALIZED;
    private boolean enabled = true;
    private Set administrators = new HashSet(2);
    private Map normalizerMapping;
    private PartitionNexus nexus;

    public void init(DirectoryServiceConfiguration factoryCfg, InterceptorConfiguration cfg) throws NamingException {
        this.nexus = factoryCfg.getPartitionNexus();
        this.normalizerMapping = factoryCfg.getGlobalRegistries().getAttributeTypeRegistry().getNormalizerMapping();
        this.enabled = !factoryCfg.getStartupConfiguration().isAccessControlEnabled();
        USER_BASE_DN = PartitionNexus.getUsersBaseName();
        USER_BASE_DN_NORMALIZED = LdapDN.normalize((LdapDN)USER_BASE_DN, (Map)this.normalizerMapping);
        GROUP_BASE_DN = PartitionNexus.getGroupsBaseName();
        GROUP_BASE_DN_NORMALIZED = LdapDN.normalize((LdapDN)GROUP_BASE_DN, (Map)this.normalizerMapping);
        ADMIN_GROUP_DN = new LdapDN("cn=Administrators,ou=groups,ou=system");
        ADMIN_GROUP_DN_NORMALIZED = (LdapDN)ADMIN_GROUP_DN.clone();
        ADMIN_GROUP_DN_NORMALIZED.normalize(this.normalizerMapping);
        this.loadAdministrators();
    }

    private void loadAdministrators() throws NamingException {
        HashSet<String> newAdministrators = new HashSet<String>(2);
        Attributes adminGroup = this.nexus.lookup(ADMIN_GROUP_DN_NORMALIZED);
        if (adminGroup == null) {
            return;
        }
        Attribute uniqueMember = adminGroup.get("uniqueMember");
        for (int ii = 0; ii < uniqueMember.size(); ++ii) {
            LdapDN memberDn = new LdapDN((String)uniqueMember.get(ii));
            memberDn.normalize(this.normalizerMapping);
            newAdministrators.add(memberDn.toNormName());
        }
        this.administrators = newAdministrators;
    }

    public void delete(NextInterceptor nextInterceptor, LdapDN name) throws NamingException {
        if (!this.enabled) {
            nextInterceptor.delete(name);
            return;
        }
        LdapDN principalDn = DefaultAuthorizationService.getPrincipal().getJndiName();
        if (name.toString().equals("")) {
            String msg = "The rootDSE cannot be deleted!";
            throw new LdapNoPermissionException(msg);
        }
        if (name.toNormName().equals(ADMIN_GROUP_DN_NORMALIZED.toNormName())) {
            String msg = "The Administrators group cannot be deleted!";
            throw new LdapNoPermissionException(msg);
        }
        if (this.isTheAdministrator(name)) {
            String msg = "User " + principalDn;
            msg = msg + " does not have permission to delete the admin account.";
            msg = msg + " No one not even the admin can delete this account!";
            throw new LdapNoPermissionException(msg);
        }
        if (name.size() > 2 && name.startsWith((Name)USER_BASE_DN) && !this.isAnAdministrator(principalDn)) {
            String msg = "User " + principalDn;
            msg = msg + " does not have permission to delete the user account: ";
            msg = msg + name + ". Only the admin can delete user accounts.";
            throw new LdapNoPermissionException(msg);
        }
        if (name.size() > 2 && name.startsWith((Name)GROUP_BASE_DN) && !this.isAnAdministrator(principalDn)) {
            String msg = "User " + principalDn;
            msg = msg + " does not have permission to delete the group entry: ";
            msg = msg + name + ". Only the admin can delete groups.";
            throw new LdapNoPermissionException(msg);
        }
        nextInterceptor.delete(name);
    }

    private final boolean isTheAdministrator(LdapDN normalizedDn) {
        return normalizedDn.toNormName() == "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system" || normalizedDn.toNormName().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
    }

    private final boolean isAnAdministrator(LdapDN normalizedDn) throws NamingException {
        if (this.isTheAdministrator(normalizedDn)) {
            return true;
        }
        return this.administrators.contains(normalizedDn.toNormName());
    }

    public boolean hasEntry(NextInterceptor nextInterceptor, LdapDN name) throws NamingException {
        return super.hasEntry(nextInterceptor, name);
    }

    public void modify(NextInterceptor nextInterceptor, LdapDN name, int modOp, Attributes attrs) throws NamingException {
        if (this.enabled) {
            this.protectModifyAlterations(name);
            nextInterceptor.modify(name, modOp, attrs);
            if (name.toNormName().equals(ADMIN_GROUP_DN_NORMALIZED.toNormName())) {
                this.loadAdministrators();
            }
            return;
        }
        nextInterceptor.modify(name, modOp, attrs);
    }

    public void modify(NextInterceptor nextInterceptor, LdapDN name, ModificationItemImpl[] items) throws NamingException {
        if (this.enabled) {
            this.protectModifyAlterations(name);
            nextInterceptor.modify(name, items);
            if (name.toNormName().equals(ADMIN_GROUP_DN_NORMALIZED.toNormName())) {
                this.loadAdministrators();
            }
            return;
        }
        nextInterceptor.modify(name, items);
    }

    private void protectModifyAlterations(LdapDN dn) throws NamingException {
        LdapDN principalDn = DefaultAuthorizationService.getPrincipal().getJndiName();
        if (dn.size() == 0) {
            String msg = "The rootDSE cannot be modified!";
            throw new LdapNoPermissionException(msg);
        }
        if (!this.isAnAdministrator(principalDn)) {
            if (dn.toNormName().equals(DefaultAuthorizationService.getPrincipal().getJndiName().toNormName())) {
                return;
            }
            if (dn.toNormName().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system")) {
                String msg = "User " + principalDn;
                msg = msg + " does not have permission to modify the account of the";
                msg = msg + " admin user.";
                throw new LdapNoPermissionException(msg);
            }
            if (dn.size() > 2 && dn.startsWith((Name)USER_BASE_DN_NORMALIZED)) {
                String msg = "User " + principalDn;
                msg = msg + " does not have permission to modify the account of the";
                msg = msg + " user " + dn + ".\nEven the owner of an account cannot";
                msg = msg + " modify it.\nUser accounts can only be modified by the";
                msg = msg + " administrator.";
                throw new LdapNoPermissionException(msg);
            }
            if (dn.size() > 2 && dn.startsWith((Name)GROUP_BASE_DN_NORMALIZED)) {
                String msg = "User " + principalDn;
                msg = msg + " does not have permission to modify the group entry ";
                msg = msg + dn.getUpName() + ".\nGroups can only be modified by the admin.";
                throw new LdapNoPermissionException(msg);
            }
        }
    }

    public void modifyRn(NextInterceptor nextInterceptor, LdapDN name, String newRn, boolean deleteOldRn) throws NamingException {
        if (this.enabled) {
            this.protectDnAlterations(name);
        }
        nextInterceptor.modifyRn(name, newRn, deleteOldRn);
    }

    public void move(NextInterceptor nextInterceptor, LdapDN oriChildName, LdapDN newParentName) throws NamingException {
        if (this.enabled) {
            this.protectDnAlterations(oriChildName);
        }
        nextInterceptor.move(oriChildName, newParentName);
    }

    public void move(NextInterceptor nextInterceptor, LdapDN oriChildName, LdapDN newParentName, String newRn, boolean deleteOldRn) throws NamingException {
        if (this.enabled) {
            this.protectDnAlterations(oriChildName);
        }
        nextInterceptor.move(oriChildName, newParentName, newRn, deleteOldRn);
    }

    private void protectDnAlterations(LdapDN dn) throws NamingException {
        LdapDN principalDn = DefaultAuthorizationService.getPrincipal().getJndiName();
        if (dn.toString().equals("")) {
            String msg = "The rootDSE cannot be moved or renamed!";
            throw new LdapNoPermissionException(msg);
        }
        if (dn.toNormName().equals(ADMIN_GROUP_DN_NORMALIZED.toNormName())) {
            throw new LdapNoPermissionException("The Administrators group cannot be moved or renamed!");
        }
        if (this.isTheAdministrator(dn)) {
            String msg = "User '" + principalDn.getUpName();
            msg = msg + "' does not have permission to move or rename the admin";
            msg = msg + " account.  No one not even the admin can move or";
            msg = msg + " rename " + dn + "!";
            throw new LdapNoPermissionException(msg);
        }
        if (dn.size() > 2 && dn.startsWith((Name)USER_BASE_DN_NORMALIZED) && !this.isAnAdministrator(principalDn)) {
            String msg = "User '" + principalDn;
            msg = msg + "' does not have permission to move or rename the user";
            msg = msg + " account: " + dn + ". Only the admin can move or";
            msg = msg + " rename user accounts.";
            throw new LdapNoPermissionException(msg);
        }
        if (dn.size() > 2 && dn.startsWith((Name)GROUP_BASE_DN_NORMALIZED) && !this.isAnAdministrator(principalDn)) {
            String msg = "User " + principalDn;
            msg = msg + " does not have permission to move or rename the group entry ";
            msg = msg + dn + ".\nGroups can only be moved or renamed by the admin.";
            throw new LdapNoPermissionException(msg);
        }
    }

    public Attributes lookup(NextInterceptor nextInterceptor, LdapDN name) throws NamingException {
        Attributes attributes = nextInterceptor.lookup(name);
        if (!this.enabled || attributes == null) {
            return attributes;
        }
        this.protectLookUp(name);
        return attributes;
    }

    public Attributes lookup(NextInterceptor nextInterceptor, LdapDN name, String[] attrIds) throws NamingException {
        Attributes attributes = nextInterceptor.lookup(name, attrIds);
        if (!this.enabled || attributes == null) {
            return attributes;
        }
        this.protectLookUp(name);
        return attributes;
    }

    private void protectLookUp(LdapDN normalizedDn) throws NamingException {
        LdapContext ctx = (LdapContext)InvocationStack.getInstance().peek().getCaller();
        LdapDN principalDn = ((ServerContext)((Object)ctx)).getPrincipal().getJndiName();
        if (!this.isAnAdministrator(principalDn)) {
            if (normalizedDn.size() > 2 && normalizedDn.startsWith((Name)USER_BASE_DN_NORMALIZED)) {
                if (normalizedDn.getNormName().equals(principalDn.getNormName())) {
                    return;
                }
                String msg = "Access to user account '" + normalizedDn + "' not permitted";
                msg = msg + " for user '" + principalDn + "'.  Only the admin can";
                msg = msg + " access user account information";
                throw new LdapNoPermissionException(msg);
            }
            if (normalizedDn.size() > 2 && normalizedDn.startsWith((Name)GROUP_BASE_DN_NORMALIZED)) {
                if (normalizedDn.getNormName().equals(principalDn.getNormName())) {
                    return;
                }
                String msg = "Access to group '" + normalizedDn + "' not permitted";
                msg = msg + " for user '" + principalDn + "'.  Only the admin can";
                msg = msg + " access group information";
                throw new LdapNoPermissionException(msg);
            }
            if (this.isTheAdministrator(normalizedDn)) {
                if (normalizedDn.getNormName().equals(principalDn.getNormName())) {
                    return;
                }
                String msg = "Access to admin account not permitted for user '";
                msg = msg + principalDn + "'.  Only the admin can";
                msg = msg + " access admin account information";
                throw new LdapNoPermissionException(msg);
            }
        }
    }

    public NamingEnumeration search(NextInterceptor nextInterceptor, LdapDN base, Map env, ExprNode filter, SearchControls searchCtls) throws NamingException {
        NamingEnumeration e = nextInterceptor.search(base, env, filter, searchCtls);
        if (!this.enabled) {
            return e;
        }
        Invocation invocation = InvocationStack.getInstance().peek();
        return new SearchResultFilteringEnumeration(e, searchCtls, invocation, new SearchResultFilter(){

            public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
                return DefaultAuthorizationService.this.isSearchable(invocation, result);
            }
        });
    }

    public NamingEnumeration list(NextInterceptor nextInterceptor, LdapDN base) throws NamingException {
        NamingEnumeration e = nextInterceptor.list(base);
        if (!this.enabled) {
            return e;
        }
        Invocation invocation = InvocationStack.getInstance().peek();
        return new SearchResultFilteringEnumeration(e, null, invocation, new SearchResultFilter(){

            public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
                return DefaultAuthorizationService.this.isSearchable(invocation, result);
            }
        });
    }

    private boolean isSearchable(Invocation invocation, SearchResult result) throws NamingException {
        LdapDN principalDn = ((ServerContext)invocation.getCaller()).getPrincipal().getJndiName();
        LdapDN dn = new LdapDN(result.getName());
        dn.normalize(this.normalizerMapping);
        if (this.isAnAdministrator(principalDn)) {
            return true;
        }
        boolean isSelfRead = dn.toNormName().equals(principalDn.toNormName());
        if (isSelfRead) {
            return true;
        }
        if (dn.size() > 2 && (dn.toNormName().endsWith(USER_BASE_DN_NORMALIZED.toNormName()) || dn.toNormName().endsWith(GROUP_BASE_DN_NORMALIZED.toNormName()))) {
            return false;
        }
        return !this.isTheAdministrator(dn);
    }
}

