/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.Collection;
import java.util.Iterator;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.server.core.subtree.SubtreeEvaluator;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.AuthenticationLevel;
import org.apache.directory.shared.ldap.aci.UserClass;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;

public class RelatedUserClassFilter
implements ACITupleFilter {
    private static final LdapDN ROOTDSE_NAME = LdapDN.EMPTY_LDAPDN;
    private final SubtreeEvaluator subtreeEvaluator;

    public RelatedUserClassFilter(SubtreeEvaluator subtreeEvaluator) {
        this.subtreeEvaluator = subtreeEvaluator;
    }

    public Collection filter(Collection tuples, OperationScope scope, PartitionNexusProxy proxy, Collection userGroupNames, LdapDN userName, Attributes userEntry, AuthenticationLevel authenticationLevel, LdapDN entryName, String attrId, Object attrValue, Attributes entry, Collection microOperations) throws NamingException {
        if (tuples.size() == 0) {
            return tuples;
        }
        Iterator i = tuples.iterator();
        while (i.hasNext()) {
            ACITuple tuple = (ACITuple)i.next();
            if (tuple.isGrant()) {
                if (this.isRelated(userGroupNames, userName, userEntry, entryName, tuple.getUserClasses()) && authenticationLevel.compareTo((Object)tuple.getAuthenticationLevel()) >= 0) continue;
                i.remove();
                continue;
            }
            if (this.isRelated(userGroupNames, userName, userEntry, entryName, tuple.getUserClasses()) || authenticationLevel.compareTo((Object)tuple.getAuthenticationLevel()) < 0) continue;
            i.remove();
        }
        return tuples;
    }

    private boolean isRelated(Collection userGroupNames, LdapDN userName, Attributes userEntry, LdapDN entryName, Collection userClasses) throws NamingException {
        Iterator i = userClasses.iterator();
        while (i.hasNext()) {
            UserClass userClass = (UserClass)i.next();
            if (userClass == UserClass.ALL_USERS) {
                return true;
            }
            if (userClass == UserClass.THIS_ENTRY) {
                if (!userName.equals((Object)entryName)) continue;
                return true;
            }
            if (userClass instanceof UserClass.Name) {
                UserClass.Name nameUserClass = (UserClass.Name)userClass;
                if (!nameUserClass.getNames().contains(userName)) continue;
                return true;
            }
            if (userClass instanceof UserClass.UserGroup) {
                UserClass.UserGroup userGroupUserClass = (UserClass.UserGroup)userClass;
                Iterator j = userGroupNames.iterator();
                while (j.hasNext()) {
                    LdapDN userGroupName = (LdapDN)j.next();
                    if (userGroupName == null || !userGroupUserClass.getNames().contains(userGroupName)) continue;
                    return true;
                }
                continue;
            }
            if (userClass instanceof UserClass.Subtree) {
                UserClass.Subtree subtree = (UserClass.Subtree)userClass;
                if (!this.matchUserClassSubtree(userName, userEntry, subtree)) continue;
                return true;
            }
            throw new InternalError("Unexpected userClass: " + userClass.getClass().getName());
        }
        return false;
    }

    private boolean matchUserClassSubtree(LdapDN userName, Attributes userEntry, UserClass.Subtree subtree) throws NamingException {
        Iterator i = subtree.getSubtreeSpecifications().iterator();
        while (i.hasNext()) {
            SubtreeSpecification subtreeSpec = (SubtreeSpecification)i.next();
            if (!this.subtreeEvaluator.evaluate(subtreeSpec, (Name)ROOTDSE_NAME, (Name)userName, userEntry.get("userClass"))) continue;
            return true;
        }
        return false;
    }
}

