/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.configuration;

import java.io.Serializable;
import java.util.Hashtable;
import org.apache.directory.server.core.configuration.ConfigurationException;
import org.apache.directory.server.core.configuration.MutableStartupConfiguration;

public abstract class Configuration
implements Cloneable,
Serializable {
    public static final String JNDI_KEY = Configuration.class.getName();
    public static final String DEFAULT_INSTANCE_ID = "default";
    private String instanceId = "default";

    public static Configuration toConfiguration(Hashtable jndiEnvironment) {
        Object value = jndiEnvironment.get(JNDI_KEY);
        if (value == null) {
            MutableStartupConfiguration msc = new MutableStartupConfiguration();
            jndiEnvironment.put(JNDI_KEY, msc);
            return msc;
        }
        if (!(value instanceof Configuration)) {
            throw new ConfigurationException("Not an ApacheDS configuration: " + value);
        }
        return (Configuration)value;
    }

    protected Configuration() {
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    protected void setInstanceId(String instanceId) {
        this.instanceId = instanceId = instanceId.trim();
    }

    public void validate() {
    }

    public Hashtable toJndiEnvironment() {
        Hashtable<String, Configuration> env = new Hashtable<String, Configuration>();
        env.put(JNDI_KEY, this);
        return env;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

