/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.event;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.event.Evaluator;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.Normalizer;

public class SubstringEvaluator
implements Evaluator {
    private OidRegistry oidRegistry;
    private AttributeTypeRegistry attributeTypeRegistry;

    public SubstringEvaluator(OidRegistry oidRegistry, AttributeTypeRegistry attributeTypeRegistry) {
        this.oidRegistry = oidRegistry;
        this.attributeTypeRegistry = attributeTypeRegistry;
    }

    public boolean evaluate(ExprNode node, String dn, Attributes entry) throws NamingException {
        Pattern regex = null;
        SubstringNode snode = (SubstringNode)node;
        String oid = this.oidRegistry.getOid(snode.getAttribute());
        AttributeType type = this.attributeTypeRegistry.lookup(oid);
        Normalizer normalizer = type.getSubstr().getNormalizer();
        Attribute attr = entry.get(snode.getAttribute());
        if (null == attr) {
            return false;
        }
        try {
            regex = snode.getRegex(normalizer);
        }
        catch (PatternSyntaxException pse) {
            NamingException ne = new NamingException("SubstringNode '" + node + "' had " + "incorrect syntax");
            ne.setRootCause(pse);
            throw ne;
        }
        NamingEnumeration<?> list = attr.getAll();
        while (list.hasMore()) {
            String value = (String)normalizer.normalize(list.next());
            if (!regex.matcher(value).matches()) continue;
            list.close();
            return true;
        }
        return false;
    }
}

