/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.server.core.schema.AttributeTypeRegistryMonitor;
import org.apache.directory.server.core.schema.AttributeTypeRegistryMonitorAdapter;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.server.core.schema.bootstrap.BootstrapAttributeTypeRegistry;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.OidNormalizer;
import org.apache.directory.shared.ldap.util.JoinIterator;

public class GlobalAttributeTypeRegistry
implements AttributeTypeRegistry {
    private final Map byOid = new HashMap();
    private final Map oidToSchema = new HashMap();
    private final OidRegistry oidRegistry;
    private AttributeTypeRegistryMonitor monitor = new AttributeTypeRegistryMonitorAdapter();
    private BootstrapAttributeTypeRegistry bootstrap;
    private transient Map mapping;

    public GlobalAttributeTypeRegistry(BootstrapAttributeTypeRegistry bootstrap, OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
        if (this.oidRegistry == null) {
            throw new NullPointerException("the OID registry cannot be null");
        }
        this.bootstrap = bootstrap;
        if (this.bootstrap == null) {
            throw new NullPointerException("the bootstrap registry cannot be null");
        }
    }

    public void setMonitor(AttributeTypeRegistryMonitor monitor) {
        this.monitor = monitor;
    }

    public void register(String schema, AttributeType attributeType) throws NamingException {
        if (this.byOid.containsKey(attributeType.getOid()) || this.bootstrap.hasAttributeType(attributeType.getOid())) {
            NamingException e = new NamingException("attributeType w/ OID " + attributeType.getOid() + " has already been registered!");
            this.monitor.registerFailed(attributeType, e);
            throw e;
        }
        String[] names = attributeType.getNames();
        for (int ii = 0; ii < names.length; ++ii) {
            this.oidRegistry.register(names[ii], attributeType.getOid());
        }
        this.oidToSchema.put(attributeType.getOid(), schema);
        this.byOid.put(attributeType.getOid(), attributeType);
        this.monitor.registered(attributeType);
        if (this.mapping == null) {
            Map bootstrapMapping = this.bootstrap.getNormalizerMapping();
            this.mapping = new HashMap(bootstrapMapping.size());
            this.mapping.putAll(bootstrapMapping);
        }
        Normalizer normalizer = attributeType.getEquality().getNormalizer();
        OidNormalizer oidNormalizer = new OidNormalizer(attributeType.getOid(), normalizer);
        this.mapping.put(attributeType.getOid(), oidNormalizer);
        String[] aliases = attributeType.getNames();
        for (int jj = 0; jj < aliases.length; ++jj) {
            this.mapping.put(aliases[jj], oidNormalizer);
            this.mapping.put(aliases[jj].toLowerCase(), oidNormalizer);
        }
        this.bootstrap.registerDescendants(attributeType);
    }

    public AttributeType lookup(String id) throws NamingException {
        if (!this.byOid.containsKey(id = this.oidRegistry.getOid(id)) && !this.bootstrap.hasAttributeType(id)) {
            NamingException e = new NamingException("attributeType w/ OID " + id + " not registered!");
            this.monitor.lookupFailed(id, e);
            throw e;
        }
        AttributeType attributeType = (AttributeType)this.byOid.get(id);
        if (attributeType == null) {
            attributeType = this.bootstrap.lookup(id);
        }
        this.monitor.lookedUp(attributeType);
        return attributeType;
    }

    public boolean hasAttributeType(String id) {
        try {
            if (this.oidRegistry.hasOid(id)) {
                return this.byOid.containsKey(this.oidRegistry.getOid(id)) || this.bootstrap.hasAttributeType(id);
            }
        }
        catch (NamingException e) {
            return false;
        }
        return false;
    }

    public String getSchemaName(String id) throws NamingException {
        if (this.oidToSchema.containsKey(id = this.oidRegistry.getOid(id))) {
            return (String)this.oidToSchema.get(id);
        }
        if (this.bootstrap.getSchemaName(id) != null) {
            return this.bootstrap.getSchemaName(id);
        }
        throw new NamingException("OID " + id + " not found in oid to " + "schema name map!");
    }

    public Iterator list() {
        return new JoinIterator(new Iterator[]{this.byOid.values().iterator(), this.bootstrap.list()});
    }

    public Map getNormalizerMapping() throws NamingException {
        if (this.mapping == null) {
            Map bootstrapMapping = this.bootstrap.getNormalizerMapping();
            this.mapping = new HashMap((this.byOid.size() << 1) + bootstrapMapping.size());
            this.mapping.putAll(bootstrapMapping);
            Iterator ii = this.byOid.values().iterator();
            while (ii.hasNext()) {
                AttributeType type = (AttributeType)ii.next();
                OidNormalizer oidNormalizer = new OidNormalizer(type.getOid(), type.getEquality().getNormalizer());
                this.mapping.put(type.getOid(), oidNormalizer);
                String[] aliases = type.getNames();
                for (int jj = 0; jj < aliases.length; ++jj) {
                    this.mapping.put(aliases[jj], oidNormalizer);
                    this.mapping.put(aliases[jj].toLowerCase(), oidNormalizer);
                }
            }
        }
        return Collections.unmodifiableMap(this.mapping);
    }

    public Iterator descendants(String ancestorId) throws NamingException {
        return this.bootstrap.descendants(ancestorId);
    }

    public boolean hasDescendants(String ancestorId) throws NamingException {
        return this.bootstrap.hasDescendants(ancestorId);
    }
}

