/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.bootstrap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.server.core.schema.OidRegistryMonitor;
import org.apache.directory.server.core.schema.OidRegistryMonitorAdapter;
import org.apache.directory.shared.ldap.util.StringTools;

public class BootstrapOidRegistry
implements OidRegistry {
    private Map byOid = new HashMap();
    private Map byName = new HashMap();
    private OidRegistryMonitor monitor = new OidRegistryMonitorAdapter();

    public String getOid(String name) throws NamingException {
        if (StringTools.isEmpty((String)name)) {
            throw new NamingException("name should not be empty");
        }
        if (StringTools.isDigit((char)name.charAt(0))) {
            return name;
        }
        if (this.byName.containsKey(name)) {
            String oid = (String)this.byName.get(name);
            this.monitor.oidResolved(name, oid);
            return oid;
        }
        String lowerCase = name.trim().toLowerCase();
        if (!name.equals(lowerCase) && this.byName.containsKey(lowerCase)) {
            String oid = (String)this.byName.get(lowerCase);
            this.monitor.oidResolved(name, lowerCase, oid);
            this.byName.put(name, oid);
            return oid;
        }
        NamingException fault = new NamingException("OID for name '" + name + "' was not " + "found within the OID registry");
        this.monitor.oidResolutionFailed(name, fault);
        throw fault;
    }

    public boolean hasOid(String name) {
        if (this.byName.containsKey(name) || this.byOid.containsKey(name)) {
            return true;
        }
        String normalized = name.toLowerCase();
        return this.byName.containsKey(normalized) || this.byOid.containsKey(normalized);
    }

    public String getPrimaryName(String oid) throws NamingException {
        Object value = this.byOid.get(oid);
        if (null == value) {
            NamingException fault = new NamingException("OID '" + oid + "' was not found within the OID registry");
            this.monitor.oidDoesNotExist(oid, fault);
            throw fault;
        }
        if (value instanceof String) {
            this.monitor.nameResolved(oid, (String)value);
            return (String)value;
        }
        String name = (String)((List)value).get(0);
        this.monitor.nameResolved(oid, name);
        return name;
    }

    public List getNameSet(String oid) throws NamingException {
        Object value = this.byOid.get(oid);
        if (null == value) {
            NamingException fault = new NamingException("OID '" + oid + "' was not found within the OID registry");
            this.monitor.oidDoesNotExist(oid, fault);
            throw fault;
        }
        if (value instanceof String) {
            List list = Collections.singletonList(value);
            this.monitor.namesResolved(oid, list);
            return list;
        }
        this.monitor.namesResolved(oid, (List)value);
        return (List)value;
    }

    public Iterator list() {
        return Collections.unmodifiableSet(this.byOid.keySet()).iterator();
    }

    public Map getOidByName() {
        return this.byName;
    }

    public Map getNameByOid() {
        return this.byOid;
    }

    public void register(String name, String oid) {
        Object value;
        if (!Character.isDigit(oid.charAt(0))) {
            throw new RuntimeException("Swap the parameter order: the oid does not start with a digit!");
        }
        String lowerCase = name.toLowerCase();
        if (!lowerCase.equals(name)) {
            this.byName.put(lowerCase, oid);
        }
        this.byName.put(name, oid);
        this.byName.put(oid, oid);
        if (!this.byOid.containsKey(oid)) {
            value = name;
        } else {
            value = this.byOid.get(oid);
            if (value instanceof String) {
                Object existingName = value;
                if (((String)existingName).equalsIgnoreCase(name)) {
                    return;
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add(name);
                list.add((String)value);
                value = list;
            } else if (value instanceof ArrayList) {
                ArrayList list = (ArrayList)value;
                for (int ii = 0; ii < list.size(); ++ii) {
                    if (name.equalsIgnoreCase((String)list.get(ii))) continue;
                    return;
                }
                list.add(name);
            }
        }
        this.byOid.put(oid, value);
        this.monitor.registered(name, oid);
    }

    OidRegistryMonitor getMonitor() {
        return this.monitor;
    }

    void setMonitor(OidRegistryMonitor monitor) {
        this.monitor = monitor;
    }
}

