/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.bootstrap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.server.core.schema.SyntaxRegistry;
import org.apache.directory.server.core.schema.SyntaxRegistryMonitor;
import org.apache.directory.server.core.schema.SyntaxRegistryMonitorAdapter;
import org.apache.directory.shared.ldap.schema.Syntax;

public class BootstrapSyntaxRegistry
implements SyntaxRegistry {
    private final Map byOid;
    private final Map oidToSchema;
    private final OidRegistry oidRegistry;
    private SyntaxRegistryMonitor monitor = null;

    public BootstrapSyntaxRegistry(OidRegistry registry) {
        this.oidRegistry = registry;
        this.byOid = new HashMap();
        this.oidToSchema = new HashMap();
        this.monitor = new SyntaxRegistryMonitorAdapter();
    }

    public Syntax lookup(String id) throws NamingException {
        if (this.byOid.containsKey(id = this.oidRegistry.getOid(id))) {
            Syntax syntax = (Syntax)this.byOid.get(id);
            this.monitor.lookedUp(syntax);
            return syntax;
        }
        NamingException fault = new NamingException("Unknown syntax OID " + id);
        this.monitor.lookupFailed(id, fault);
        throw fault;
    }

    public void register(String schema, Syntax syntax) throws NamingException {
        if (this.byOid.containsKey(syntax.getOid())) {
            NamingException e = new NamingException("syntax w/ OID " + syntax.getOid() + " has already been registered!");
            this.monitor.registerFailed(syntax, e);
            throw e;
        }
        this.oidRegistry.register(syntax.getName(), syntax.getOid());
        this.byOid.put(syntax.getOid(), syntax);
        this.oidToSchema.put(syntax.getOid(), schema);
        this.monitor.registered(syntax);
    }

    public boolean hasSyntax(String id) {
        if (this.oidRegistry.hasOid(id)) {
            try {
                return this.byOid.containsKey(this.oidRegistry.getOid(id));
            }
            catch (NamingException e) {
                return false;
            }
        }
        return false;
    }

    public String getSchemaName(String id) throws NamingException {
        if (this.oidToSchema.containsKey(id = this.oidRegistry.getOid(id))) {
            return (String)this.oidToSchema.get(id);
        }
        throw new NamingException("OID " + id + " not found in oid to " + "schema name map!");
    }

    SyntaxRegistryMonitor getMonitor() {
        return this.monitor;
    }

    void setMonitor(SyntaxRegistryMonitor monitor) {
        this.monitor = monitor;
    }

    public Iterator list() {
        return this.byOid.values().iterator();
    }
}

