/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.update;

import com.install4j.api.launcher.ApplicationLauncher;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.openthinclient.manager.util.http.config.NetworkConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeProcessExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeProcessExecutor.class);

    public static void executeManagerUpdateCheck(String install4jID, NetworkConfiguration.ProxyConfiguration proxyConfiguration, final Consumer<Integer> callback) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-q");
        args.add("-v");
        args.add("-console");
        args.add("-Dinstall4j.noProxyAutoDetect=true,sys.confirmedUpdateInstallation=true");
        if (proxyConfiguration != null && proxyConfiguration.isEnabled()) {
            args.add("-DproxySet=true");
            args.add("-DproxyHost=" + proxyConfiguration.getHost());
            args.add("-DproxyPort=" + proxyConfiguration.getPort());
            if (proxyConfiguration.getUser() != null && proxyConfiguration.getPassword() != null) {
                args.add("-DproxyAuth=true");
                args.add("-DproxyAuthUser=" + proxyConfiguration.getUser());
                args.add("-DproxyAuthPassword=" + proxyConfiguration.getPassword());
            }
        }
        try {
            LOGGER.info("Launch Application with id={} and params={}", (Object)install4jID, (Object)args.toArray(new String[args.size()]));
            ApplicationLauncher.launchApplication((String)install4jID, (String[])args.toArray(new String[args.size()]), (boolean)false, (ApplicationLauncher.Callback)new ApplicationLauncher.Callback(){

                public void exited(int exitValue) {
                    LOGGER.info("Installer exited with code {}", (Object)exitValue);
                    callback.accept(exitValue);
                }

                public void prepareShutdown() {
                    LOGGER.info("Application shutdown");
                    callback.accept(0);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Exception ", (Throwable)e);
            callback.accept(-1);
        }
    }
}

