/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.transactionmanager;

import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.util.IdentityMap;
import org.exolab.castor.jdo.conf.JdoConf;
import org.exolab.castor.jdo.conf.TransactionDemarcation;
import org.exolab.castor.jdo.transactionmanager.TransactionManagerAcquireException;
import org.exolab.castor.jdo.transactionmanager.TransactionManagerFactory;
import org.exolab.castor.jdo.transactionmanager.TransactionManagerFactoryRegistry;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.util.Messages;

public final class TransactionManagerRegistry {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$exolab$castor$jdo$transactionmanager$TransactionManagerRegistry == null ? (class$org$exolab$castor$jdo$transactionmanager$TransactionManagerRegistry = TransactionManagerRegistry.class$("org.exolab.castor.jdo.transactionmanager.TransactionManagerRegistry")) : class$org$exolab$castor$jdo$transactionmanager$TransactionManagerRegistry));
    private static final String LOCAL_TX_NAME = "local";
    private static IdentityMap _managers = new IdentityMap();
    static /* synthetic */ Class class$org$exolab$castor$jdo$transactionmanager$TransactionManagerRegistry;

    public static synchronized TransactionManager getTransactionManager(JdoConf jdoConf) throws MappingException {
        TransactionManager manager;
        if (_managers.containsKey(jdoConf)) {
            manager = (TransactionManager)_managers.get(jdoConf);
        } else {
            String mode = null;
            TransactionDemarcation demarcation = jdoConf.getTransactionDemarcation();
            if (LOCAL_TX_NAME.equals(demarcation.getMode())) {
                mode = LOCAL_TX_NAME;
            } else if (demarcation.getTransactionManager() != null) {
                mode = demarcation.getTransactionManager().getName();
            } else {
                String msg = Messages.message("jdo.transaction.missingConfiguration");
                LOG.error((Object)msg);
                throw new MappingException(msg);
            }
            TransactionManagerFactory factory = TransactionManagerFactoryRegistry.getTransactionManagerFactory(mode);
            if (factory == null) {
                String msg = Messages.format("jdo.transaction.missingFactory", mode);
                LOG.error((Object)msg);
                throw new MappingException(msg);
            }
            try {
                manager = factory.getTransactionManager(jdoConf);
            }
            catch (TransactionManagerAcquireException ex) {
                String msg = Messages.format("jdo.transaction.failToGetManager", mode);
                LOG.error((Object)msg, (Throwable)ex);
                throw new MappingException(msg, ex);
            }
            _managers.put(jdoConf, manager);
        }
        return manager;
    }

    private TransactionManagerRegistry() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

