/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.HashMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.castor.persist.TransactionContext;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.XAResourceSource;

public final class XAResourceImpl
implements XAResource {
    private final LockEngine _engine;
    private final XAResourceSource _xaSource;

    public XAResourceImpl(LockEngine engine, XAResourceSource xaSource) {
        if (engine == null || xaSource == null) {
            throw new IllegalArgumentException("Argument 'engine' or xaSource' is null");
        }
        this._xaSource = xaSource;
        this._engine = engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(Xid xid, int flags) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        switch (flags) {
            case 0: {
                TransactionContext tx;
                HashMap hashMap = this._engine.getXATransactions();
                synchronized (hashMap) {
                    tx = (TransactionContext)this._engine.getXATransactions().get(xid);
                    if (tx == null) {
                        tx = this._xaSource.createTransactionContext(xid);
                        this._engine.getXATransactions().put(xid, tx);
                    }
                }
                this._xaSource.setTransactionContext(tx);
                break;
            }
            case 0x200000: 
            case 0x8000000: {
                TransactionContext tx = (TransactionContext)this._engine.getXATransactions().get(xid);
                if (tx == null || !tx.isOpen()) {
                    throw new XAException(-4);
                }
                this._xaSource.setTransactionContext(tx);
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
    }

    public synchronized void end(Xid xid, int flags) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        TransactionContext tx = (TransactionContext)this._engine.getXATransactions().get(xid);
        if (tx == null) {
            throw new XAException(-4);
        }
        if (this._xaSource.getTransactionContext() == null) {
            throw new XAException(-5);
        }
        switch (flags) {
            case 0x4000000: {
                break;
            }
            case 0x20000000: {
                this._xaSource.xaFailed();
                this._xaSource.setTransactionContext(null);
                if (!tx.isOpen()) break;
                try {
                    tx.rollback();
                }
                catch (Exception except) {}
                break;
            }
            case 0x2000000: {
                this._xaSource.setTransactionContext(null);
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void forget(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        HashMap hashMap = this._engine.getXATransactions();
        synchronized (hashMap) {
            TransactionContext tx = (TransactionContext)this._engine.getXATransactions().remove(xid);
            if (tx == null) {
                throw new XAException(-4);
            }
            if (this._xaSource.getTransactionContext() == tx) {
                this._xaSource.setTransactionContext(null);
            }
            if (tx.isOpen()) {
                try {
                    tx.rollback();
                }
                catch (Exception except) {
                    // empty catch block
                }
                throw new XAException(-6);
            }
        }
    }

    public synchronized int prepare(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        TransactionContext tx = (TransactionContext)this._engine.getXATransactions().get(xid);
        if (tx == null) {
            throw new XAException(-4);
        }
        switch (tx.getStatus()) {
            case 0: 
            case 2: {
                try {
                    if (tx.prepare()) {
                        return 0;
                    }
                    return 3;
                }
                catch (TransactionAbortedException except) {
                    throw new XAException(100);
                }
                catch (IllegalStateException except) {
                    throw new XAException(-6);
                }
            }
            case 1: {
                throw new XAException(100);
            }
        }
        throw new XAException(-6);
    }

    public synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        TransactionContext tx = (TransactionContext)this._engine.getXATransactions().get(xid);
        if (tx == null) {
            throw new XAException(-4);
        }
        switch (tx.getStatus()) {
            case 3: {
                return;
            }
            case 4: {
                throw new XAException(6);
            }
            case 2: {
                try {
                    tx.commit();
                    break;
                }
                catch (TransactionAbortedException except) {
                    throw new XAException(6);
                }
                catch (IllegalStateException except) {
                    throw new XAException(-6);
                }
            }
        }
        throw new XAException(-6);
    }

    public synchronized void rollback(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        TransactionContext tx = (TransactionContext)this._engine.getXATransactions().get(xid);
        if (tx == null) {
            throw new XAException(-4);
        }
        switch (tx.getStatus()) {
            case 3: {
                throw new XAException(7);
            }
            case 4: {
                return;
            }
            case 0: 
            case 1: {
                try {
                    tx.rollback();
                }
                catch (IllegalStateException except) {
                    throw new XAException(-6);
                }
                return;
            }
        }
        throw new XAException(-6);
    }

    public Xid[] recover(int flags) throws XAException {
        return null;
    }

    public synchronized boolean isSameRM(XAResource xaRes) throws XAException {
        if (xaRes == null || !(xaRes instanceof XAResourceImpl)) {
            return false;
        }
        return this._engine == ((XAResourceImpl)xaRes)._engine;
    }

    public boolean setTransactionTimeout(int timeout) {
        TransactionContext tx = this._xaSource.getTransactionContext();
        if (tx != null && tx.isOpen()) {
            tx.setTransactionTimeout(timeout);
            return true;
        }
        return false;
    }

    public int getTransactionTimeout() {
        TransactionContext tx = this._xaSource.getTransactionContext();
        if (tx != null && tx.isOpen()) {
            return tx.getTransactionTimeout();
        }
        return 0;
    }
}

