/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.runtime.web.comptest.ui.tests;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.VerticalLayout;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.PackageManagerConfiguration;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.pkgmgr.PackageManagerTaskSummary;
import org.openthinclient.pkgmgr.SourcesList;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.db.PackageInstalledContent;
import org.openthinclient.pkgmgr.db.Source;
import org.openthinclient.pkgmgr.exception.SourceIntegrityViolationException;
import org.openthinclient.pkgmgr.op.InstallPlan;
import org.openthinclient.pkgmgr.op.InstallPlanStep;
import org.openthinclient.pkgmgr.op.PackageListUpdateReport;
import org.openthinclient.pkgmgr.op.PackageManagerOperation;
import org.openthinclient.pkgmgr.op.PackageManagerOperationReport;
import org.openthinclient.pkgmgr.op.PackageManagerOperationResolver;
import org.openthinclient.progress.ListenableProgressFuture;
import org.openthinclient.runtime.web.comptest.ui.tests.ComponentTest;
import org.openthinclient.util.dpkg.LocalPackageRepository;
import org.openthinclient.web.pkgmngr.ui.InstallationPlanSummaryDialog;
import org.vaadin.viritin.button.MButton;

public class InstallationPlanSummaryDialogTest
extends VerticalLayout
implements ComponentTest {
    private static final long serialVersionUID = 5697534476324346265L;
    private final InstallationPlanSummaryDialog dialog;

    public InstallationPlanSummaryDialogTest() {
        this.setSpacing(true);
        PackageManager packageManager = this.createDummyPackageManager();
        PackageManagerOperation op = packageManager.createOperation();
        InstallPlan ip = op.getInstallPlan();
        this.dialog = new InstallationPlanSummaryDialog(op, packageManager);
        this.addComponent((Component)new MButton("Open").withListener((Button.ClickListener & Serializable)e -> this.dialog.open(false)));
        this.addComponent((Component)new MButton("Close").withListener((Button.ClickListener & Serializable)e -> this.dialog.close()));
        this.addComponent((Component)new MButton("Add Install").withListener((Button.ClickListener & Serializable)e -> this.addInstallStep(ip)));
        this.addComponent((Component)new MButton("Add Uninstall").withListener((Button.ClickListener & Serializable)e -> this.addUninstallStep(ip)));
        this.addComponent((Component)new MButton("Add Update").withListener((Button.ClickListener & Serializable)e -> this.addUpdateStep(ip)));
    }

    private void addInstallStep(InstallPlan ip) {
        ip.getSteps().add(new InstallPlanStep.PackageInstallStep(this.createPackage("test-pkg", "1.2-3")));
        this.dialog.update();
    }

    private void addUninstallStep(InstallPlan ip) {
        ip.getSteps().add(new InstallPlanStep.PackageUninstallStep(this.createPackage("dumb-pkg", "0.1-21")));
        this.dialog.update();
    }

    private void addUpdateStep(InstallPlan ip) {
        ip.getSteps().add(new InstallPlanStep.PackageVersionChangeStep(this.createPackage("test-pkg", "1.2-3"), this.createPackage("old-pkg", "1.5-3")));
        this.dialog.update();
    }

    private Package createPackage(String name, String version) {
        Package pkg = new Package();
        pkg.setName(name);
        pkg.setVersion(version);
        return pkg;
    }

    @Override
    public String getTitle() {
        return "Installation Summary Dialog";
    }

    @Override
    public String getDetails() {
        return "Summary of Steps to be executed based on an InstallPlan.";
    }

    @Override
    public Component get() {
        return this;
    }

    private PackageManager createDummyPackageManager() {
        PackageManager packageManager = new PackageManager(){

            public ListenableProgressFuture<PackageListUpdateReport> updateCacheDB() {
                return null;
            }

            public boolean isInstalled(Package pkg) {
                return false;
            }

            public boolean isInstallable(Package pkg) {
                return false;
            }

            public Collection<Package> getUpdateablePackages() {
                return null;
            }

            public SourcesList getSourcesList() {
                return null;
            }

            public LocalPackageRepository getLocalPackageRepository() {
                return null;
            }

            public Collection<Package> getInstalledPackages() {
                return null;
            }

            public Collection<Package> getInstallablePackagesWithoutInstalledOfSameVersion() {
                return null;
            }

            public Collection<Package> getInstallablePackages() throws PackageManagerException {
                return null;
            }

            public long getFreeDiskSpace() throws PackageManagerException {
                return 0L;
            }

            public PackageManagerConfiguration getConfiguration() {
                return null;
            }

            public Collection<String> getChangelogFile(Package package1) throws IOException {
                return null;
            }

            public PackageManagerTaskSummary fetchTaskSummary() {
                return null;
            }

            public ListenableProgressFuture<PackageManagerOperationReport> execute(PackageManagerOperation operation) {
                return null;
            }

            public PackageManagerOperation createOperation() {
                return new PackageManagerOperation(){

                    public void uninstall(Package pkg) {
                    }

                    public void resolve() {
                    }

                    public boolean isResolved() {
                        return false;
                    }

                    public void install(Package pkg) {
                    }

                    public boolean hasPackagesToUninstall() {
                        return false;
                    }

                    public Collection<PackageManagerOperation.UnresolvedDependency> getUnresolved() {
                        return null;
                    }

                    public Collection<Package> getSuggested() {
                        return null;
                    }

                    public PackageManagerOperationResolver.ResolveState getResolveState() {
                        return null;
                    }

                    public InstallPlan getInstallPlan() {
                        return null;
                    }

                    public Collection<PackageManagerOperation.PackageConflict> getConflicts() {
                        return null;
                    }
                };
            }

            public void close() throws PackageManagerException {
            }

            public boolean addWarning(String warning) {
                return false;
            }

            public void deleteSource(Source source) throws SourceIntegrityViolationException {
            }

            public Source saveSource(Source source) {
                return null;
            }

            public Collection<Source> findAllSources() {
                return null;
            }

            public void saveSources(List<Source> sources) {
            }

            public ListenableProgressFuture<PackageListUpdateReport> deleteSourcePackagesFromCacheDB(Source source) {
                return null;
            }

            public List<PackageInstalledContent> getInstalledPackageContents(Package pkg) {
                return null;
            }
        };
        return packageManager;
    }
}

