/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.common.license;

import java.time.LocalDate;

public class License {
    String server;
    String name;
    String email;
    String details;
    Integer count;
    LocalDate softExpiredDate;
    LocalDate expiredDate;
    LocalDate createdDate;

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getDetails() {
        return this.details;
    }

    public Integer getCount() {
        return this.count;
    }

    public LocalDate getSoftExpiredDate() {
        return this.softExpiredDate;
    }

    public LocalDate getExpiredDate() {
        return this.expiredDate;
    }

    public LocalDate getCreatedDate() {
        return this.createdDate;
    }

    public static State getState(License license, String serverID, int clientCount) {
        if (license == null) {
            return clientCount >= 50 ? State.REQUIRED_MISSING : State.OK;
        }
        return license.getState(serverID, clientCount);
    }

    public State getState(String serverID, int clientCount) {
        LocalDate now = LocalDate.now();
        if (!serverID.equals(this.server)) {
            return State.INVALID;
        }
        if (this.createdDate.plusDays(31L).isBefore(now)) {
            return State.REQUIRED_TOO_OLD;
        }
        if (this.createdDate.plusDays(2L).isBefore(now)) {
            return clientCount >= 50 ? State.REQUIRED_OLD : State.OLD;
        }
        if (this.expiredDate.isBefore(now)) {
            return clientCount >= 50 ? State.REQUIRED_EXPIRED : State.EXPIRED;
        }
        if (this.softExpiredDate.isBefore(now)) {
            return State.SOFT_EXPIRED;
        }
        if (clientCount > this.count) {
            return State.TOO_MANY;
        }
        return State.OK;
    }

    public static enum State {
        REQUIRED_TOO_OLD,
        REQUIRED_OLD,
        REQUIRED_EXPIRED,
        SOFT_EXPIRED,
        TOO_MANY,
        OK,
        INVALID,
        REQUIRED_MISSING,
        TOO_OLD,
        OLD,
        EXPIRED;

    }
}

