/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openthinclient.pkgmgr.db.Package;

public class PackageManagerUtils {
    public List<Package> reduceToLatestVersion(List<Package> packages) {
        HashMap releaseSeen = new HashMap();
        HashMap<String, Package> previewSeen = new HashMap<String, Package>();
        for (Package pkg : packages) {
            HashMap<String, Package> seen;
            HashMap<String, Package> hashMap = seen = pkg.getVersion().isPreview() ? previewSeen : releaseSeen;
            if (!seen.containsKey(pkg.getName())) {
                seen.put(pkg.getName(), pkg);
                continue;
            }
            Package p = (Package)seen.get(pkg.getName());
            if (p.getVersion().compareTo(pkg.getVersion()) > 0) continue;
            seen.replace(pkg.getName(), pkg);
        }
        ArrayList<Package> result = new ArrayList<Package>();
        result.addAll(releaseSeen.values());
        for (Map.Entry entry : previewSeen.entrySet()) {
            String name = (String)entry.getKey();
            Package pkg = (Package)entry.getValue();
            if (releaseSeen.containsKey(name) && ((Package)releaseSeen.get(name)).getVersion().compareTo(pkg.getVersion()) >= 0) continue;
            result.add(pkg);
        }
        return result;
    }

    public static Package parse(String p) {
        Package pkg;
        if (p.split("_\\d").length > 1) {
            int separatorIdx = p.indexOf("_");
            String name = p.substring(0, separatorIdx);
            String version = p.substring(separatorIdx + 1);
            pkg = PackageManagerUtils.createPackage(name, version);
        } else {
            pkg = PackageManagerUtils.createPackage(p, null);
        }
        return pkg;
    }

    public static Package createPackage(String name, String version) {
        Package pkg = new Package();
        pkg.setName(name);
        if (version != null) {
            pkg.setVersion(version);
        }
        return pkg;
    }
}

