/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr.db;

import org.openthinclient.pkgmgr.db.InstallationLogEntryRepository;
import org.openthinclient.pkgmgr.db.InstallationRepository;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.db.PackageInstalledContentRepository;
import org.openthinclient.pkgmgr.db.PackageRepository;
import org.openthinclient.pkgmgr.db.Source;
import org.openthinclient.pkgmgr.db.SourceRepository;
import org.openthinclient.pkgmgr.db.Version;

public class PackageManagerDatabase {
    private final SourceRepository sourceRepository;
    private final PackageRepository packageRepository;
    private final InstallationRepository installationRepository;
    private final InstallationLogEntryRepository installationLogEntryRepository;
    private final PackageInstalledContentRepository installedContentRepository;

    public PackageManagerDatabase(SourceRepository sourceRepository, PackageRepository packageRepository, InstallationRepository installationRepository, InstallationLogEntryRepository installationLogEntryRepository, PackageInstalledContentRepository installedContentRepository) {
        this.sourceRepository = sourceRepository;
        this.packageRepository = packageRepository;
        this.installationRepository = installationRepository;
        this.installationLogEntryRepository = installationLogEntryRepository;
        this.installedContentRepository = installedContentRepository;
    }

    public SourceRepository getSourceRepository() {
        return this.sourceRepository;
    }

    public PackageRepository getPackageRepository() {
        return this.packageRepository;
    }

    public InstallationRepository getInstallationRepository() {
        return this.installationRepository;
    }

    public InstallationLogEntryRepository getInstallationLogEntryRepository() {
        return this.installationLogEntryRepository;
    }

    public PackageInstalledContentRepository getInstalledContentRepository() {
        return this.installedContentRepository;
    }

    public Package getBySourceAndNameAndVersion(Source source, String name, Version version) {
        if (version != null && version.getDebianRevision() != null) {
            return this.getPackageRepository().getBySourceAndNameAndVersionWithRevision(source, name, version.getEpoch(), version.getUpstreamVersion(), version.getDebianRevision());
        }
        return this.getPackageRepository().getBySourceAndNameAndVersionWithRevisionIsNull(source, name, version.getEpoch(), version.getUpstreamVersion());
    }
}

