/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.util.dpkg;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.db.Version;
import org.openthinclient.util.dpkg.PackageReferenceList;
import org.openthinclient.util.dpkg.PackageReferenceListParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackagesListParser {
    private static final Logger LOG = LoggerFactory.getLogger(PackagesListParser.class);

    public List<Package> parse(InputStream stream) throws IOException {
        PackageSource pkg = new PackageSource(stream);
        return pkg.getPackageIndex();
    }

    private class PackageSource {
        private List<Package> packageIndex;

        public PackageSource(InputStream stream) throws IOException {
            this.update(stream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(InputStream stream) throws IOException {
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new InputStreamReader(stream));
            try {
                String line;
                this.packageIndex = new ArrayList<Package>();
                while ((line = br.readLine()) != null) {
                    if (line.length() == 0) {
                        this.packageIndex.add(this.createPackage(lines));
                        lines.clear();
                        continue;
                    }
                    lines.add(line);
                }
            }
            finally {
                br.close();
                stream.close();
            }
        }

        private Package createPackage(List<String> specLines) {
            String currentSection = null;
            HashMap<String, String> controlTable = new HashMap<String, String>();
            for (String line : specLines) {
                currentSection = this.parseControlFileLine(controlTable, line, currentSection);
            }
            Package dpkgPackage = new Package();
            this.populateFromControlTable(dpkgPackage, controlTable);
            return dpkgPackage;
        }

        private String parseControlFileLine(Map<String, String> controlTable, String line, String currentSection) {
            if (line.startsWith(" ")) {
                if (null == currentSection) {
                    LOG.warn("Ignoring line starting with blank: no preceding section: \"" + line + "\"");
                } else {
                    String existing;
                    if (line.equals(" .")) {
                        line = "\n";
                    }
                    if ((existing = controlTable.get(currentSection)) != null) {
                        controlTable.put(currentSection, existing + line);
                    } else {
                        controlTable.put(currentSection, line);
                    }
                }
            } else if (line.indexOf(": ") > 0) {
                int index = line.indexOf(": ");
                String section = line.substring(0, index);
                String value = line.substring(index + 2);
                currentSection = section;
                if (section.equalsIgnoreCase("Description")) {
                    controlTable.put("Short-Description", value);
                } else {
                    controlTable.put(section, value);
                }
            } else {
                LOG.warn("Ignoring unparseable line: \"" + line + "\"");
            }
            return currentSection;
        }

        private void populateFromControlTable(Package pkg, Map<String, String> controlTable) {
            pkg.setArchitecture(this.getValue(controlTable, "Architecture"));
            pkg.setChangedBy(this.getValue(controlTable, "Changed-By"));
            pkg.setDate(this.getValue(controlTable, "Date"));
            pkg.setDescription(this.getValue(controlTable, "Description"));
            pkg.setDistribution(this.getValue(controlTable, "Distribution"));
            pkg.setEssential(this.getValue(controlTable, "Essential", "no").equalsIgnoreCase("yes"));
            pkg.setLicense(this.getValue(controlTable, "License"));
            pkg.setSize(Long.parseLong(this.getValue(controlTable, "Size", "-1")));
            pkg.setInstalledSize(Long.parseLong(this.getValue(controlTable, "Installed-Size", "-1")));
            pkg.setMaintainer(this.getValue(controlTable, "Maintainer"));
            pkg.setName(this.getValue(controlTable, "Package"));
            pkg.setPriority(this.getValue(controlTable, "Priority"));
            pkg.setSection(this.getValue(controlTable, "Section"));
            pkg.setVersion(Version.parse(controlTable.get("Version")));
            pkg.setMD5sum(this.getValue(controlTable, "MD5sum"));
            pkg.setFilename(this.getValue(controlTable, "Filename"));
            pkg.setShortDescription(this.getValue(controlTable, "Short-Description"));
            pkg.setConflicts(this.parsePackageReference(controlTable, "Conflicts"));
            pkg.setDepends(this.parsePackageReference(controlTable, "Depends"));
            pkg.setEnhances(this.parsePackageReference(controlTable, "Enhances"));
            pkg.setPreDepends(this.parsePackageReference(controlTable, "Pre-Depends"));
            pkg.setProvides(this.parsePackageReference(controlTable, "Provides"));
            pkg.setRecommends(this.parsePackageReference(controlTable, "Recommends"));
            pkg.setReplaces(this.parsePackageReference(controlTable, "Replaces"));
        }

        private PackageReferenceList parsePackageReference(Map<String, String> controlTable, String fieldName) {
            String value = this.getValue(controlTable, fieldName, null);
            if (value == null) {
                return new PackageReferenceList();
            }
            return new PackageReferenceListParser().parse(value);
        }

        private String getValue(Map controlTable, String fieldName) {
            return this.getValue(controlTable, fieldName, null);
        }

        private String getValue(Map controlTable, String fieldName, String defaultValue) {
            if (controlTable.containsKey(fieldName)) {
                return (String)controlTable.get(fieldName);
            }
            return defaultValue;
        }

        public List<Package> getPackageIndex() {
            return this.packageIndex;
        }
    }
}

