/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.syslogd;

import java.io.IOException;
import org.openthinclient.service.common.Service;
import org.openthinclient.syslogd.Log4JSyslogDaemon;
import org.openthinclient.syslogd.SyslogDaemon;
import org.openthinclient.syslogd.SyslogServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogService
implements Service<SyslogServiceConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(SyslogService.class);
    private SyslogDaemon daemon;
    private Thread daemonThread;
    private SyslogServiceConfiguration configuration;

    public void setConfiguration(SyslogServiceConfiguration configuration) {
        this.configuration = configuration;
    }

    public SyslogServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public Class<SyslogServiceConfiguration> getConfigurationClass() {
        return SyslogServiceConfiguration.class;
    }

    public void startService() throws Exception {
        try {
            this.daemon = new Log4JSyslogDaemon(0 != this.configuration.getSyslogPort() ? this.configuration.getSyslogPort() : 514);
            this.daemonThread = new Thread((Runnable)this.daemon, "Syslog daemon");
            this.daemonThread.setDaemon(true);
            this.daemonThread.start();
            logger.info("Syslog service launched");
        }
        catch (IOException e) {
            logger.error("Exception launching Syslog service", (Throwable)e);
            throw e;
        }
    }

    public void stopService() throws Exception {
        if (null != this.daemon) {
            this.daemon.shutdown();
            this.daemonThread.join(5000L);
            if (this.daemonThread.isAlive()) {
                logger.error("Syslog daemon did not shut down in time.");
            } else {
                logger.info("Syslog service shut down.");
            }
        }
    }
}

