/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.tftp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.directory.shared.ldap.util.Base64;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.schema.provider.SchemaLoadingException;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.common.model.spring.ProfilePropertySource;
import org.openthinclient.common.model.util.Config;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.tftp.tftpd.TFTPProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class PXEConfigTFTProvider
implements TFTPProvider {
    public static final Pattern TEMPLATE_REPLACEMENT_PATTERN = Pattern.compile("\\$\\{([^\\}]+)\\}");
    private static final Logger LOGGER = LoggerFactory.getLogger(PXEConfigTFTProvider.class);
    private final RealmService realmService;
    private final ClientService clientService;
    private final Path tftpHome;
    private final Path fallbackTemplatePath;

    public PXEConfigTFTProvider(Path tftpHome, RealmService realmService, ClientService clientService, Path fallbackTemplatePath) throws DirectoryException {
        this.tftpHome = tftpHome;
        this.realmService = realmService;
        this.clientService = clientService;
        this.fallbackTemplatePath = fallbackTemplatePath;
    }

    @Override
    public long getLength(SocketAddress peer, SocketAddress local, String arg0, String arg1) throws IOException {
        return -1L;
    }

    @Override
    public InputStream getStream(SocketAddress peer, SocketAddress local, String prefix, String fileName) throws IOException {
        LOGGER.info("Got request for " + fileName);
        if (fileName.contains("/") || fileName.length() != 20) {
            throw new FileNotFoundException("Don't know what to make of this file name: " + fileName);
        }
        String hwAddress = fileName.substring(3).replaceAll("-", ":");
        LOGGER.info("MAC is " + fileName);
        try {
            Client client = this.findClient(hwAddress);
            if (client != null) {
                LOGGER.info("Serving Client " + client);
                String file = this.getTemplate(client);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Template: " + file);
                }
                HashMap<String, String> globalVariables = new HashMap<String, String>();
                globalVariables.put("myip", ((InetSocketAddress)local).getAddress().getHostAddress());
                globalVariables.put("basedn", client.getRealm().getConnectionDescriptor().getBaseDN());
                CompositePropertySource propertySource = new CompositePropertySource("composite");
                propertySource.addFirstPropertySource((PropertySource)new ProfilePropertySource((Profile)client));
                propertySource.addPropertySource((PropertySource)new MapPropertySource("global", globalVariables));
                String processed = this.resolveVariables(file, (PropertySource<?>)propertySource);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Processed template: >>>>\n" + processed + "<<<<\n");
                }
                processed = this.compressTemplate(processed);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Template after cleanup: >>>>\n" + processed + "<<<<\n");
                }
                return new ByteArrayInputStream(processed.getBytes("ASCII"));
            }
        }
        catch (Exception e) {
            LOGGER.error("Can't query for client for PXE service", (Throwable)e);
        }
        throw new FileNotFoundException("Client " + fileName + " not Found");
    }

    protected String getTemplate(Client client) throws IOException {
        Path templatePath = this.getTemplatePath(client);
        return new String(Files.readAllBytes(templatePath), "ASCII");
    }

    protected Path getTemplatePath(Client client) {
        String templatePathString = (String)Config.BootOptions.BootLoaderTemplate.get((Profile)client);
        Path templatePath = null;
        if (templatePathString != null && templatePathString.trim().length() > 0 && !Files.isRegularFile(templatePath = this.tftpHome.resolve(templatePathString), new LinkOption[0])) {
            LOGGER.error("Boot template is not accessible: " + templatePath);
            templatePath = null;
        }
        if (templatePath == null) {
            return this.fallbackTemplatePath;
        }
        return templatePath;
    }

    protected String compressTemplate(String processed) {
        processed = processed.replaceAll("\\r", "");
        processed = processed.replaceAll("\\\\[\\t ]*\\n", "");
        processed = processed.replaceAll("[\\t ]+", " ");
        return processed;
    }

    protected String resolveVariables(String template, PropertySource<?> propertySource) {
        StringBuffer result = new StringBuffer();
        Matcher m = TEMPLATE_REPLACEMENT_PATTERN.matcher(template);
        while (m.find()) {
            String value;
            String variable = m.group(1);
            String encoding = "";
            if (variable.contains(":")) {
                encoding = variable.substring(0, variable.indexOf(":"));
                variable = variable.substring(variable.indexOf(":") + 1);
            }
            if (null != (value = (String)propertySource.getProperty(variable))) {
                value = this.resolveVariables(value, propertySource);
            } else {
                LOGGER.warn("Pattern refers to undefined variable " + variable);
                value = "";
            }
            try {
                if (encoding.equalsIgnoreCase("base64")) {
                    value = new String(Base64.encode((byte[])value.getBytes("UTF-8")));
                } else if (encoding.equalsIgnoreCase("urlencoded")) {
                    value = URLEncoder.encode(value, "UTF-8").replaceAll("\\+", "%20");
                } else if (encoding.length() > 0) {
                    LOGGER.warn("Ignoring unsupported encoding: " + encoding);
                }
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("That's silly: UTF8-encoding is unsupported!");
            }
            m.appendReplacement(result, value);
        }
        m.appendTail(result);
        return result.toString();
    }

    private Client findClient(String hwAddress) throws DirectoryException, SchemaLoadingException {
        Set found = this.clientService.findByHwAddress(hwAddress);
        if (found.size() > 0) {
            if (found.size() > 1) {
                LOGGER.warn("Found more than one client for hardware address " + hwAddress);
            }
            return (Client)found.iterator().next();
        }
        Realm realm = this.realmService.getDefaultRealm();
        realm.refresh();
        Config.BootOptions.PXEServicePolicyType policy = (Config.BootOptions.PXEServicePolicyType)Config.BootOptions.PXEServicePolicy.get((Profile)realm);
        if (policy == Config.BootOptions.PXEServicePolicyType.AnyClient) {
            return this.clientService.getDefaultClient();
        }
        return null;
    }

    private String streamAsString(InputStream is) throws IOException {
        int read;
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        while ((read = is.read(b)) >= 0) {
            s.write(b, 0, read);
        }
        is.close();
        return s.toString("ASCII");
    }
}

