/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.update;

import java.net.URI;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.openthinclient.manager.util.http.DownloadException;
import org.openthinclient.manager.util.http.DownloadManager;
import org.openthinclient.pkgmgr.db.Version;
import org.openthinclient.progress.NoopProgressReceiver;
import org.openthinclient.progress.ProgressReceiver;
import org.openthinclient.service.update.AvailableVersionChecker;
import org.openthinclient.service.update.UpdateCheckerEvent;
import org.openthinclient.service.update.UpdateDescriptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class UpdateChecker {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DownloadManager downloadManager;
    @Value(value="${application.version}")
    private String applicationVersionString;
    @Value(value="${otc.application.version.update.location}")
    private String updateLocation;
    private AvailableVersionChecker versionChecker;
    private ProgressReceiver noopProgressReceiver = new NoopProgressReceiver();
    private Version currentVersion;
    private Optional<String> newVersion = Optional.empty();
    private boolean hasNetworkError = false;
    private boolean isRunning = false;

    @PostConstruct
    public void init() {
        this.versionChecker = new AvailableVersionChecker(this.downloadManager);
        this.currentVersion = Version.parse((String)this.applicationVersionString);
    }

    public Optional<String> getNewVersion() {
        return this.newVersion;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean hasNetworkError() {
        return this.hasNetworkError;
    }

    public void fetchNewVersion() {
        this.isRunning = true;
        new Thread(() -> {
            boolean failure = false;
            try {
                UpdateDescriptor updateDescriptor = this.versionChecker.getVersion(new URI(this.updateLocation), this.noopProgressReceiver);
                String newVersionString = updateDescriptor.getNewVersion();
                int result = this.currentVersion.compareTo((Object)Version.parse((String)newVersionString));
                this.newVersion = result < 0 ? Optional.of(newVersionString) : Optional.empty();
                this.hasNetworkError = false;
            }
            catch (Exception ex) {
                this.hasNetworkError = ex instanceof DownloadException;
                failure = true;
            }
            this.isRunning = false;
            this.applicationContext.publishEvent((ApplicationEvent)new UpdateCheckerEvent(this, failure));
        }).start();
    }
}

