/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.manager.util.http.impl;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.openthinclient.manager.util.http.DownloadException;
import org.openthinclient.manager.util.http.DownloadManager;
import org.openthinclient.manager.util.http.NotFoundException;
import org.openthinclient.manager.util.http.StatusCodeException;
import org.openthinclient.manager.util.http.config.NetworkConfiguration;
import org.openthinclient.manager.util.http.impl.AbstractHttpAccessorBase;
import org.openthinclient.progress.ProgressReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public class HttpClientDownloadManager
extends AbstractHttpAccessorBase
implements DownloadManager {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientDownloadManager.class);
    final String userAgent;

    public HttpClientDownloadManager(NetworkConfiguration.ProxyConfiguration proxyConfig, String userAgent) {
        super(proxyConfig, userAgent);
        this.userAgent = userAgent;
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T> T download(URI uri, DownloadManager.DownloadProcessor<T> processor, ProgressReceiver progressReceiver) throws DownloadException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public <T> T download(URL url, DownloadManager.DownloadProcessor<T> processor, ProgressReceiver progressReceiver) throws DownloadException {
        try {
            return this.download(url.toURI(), processor, progressReceiver);
        }
        catch (URISyntaxException e) {
            throw new DownloadException(e);
        }
    }

    @Override
    public void downloadTo(URI uri, File targetFile) throws DownloadException {
        ClientHttpRequest request;
        try {
            request = this.createRequest(uri, HttpMethod.GET);
        }
        catch (IOException e) {
            throw new DownloadException("failed to create request", e);
        }
        try (ClientHttpResponse response = request.execute();){
            this.ensureSuccessful(uri, response);
            try (InputStream in = response.getBody();
                 FileOutputStream out = new FileOutputStream(targetFile);){
                ByteStreams.copy((InputStream)in, (OutputStream)out);
            }
        }
        catch (IOException e) {
            String message = "downloading from " + uri + " to " + targetFile.getAbsolutePath() + " failed";
            logger.error(message, (Throwable)e);
            throw new DownloadException(message, e);
        }
    }

    private void ensureSuccessful(URI uri, ClientHttpResponse response) throws IOException {
        HttpStatus statusCode = response.getStatusCode();
        if (statusCode == HttpStatus.NOT_FOUND) {
            throw new NotFoundException(uri, statusCode.value(), statusCode.getReasonPhrase());
        }
        if (!statusCode.is2xxSuccessful()) {
            throw new StatusCodeException(uri, statusCode.value(), statusCode.getReasonPhrase());
        }
    }

    @Override
    public void downloadTo(URL url, File targetFile) throws DownloadException {
        try {
            this.downloadTo(url.toURI(), targetFile);
        }
        catch (URISyntaxException e) {
            throw new DownloadException(e);
        }
    }

    @Override
    public void setProxy(NetworkConfiguration.ProxyConfiguration proxyConfiguration) {
        this.setupHttpClient(proxyConfiguration);
    }

    public String getUserAgent() {
        return this.userAgent;
    }
}

