/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.manager.util.http.impl;

import java.io.IOException;
import java.net.URI;
import org.openthinclient.manager.util.http.config.NetworkConfiguration;
import org.openthinclient.manager.util.http.impl.AbstractHttpAccessorBase;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public class HttpConnectionTester
extends AbstractHttpAccessorBase {
    public HttpConnectionTester(NetworkConfiguration.ProxyConfiguration proxyConfig) {
        super(proxyConfig, HttpConnectionTester.class.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result verifyConnectivity(Request testRequest) {
        ClientHttpRequest request;
        try {
            request = this.createRequest(testRequest.getUri(), testRequest.getMethod());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("request creation failed", e);
        }
        try (ClientHttpResponse response = request.execute();){
            boolean responseCodeSuccess;
            boolean bl = responseCodeSuccess = response.getStatusCode().is2xxSuccessful() || response.getStatusCode().is3xxRedirection();
            if (responseCodeSuccess) {
                Result result = Result.success();
                return result;
            }
            Result result = Result.error("Unexpected HTTP Status code received " + response.getRawStatusCode() + ". (" + response.getStatusText() + ")");
            return result;
        }
        catch (Exception e) {
            String message = "failed to connect to " + testRequest.getUri();
            this.logger.error((Object)message, (Throwable)e);
            return Result.error(message, e);
        }
    }

    public static class Result {
        private final boolean success;
        private final String message;
        private final Throwable error;

        private Result(boolean success, String message, Throwable error) {
            this.success = success;
            this.message = message;
            this.error = error;
        }

        public static Result success() {
            return new Result(true, null, null);
        }

        public static Result error(String message) {
            return Result.error(message, null);
        }

        public static Result error(String message, Throwable error) {
            return new Result(false, message, error);
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class Request {
        private final HttpMethod method;
        private final URI uri;

        public Request(URI uri) {
            this(uri, HttpMethod.GET);
        }

        public Request(URI uri, HttpMethod method) {
            this.method = method;
            this.uri = uri;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public URI getUri() {
            return this.uri;
        }
    }
}

