/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.util.dpkg.DPKGPackage;
import org.openthinclient.util.dpkg.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DPKGPackageFactory {
    private PackageManager pm;

    public DPKGPackageFactory(PackageManager pm) {
        this.pm = pm;
    }

    public List<Package> getPackage(File file) throws IOException {
        PackageSource pkg = new PackageSource(file);
        return pkg.getPackageIndex();
    }

    public List<Package> getPackage(InputStream stream) throws IOException {
        PackageSource pkg = new PackageSource(stream);
        return pkg.getPackageIndex();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PackageSource {
        private List<Package> packageIndex;

        public PackageSource(File cacheFile) throws IOException {
            FileInputStream fis = new FileInputStream(cacheFile);
            this.update(fis);
            fis.close();
        }

        public PackageSource(InputStream stream) throws IOException {
            this.update(stream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(InputStream stream) throws IOException {
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new InputStreamReader(stream));
            try {
                String line;
                this.packageIndex = new ArrayList<Package>();
                while ((line = br.readLine()) != null) {
                    if (line.length() == 0) {
                        Package pkg = new DPKGPackage(lines, DPKGPackageFactory.this.pm).getThis();
                        this.packageIndex.add(pkg);
                        lines.clear();
                        continue;
                    }
                    lines.add(line);
                }
            }
            finally {
                br.close();
                stream.close();
            }
        }

        public List<Package> getPackageIndex() {
            return this.packageIndex;
        }
    }
}

