/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr;

import com.levigo.util.preferences.PreferenceStoreHolder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.openthinclient.pkgmgr.DPKGPackageFactory;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.pkgmgr.PackageManagerTaskSummary;
import org.openthinclient.pkgmgr.connect.ConnectToServer;
import org.openthinclient.pkgmgr.connect.SearchForServerFile;
import org.openthinclient.util.dpkg.Package;
import org.openthinclient.util.dpkg.PackageDatabase;
import org.openthinclient.util.dpkg.UrlAndFile;

public class UpdateDatabase {
    private static String cacheDatabase;
    private static String changelogDir;
    private static final Logger logger;

    public UpdateDatabase(String cacheDatabase, String chlogDir) {
        UpdateDatabase.cacheDatabase = cacheDatabase;
        changelogDir = chlogDir;
    }

    public UpdateDatabase() {
    }

    public PackageDatabase doUpdate(boolean isStart, PackageManagerTaskSummary taskSummary) throws PackageManagerException {
        int i;
        if (!isStart) {
            try {
                PackageDatabase packDB = PackageDatabase.open(new File(cacheDatabase));
                packDB.save();
                return packDB;
            }
            catch (IOException e) {
                logger.error((Object)e);
                throw new PackageManagerException(e);
            }
        }
        List<UrlAndFile> updatedFiles = null;
        SearchForServerFile seFoSeFi = new SearchForServerFile();
        updatedFiles = seFoSeFi.checkForNewUpdatedFiles(taskSummary);
        if (null == updatedFiles) {
            throw new PackageManagerException(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("interface.noFilesAvailable", "No entry found for interface.noFilesAvailable"));
        }
        ArrayList<Package> packages = new ArrayList<Package>();
        for (i = 0; i < updatedFiles.size(); ++i) {
            try {
                ArrayList<Package> packageList = new ArrayList<Package>();
                packageList.addAll(new DPKGPackageFactory(null).getPackage(updatedFiles.get(i).getFile()));
                for (Package pkg : packageList) {
                    packages.add(pkg);
                    Package p = (Package)packages.get(packages.size() - 1);
                    p.setServerPath(updatedFiles.get(i).getUrl());
                    p.setChangelogDir(updatedFiles.get(i).getChangelogDir());
                    UpdateDatabase.downloadChangelogFile(pkg, changelogDir, updatedFiles.get(i).getChangelogDir(), taskSummary);
                }
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new PackageManagerException(e);
            }
        }
        PackageDatabase packDB = null;
        if (new File(cacheDatabase).isFile()) {
            new File(cacheDatabase).delete();
        }
        try {
            packDB = PackageDatabase.open(new File(cacheDatabase));
        }
        catch (IOException e1) {
            e1.printStackTrace();
            logger.error((Object)e1);
            throw new PackageManagerException(e1);
        }
        for (i = 0; i < packages.size(); ++i) {
            if (!packDB.isPackageInstalled(((Package)packages.get(i)).getName())) {
                packDB.addPackage((Package)packages.get(i));
                continue;
            }
            int n = packDB.getPackage(((Package)packages.get(i)).getName()).getVersion().compareTo(((Package)packages.get(i)).getVersion());
            if (n != -1) continue;
            packDB.addPackage((Package)packages.get(i));
        }
        try {
            packDB.save();
        }
        catch (IOException e) {
            logger.error((Object)e);
            e.printStackTrace();
            throw new PackageManagerException(e);
        }
        return packDB;
    }

    public PackageDatabase doUpdate(PackageManager pm, PackageManagerTaskSummary taskSummary) throws PackageManagerException {
        List<UrlAndFile> updatedFiles = null;
        SearchForServerFile seFoSeFi = new SearchForServerFile();
        updatedFiles = seFoSeFi.checkForNewUpdatedFiles(taskSummary);
        if (null == updatedFiles) {
            throw new PackageManagerException(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("interface.noFilesAvailable", "No entry found for interface.noFilesAvailable"));
        }
        ArrayList<Package> packages = new ArrayList<Package>();
        for (int i = 0; i < updatedFiles.size(); ++i) {
            try {
                ArrayList<Package> packageList = new ArrayList<Package>();
                packageList.addAll(new DPKGPackageFactory(pm).getPackage(updatedFiles.get(i).getFile()));
                for (Package pkg : packageList) {
                    packages.add(pkg);
                    Package p = (Package)packages.get(packages.size() - 1);
                    p.setServerPath(updatedFiles.get(i).getUrl());
                    p.setChangelogDir(updatedFiles.get(i).getChangelogDir());
                    UpdateDatabase.downloadChangelogFile(pkg, changelogDir, updatedFiles.get(i).getChangelogDir(), taskSummary);
                }
                continue;
            }
            catch (IOException e) {
                String errormessage = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("UpdateDatabase.doUpdate.GeneratePackages.IOException", "No entry found for UpdateDatabase.doUpdate.GeneratePackages.IOException");
                if (null != taskSummary) {
                    taskSummary.addWarning(errormessage + e);
                }
                logger.error((Object)errormessage, (Throwable)e);
                e.printStackTrace();
                throw new PackageManagerException(e);
            }
        }
        PackageDatabase packDB = null;
        if (new File(cacheDatabase).isFile()) {
            new File(cacheDatabase).delete();
        }
        try {
            packDB = PackageDatabase.open(new File(cacheDatabase));
        }
        catch (IOException e1) {
            e1.printStackTrace();
            logger.error((Object)PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("UpdateDatabase.doUpdate.OpenDatabase.IOException", "No entry found for UpdateDatabase.doUpdate.OpenDatabase.IOException"), (Throwable)e1);
        }
        for (int i = 0; i < packages.size(); ++i) {
            if (!packDB.isPackageInstalled(((Package)packages.get(i)).getName())) {
                packDB.addPackage((Package)packages.get(i));
                continue;
            }
            int n = packDB.getPackage(((Package)packages.get(i)).getName()).getVersion().compareTo(((Package)packages.get(i)).getVersion());
            if (n != -1) continue;
            packDB.addPackage((Package)packages.get(i));
        }
        try {
            packDB.save();
        }
        catch (IOException e) {
            logger.error((Object)PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("UpdateDatabase.doUpdate.SaveDatabase.IOException", "No entry found for UpdateDatabase.doUpdate.SaveDatabase.IOException"), (Throwable)e);
            e.printStackTrace();
        }
        return packDB;
    }

    private static boolean downloadChangelogFile(Package pkg, String changelogDirectory, String changeDir, PackageManagerTaskSummary taskSummary) throws PackageManagerException {
        boolean ret = false;
        try {
            int len;
            File changelogDir = new File(changelogDirectory + changeDir);
            String serverPath = pkg.getServerPath();
            serverPath = serverPath.substring(0, serverPath.lastIndexOf("/") + 1);
            BufferedInputStream in = new BufferedInputStream(new ConnectToServer(taskSummary).getInputStream(serverPath + pkg.getName() + ".changelog"));
            if (!changelogDir.isDirectory()) {
                changelogDir.mkdirs();
            }
            File rename = new File(changelogDir.getCanonicalPath(), pkg.getName() + ".changelog");
            FileOutputStream out = new FileOutputStream(rename);
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.close();
            in.close();
            ret = true;
        }
        catch (Exception e) {
            if (null != taskSummary) {
                taskSummary.addWarning(e.toString());
            }
            logger.warn((Object)e);
        }
        return ret;
    }

    static {
        logger = Logger.getLogger(UpdateDatabase.class);
    }
}

