/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr.connect;

import com.levigo.util.preferences.PreferenceStoreHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.pkgmgr.PackageManagerTaskSummary;
import org.openthinclient.pkgmgr.connect.ConnectToServer;
import org.openthinclient.pkgmgr.connect.FileName;
import org.openthinclient.util.dpkg.DPKGPackageManager;
import org.openthinclient.util.dpkg.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadFiles {
    private static final Logger logger = Logger.getLogger(DownloadFiles.class);
    private final DPKGPackageManager pkgmgr;

    public DownloadFiles(DPKGPackageManager pkgmgr) {
        this.pkgmgr = pkgmgr;
    }

    public boolean downloadAndMD5sumCheck(ArrayList<Package> packages, PackageManagerTaskSummary taskSummary) throws PackageManagerException {
        String archivesDir = PreferenceStoreHolder.getPreferenceStoreByName((String)"tempPackageManager").getPreferenceAsString("archivesDir", null);
        String partialDir = PreferenceStoreHolder.getPreferenceStoreByName((String)"tempPackageManager").getPreferenceAsString("partialDir", null);
        boolean ret = true;
        for (int i = 0; i < packages.size(); ++i) {
            String errorMessage;
            Package myPackage = packages.get(i);
            String packageFileName = myPackage.getFilename();
            String serverPath = myPackage.getServerPath();
            String[] archiveFile = new FileName().getLocationsForDownload(packageFileName, serverPath, archivesDir);
            String[] partialFile = new FileName().getLocationsForDownload(packageFileName, serverPath, partialDir);
            File fileToInstall = new File(partialFile[1]);
            File alreadyDownloadedFile = new File(archiveFile[1]);
            if (alreadyDownloadedFile.isFile() && alreadyDownloadedFile.renameTo(fileToInstall)) {
                if (this.checksum(fileToInstall, myPackage)) continue;
                ret = false;
                continue;
            }
            try {
                int len;
                InputStream in = new ConnectToServer(taskSummary).getInputStream(partialFile[0]);
                FileOutputStream out = new FileOutputStream(partialFile[1]);
                int buflength = 4096;
                double maxsize = this.pkgmgr.getMaxVolumeinByte();
                int maxProgress = new Double((double)this.pkgmgr.getMaxProgress() * 0.6).intValue();
                byte[] buf = new byte[4096];
                int anzahl = 0;
                int beforeStarting = this.pkgmgr.getActprogress();
                double leneee = 0.0;
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                    leneee += (double)len;
                    if (++anzahl % 25 != 0) continue;
                    this.pkgmgr.setActprogressPlusX(beforeStarting + new Double(leneee / maxsize * (double)maxProgress).intValue(), new Double(leneee / 1024.0).intValue(), new Double(myPackage.getSize() / 1024L).intValue(), myPackage.getName());
                }
                in.close();
                out.close();
                this.pkgmgr.setActprogressPlusX(beforeStarting + new Double(leneee / maxsize * (double)maxProgress).intValue(), new Double(leneee / 1024.0).intValue(), new Double(myPackage.getSize() / 1024L).intValue(), myPackage.getName());
                if (this.checksum(new File(partialFile[1]), myPackage)) continue;
                ret = false;
                continue;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                errorMessage = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("DownloadFiles.downloadAndMD5sumCheck.MalformedURL", "No entry found for DownloadFiles.downloadAndMD5sumCheck.MalformedURL");
                logger.error((Object)errorMessage);
                this.pkgmgr.addWarning(errorMessage);
                continue;
            }
            catch (IOException e) {
                errorMessage = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("DownloadFiles.downloadAndMD5sumCheck.IOException", "No entry found for DownloadFiles.downloadAndMD5sumCheck.IOException");
                e.printStackTrace();
                logger.error((Object)errorMessage);
                this.pkgmgr.addWarning(errorMessage);
            }
        }
        return ret;
    }

    public boolean checksum(File file, Package myPackage) {
        block7: {
            try {
                int len;
                MessageDigest md = MessageDigest.getInstance("MD5");
                FileInputStream in = new FileInputStream(file);
                byte[] buf = new byte[4096];
                while ((len = in.read(buf)) > 0) {
                    md.update(buf, 0, len);
                }
                in.close();
                byte[] fileMD5sum = md.digest();
                md.reset();
                if (myPackage.getMD5sum().equalsIgnoreCase(DownloadFiles.byteArrayToHexString(fileMD5sum))) {
                    String testFileName;
                    File parentFile = file.getParentFile();
                    if (parentFile != null && parentFile.exists()) {
                        parentFile = parentFile.getParentFile();
                    }
                    if (!file.renameTo(new File(testFileName = parentFile.getPath() + File.separator + file.getName()))) {
                        String errorMessage = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("DownloadFiles.checksum.md5different", "No entry found for DownloadFiles.checksum.md5different");
                        logger.error((Object)errorMessage);
                        this.pkgmgr.addWarning(errorMessage);
                        return false;
                    }
                    break block7;
                }
                String errorMessage = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("DownloadFiles.checksum.md5different", "No entry found for DownloadFiles.checksum.md5different");
                logger.error((Object)errorMessage);
                this.pkgmgr.addWarning(errorMessage);
                file.delete();
                return false;
            }
            catch (NoSuchAlgorithmException e1) {
                String errorMessage = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("DownloadFiles.checksum.NoSuchAlgorithmException", "No entry found for DownloadFiles.checksum.NoSuchAlgorithmException");
                e1.printStackTrace();
                logger.error((Object)errorMessage);
                this.pkgmgr.addWarning(errorMessage);
            }
            catch (IOException e) {
                String errorMessage = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("DownloadFiles.checksum.IOException", "No entry found for DownloadFiles.checksum.IOException");
                e.printStackTrace();
                logger.error((Object)errorMessage);
                this.pkgmgr.addWarning(errorMessage);
            }
        }
        return true;
    }

    public static String byteArrayToHexString(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            int v = b[i] & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase();
    }
}

