/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr.connect;

import com.levigo.util.preferences.PreferenceStoreHolder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.pkgmgr.PackageManagerTaskSummary;
import org.openthinclient.pkgmgr.connect.ConnectToServer;
import org.openthinclient.pkgmgr.connect.NameFileLocation;
import org.openthinclient.util.dpkg.UrlAndFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchForServerFile {
    private List<UrlAndFile> updateUrlAndFile;
    private static final String storeName = "tempPackageManager";
    private final String listsDir = PreferenceStoreHolder.getPreferenceStoreByName((String)"tempPackageManager").getPreferenceAsString("listsDir", null);
    private final String sourcesList = PreferenceStoreHolder.getPreferenceStoreByName((String)"tempPackageManager").getPreferenceAsString("sourcesList", null);
    private static final Logger logger = Logger.getLogger(SearchForServerFile.class);

    public List<UrlAndFile> checkForNewUpdatedFiles(PackageManagerTaskSummary taskSummary) throws PackageManagerException {
        this.getLines(taskSummary);
        if (this.updateUrlAndFile.size() == 0) {
            this.updateUrlAndFile = null;
            return this.updateUrlAndFile;
        }
        return this.updateUrlAndFile;
    }

    private void getLines(PackageManagerTaskSummary taskSummary) throws PackageManagerException {
        Pattern p = Pattern.compile("\\s*deb\\s+(ftp://|http://)(\\S+)\\s+((\\S+\\s*)*)(./){0,1}");
        if (this.updateUrlAndFile == null) {
            this.updateUrlAndFile = new ArrayList<UrlAndFile>();
        }
        try {
            String protocol;
            BufferedReader f = new BufferedReader(new FileReader(this.sourcesList));
            while ((protocol = f.readLine()) != null) {
                String adress;
                Matcher m = p.matcher(protocol);
                if (!m.matches()) continue;
                protocol = m.group(1);
                String host = m.group(2);
                String shares = m.group(3).trim().equalsIgnoreCase("./") ? "" : m.group(3).trim();
                if (shares == null) {
                    adress = protocol + host;
                } else {
                    shares = shares.replace(" ", "/");
                    if (!host.endsWith("/") && !shares.startsWith("/")) {
                        host = host + "/";
                    }
                    adress = host + shares;
                    while (adress.contains("//")) {
                        adress = adress.replace("//", "/");
                    }
                    adress = protocol + adress;
                }
                if (!adress.endsWith("/")) {
                    adress = adress + "/";
                }
                String changelogdir = adress;
                if ((changelogdir = changelogdir.substring(changelogdir.indexOf("//") + 2)).endsWith("/")) {
                    changelogdir = changelogdir.substring(0, changelogdir.lastIndexOf("/"));
                }
                changelogdir = changelogdir.replace('/', '_');
                changelogdir = changelogdir.replaceAll("\\.", "_");
                changelogdir = changelogdir.replaceAll("-", "_");
                changelogdir = changelogdir.replaceAll(":", "_COLON_");
                adress = adress + "Packages.gz";
                String serverFileLocation = adress.replaceAll(":", "_COLON_");
                NameFileLocation nfl = new NameFileLocation();
                try {
                    int len;
                    GZIPInputStream in = new GZIPInputStream(new ConnectToServer(taskSummary).getInputStream(adress));
                    String rename = new File(nfl.rename(serverFileLocation, this.listsDir)).getCanonicalPath();
                    FileOutputStream out = new FileOutputStream(rename);
                    byte[] buf = new byte[4096];
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.close();
                    in.close();
                    File file = new File(rename);
                    UrlAndFile uaf = new UrlAndFile(protocol + host, file, changelogdir);
                    this.updateUrlAndFile.add(uaf);
                }
                catch (Exception e) {
                    String message = "URL: " + adress + " caused exception";
                    if (null != taskSummary) {
                        logger.warn((Object)message, (Throwable)e);
                        taskSummary.addWarning(message + "\n" + e.toString());
                    } else {
                        logger.warn((Object)message, (Throwable)e);
                    }
                    e.printStackTrace();
                }
            }
            f.close();
        }
        catch (FileNotFoundException e) {
            String message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("sourcesList.corrupt", "Entry not found sourcesList.corrupt");
            if (null != taskSummary) {
                taskSummary.addWarning(message + "\n" + e.toString());
            }
            logger.warn((Object)message, (Throwable)e);
        }
        catch (IOException e) {
            String message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("SearchForServerFile.getLines.IOException", "Entry not found SearchForServerFile.getLines.IOException");
            if (null != taskSummary) {
                taskSummary.addWarning(message + "\n" + e.toString());
            }
            logger.warn((Object)message, (Throwable)e);
        }
    }
}

