/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.util.ar;

import java.io.IOException;
import java.util.Date;

public class AREntry {
    private String name;
    private long length;
    private Date date;
    private int mode;
    private int user;
    private int group;

    AREntry(String entryHeader) throws IOException {
        this.parseEntryHeader(entryHeader);
    }

    private void parseEntryHeader(String entryHeader) throws IOException {
        this.name = entryHeader.substring(0, 16).trim();
        try {
            this.date = new Date(Long.parseLong(entryHeader.substring(16, 28).trim()) * 1000L);
            this.user = Integer.parseInt(entryHeader.substring(28, 32).trim());
            this.group = Integer.parseInt(entryHeader.substring(34, 38).trim());
            this.mode = Integer.parseInt(entryHeader.substring(40, 47).trim(), 8);
            this.length = Long.parseLong(entryHeader.substring(48, 57).trim());
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid format of archive: entry header cannot be parsed");
        }
    }

    public Date getDate() {
        return this.date;
    }

    public int getGroup() {
        return this.group;
    }

    public long getLength() {
        return this.length;
    }

    public int getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public int getUser() {
        return this.user;
    }

    void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name + " " + this.length + " " + this.date + " " + this.mode + " " + this.user + "/" + this.group;
    }
}

