/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.util.dpkg;

import java.io.Serializable;
import java.util.Map;
import org.openthinclient.util.dpkg.ORReference;
import org.openthinclient.util.dpkg.Package;
import org.openthinclient.util.dpkg.PackageReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ANDReference
extends PackageReference
implements Serializable {
    private static final long serialVersionUID = 3257283634670415921L;
    private PackageReference[] refs;

    public ANDReference(String specifier) {
        if (specifier.trim().length() != 0) {
            String[] r = specifier.split("\\s*,\\s*");
            this.refs = new PackageReference[r.length];
            for (int i = 0; i < r.length; ++i) {
                this.refs[i] = r[i].indexOf("|") >= 0 ? new ORReference(r[i]) : new PackageReference(r[i]);
            }
        } else {
            this.refs = new PackageReference[0];
        }
    }

    @Override
    public String toString() {
        if (null == this.refs) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.refs.length; ++i) {
            PackageReference ref = this.refs[i];
            sb.append(ref.toString());
            if (i >= this.refs.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        if (-1 == this.hashCode) {
            this.hashCode = 98753249;
            for (PackageReference ref : this.refs) {
                this.hashCode ^= ref.hashCode();
            }
        }
        return this.hashCode;
    }

    @Override
    public boolean matches(Package pkg) {
        for (PackageReference r : this.refs) {
            if (!r.matches(pkg)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSatisfiedBy(Map<String, Package> pkgs) {
        for (PackageReference r : this.refs) {
            if (r.isSatisfiedBy(pkgs)) continue;
            return false;
        }
        return true;
    }

    public PackageReference[] getRefs() {
        return this.refs;
    }
}

