/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.util.dpkg;

import com.levigo.util.preferences.PreferenceStoreHolder;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.commons.io.FileSystemUtils;
import org.apache.log4j.Logger;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.pkgmgr.PackageManagerTaskSummary;
import org.openthinclient.pkgmgr.UpdateDatabase;
import org.openthinclient.pkgmgr.connect.DownloadFiles;
import org.openthinclient.util.dpkg.ANDReference;
import org.openthinclient.util.dpkg.DeepObjectCopy;
import org.openthinclient.util.dpkg.InstallationLogEntry;
import org.openthinclient.util.dpkg.ORReference;
import org.openthinclient.util.dpkg.Package;
import org.openthinclient.util.dpkg.PackageDatabase;
import org.openthinclient.util.dpkg.PackageReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DPKGPackageManager
implements PackageManager {
    private static final int OLDINSTALLDIR_FOR_DELETE = 0;
    private static final int INSTALLDIR_FOR_DELETE = 1;
    private static final Logger logger = Logger.getLogger(DPKGPackageManager.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private String installDir;
    private static String archivesDir;
    private String testinstallDir;
    private String oldInstallDir;
    private String listsDir;
    private List<PackagingConflict> conflicts = new ArrayList<PackagingConflict>();
    private PackageManagerTaskSummary taskSummary = new PackageManagerTaskSummary();
    private int actprogress;
    private final int maxProgress = 100;
    private long maxVolumeinByte;
    private final Thread shutdownHook;
    public static PackageDatabase installedPackages;
    public static PackageDatabase removedDB;
    public static PackageDatabase availablePackages;
    public static PackageDatabase archivesDB;
    private final List<Package> pack = new LinkedList<Package>();
    private final List<Package> packForDelete = new LinkedList<Package>();
    private HashMap<File, File> fromToFileMap;
    private List<File> removeDirectoryList;
    private boolean isDone = false;
    private int actually;
    private int maxFile;
    public String actPackName;

    public DPKGPackageManager(PackageDatabase availableDB, PackageDatabase removedDB, PackageDatabase installedDB, PackageDatabase archivesDB, Collection<String> locations, boolean removeItReally) throws IOException {
        installedPackages = installedDB;
        DPKGPackageManager.removedDB = removedDB;
        availablePackages = availableDB;
        DPKGPackageManager.archivesDB = archivesDB;
        int value = 0;
        for (String s : locations) {
            switch (value) {
                case 0: {
                    this.installDir = s;
                    break;
                }
                case 1: {
                    archivesDir = s;
                    break;
                }
                case 2: {
                    this.testinstallDir = s;
                    break;
                }
                case 3: {
                    this.oldInstallDir = s;
                    break;
                }
                case 4: {
                    this.listsDir = s;
                }
            }
            ++value;
        }
        this.shutdownHook = new Thread("PackageManager shutdown"){

            public void run() {
                try {
                    DPKGPackageManager.this.close();
                }
                catch (PackageManagerException e) {
                    e.printStackTrace();
                    logger.error((Object)e);
                    DPKGPackageManager.this.addWarning(e.toString());
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws PackageManagerException {
        if (null != this.shutdownHook) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        this.lock.writeLock().lock();
        try {
            installedPackages.save();
            availablePackages.save();
            removedDB.save();
            archivesDB.save();
            installedPackages.close();
            availablePackages.close();
            archivesDB.close();
            removedDB.close();
            installedPackages.finalize();
            availablePackages.finalize();
            archivesDB.finalize();
            removedDB.finalize();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.addWarning(e.toString());
            logger.error((Object)e);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.addWarning(e.toString());
            logger.error((Object)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void finalize() throws PackageManagerException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean installPackages(Collection<Package> firstinstallList) throws PackageManagerException {
        boolean ret = false;
        ArrayList<Package> installList = new ArrayList<Package>();
        for (Package pkg : firstinstallList) {
            if (pkg.isPackageManager()) {
                installList.add((Package)DeepObjectCopy.clone(pkg, this.taskSummary));
                continue;
            }
            installList.add(0, (Package)DeepObjectCopy.clone(pkg, this.taskSummary));
        }
        firstinstallList.removeAll(firstinstallList);
        ArrayList<File> filesToDelete = new ArrayList<File>();
        ArrayList<File> directoriesToDelete = new ArrayList<File>();
        ArrayList<Package> PackagesForDatabase = new ArrayList<Package>();
        ArrayList<InstallationLogEntry> log = new ArrayList<InstallationLogEntry>();
        int sizeOfS = 0;
        this.lock.writeLock().lock();
        try {
            TreeSet<File> s = new TreeSet<File>();
            int listlength = installList.size();
            int listactuallystands = 0;
            int actuallyProgress = this.getActprogress();
            for (Package pkg : installList) {
                pkg.install(new File(this.testinstallDir), log, archivesDir, this);
                ArrayList<File> dirsForPackage = new ArrayList<File>();
                ArrayList<File> filesForPackage = new ArrayList<File>();
                for (File fi : pkg.getDirectoryList()) {
                    if (fi.getPath().replace(this.testinstallDir, " ").equalsIgnoreCase(" ")) continue;
                    s.add(new File(fi.getPath().replace(this.testinstallDir, " ").trim()));
                    if (fi.getPath().replace(new File(this.testinstallDir).getPath(), "").length() == 0) continue;
                    dirsForPackage.add(new File(fi.getPath().replace(this.testinstallDir, "")));
                }
                for (File fi : pkg.getFileList()) {
                    if (fi.getPath().replace(this.testinstallDir, " ").equalsIgnoreCase(" ")) continue;
                    s.add(new File(fi.getPath().replace(this.testinstallDir, " ").trim()));
                    filesForPackage.add(new File(fi.getPath().replace(this.testinstallDir, "")));
                }
                pkg.setDirectoryList(dirsForPackage);
                pkg.setFileList(filesForPackage);
                PackagesForDatabase.add(pkg);
                this.setActprogress(actuallyProgress + new Double(++listactuallystands / listlength * 20).intValue());
            }
            actuallyProgress = this.getActprogress();
            sizeOfS = s.size();
            Iterator it = s.iterator();
            File iteratorFile = null;
            boolean secondTime = false;
            int iteratorFiles = 0;
            while (it.hasNext() || secondTime) {
                if (secondTime) {
                    secondTime = false;
                } else {
                    iteratorFile = (File)it.next();
                }
                if (this.testinstallDir.equalsIgnoreCase(iteratorFile.getPath())) {
                    iteratorFile = (File)it.next();
                }
                if (this.testinstallDir.equalsIgnoreCase(iteratorFile.getPath() + File.separator)) {
                    iteratorFile = (File)it.next();
                }
                File newFile = new File(this.installDir + iteratorFile.getPath());
                File oldFile = new File(this.testinstallDir + iteratorFile.getPath());
                if (!newFile.isDirectory() && oldFile.isDirectory()) {
                    if (!oldFile.renameTo(newFile)) {
                        this.addWarning(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.installPackages.problem1", "No entry found for packageManager.installPackages.problem1") + " " + newFile.getName() + " " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.installPackages.problem2", "No entry found for packageManager.installPackages.problem2"));
                        logger.error((Object)(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.installPackages.problem1", "No entry found for packageManager.installPackages.problem1") + " " + newFile.getName() + " " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.installPackages.problem2", "No entry found for packageManager.installPackages.problem2")));
                    }
                    boolean next = true;
                    while (it.hasNext() && next) {
                        File iteratorFileNext = (File)it.next();
                        if (iteratorFileNext.getPath().length() >= iteratorFile.getPath().length()) {
                            if (iteratorFile.getPath().equalsIgnoreCase(iteratorFileNext.getPath().substring(0, iteratorFile.getPath().length()))) {
                                if (new File(this.installDir + iteratorFileNext).isDirectory()) {
                                    directoriesToDelete.add(new File(this.testinstallDir + iteratorFileNext));
                                    continue;
                                }
                                if (new File(this.installDir + iteratorFileNext).isFile()) {
                                    filesToDelete.add(new File(this.testinstallDir + iteratorFileNext));
                                    continue;
                                }
                                next = false;
                                iteratorFile = iteratorFileNext;
                                continue;
                            }
                            next = false;
                            iteratorFile = iteratorFileNext;
                            continue;
                        }
                        next = false;
                        iteratorFile = iteratorFileNext;
                    }
                    if (this.testinstallDir.equalsIgnoreCase(iteratorFile.getPath()) && it.hasNext()) {
                        iteratorFile = (File)it.next();
                    }
                    if (this.testinstallDir.equalsIgnoreCase(iteratorFile.getPath() + File.separator) && it.hasNext()) {
                        iteratorFile = (File)it.next();
                    }
                    newFile = new File(this.installDir + iteratorFile.getPath());
                    oldFile = new File(this.testinstallDir + iteratorFile.getPath());
                }
                if (oldFile.isDirectory()) {
                    if (newFile.isDirectory()) {
                        directoriesToDelete.add(oldFile);
                    } else if (!newFile.isDirectory()) {
                        secondTime = true;
                    } else {
                        logger.error((Object)(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.installPackages.problem1", "No entry found for packageManager.installPackages.problem1") + " " + newFile.getName() + " " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.installPackages.problem2", "No entry found for packageManager.installPackages.problem2")));
                        this.addWarning(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.installPackages.problem1", "No entry found for packageManager.installPackages.problem1") + " " + newFile.getName() + " " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.installPackages.problem2", "No entry found for packageManager.installPackages.problem2"));
                    }
                } else if (oldFile.isFile()) {
                    if (newFile.isFile()) {
                        filesToDelete.add(oldFile);
                    } else if (!newFile.isFile()) {
                        if (!oldFile.renameTo(newFile)) {
                            this.addWarning(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.installPackages.problem1", "No entry found for packageManager.installPackages.problem1") + " " + newFile.getName() + " " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.installPackages.problem2", "No entry found for packageManager.installPackages.problem2"));
                            logger.error((Object)(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.installPackages.problem1", "No entry found for packageManager.installPackages.problem1") + " " + newFile.getName() + " " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.installPackages.problem2", "No entry found for packageManager.installPackages.problem2")));
                        }
                    } else {
                        this.addWarning(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.installPackages.problem1", "No entry found for packageManager.installPackages.problem1") + " " + newFile.getName() + " " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.installPackages.problem2", "No entry found for packageManager.installPackages.problem2"));
                        logger.error((Object)(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.installPackages.problem1", "No entry found for packageManager.installPackages.problem1") + " " + newFile.getName() + " " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.installPackages.problem2", "No entry found for packageManager.installPackages.problem2")));
                    }
                } else if (!(newFile.isFile() || newFile.isDirectory() || this.testinstallDir.equalsIgnoreCase(iteratorFile.getPath()) || this.testinstallDir.equalsIgnoreCase(iteratorFile.getPath() + File.separator))) {
                    logger.error((Object)(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.installPackages.problem1", "No entry found for packageManager.installPackages.problem1") + " " + newFile.getName() + " " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.installPackages.problem2", "No entry found for packageManager.installPackages.problem2")));
                    this.addWarning(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.installPackages.problem1", "No entry found for packageManager.installPackages.problem1") + " " + newFile.getName() + " " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.installPackages.problem2", "No entry found for packageManager.installPackages.problem2"));
                }
                this.setActprogress(actuallyProgress + new Double(++iteratorFiles / sizeOfS * 18).intValue());
            }
            for (Package pack : PackagesForDatabase) {
                installedPackages.addPackage(pack);
                installedPackages.save();
            }
            ret = true;
        }
        catch (PackageManagerException t) {
            t.printStackTrace();
            for (Package pkg : PackagesForDatabase) {
                for (File file : pkg.getFileList()) {
                    filesToDelete.add(new File(this.testinstallDir + file.getPath()));
                }
            }
            for (Package pkg : PackagesForDatabase) {
                for (File file : pkg.getDirectoryList()) {
                    filesToDelete.add(new File(this.testinstallDir + file.getPath()));
                }
            }
            this.rollbackInstallation(log);
            PackagesForDatabase = new ArrayList();
            logger.error((Object)t);
            this.addWarning(t.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error((Object)e);
            this.addWarning(e.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (filesToDelete != null && filesToDelete.size() > 0) {
            for (int n = filesToDelete.size() - 1; n > 0; --n) {
                if (!((File)filesToDelete.get(n)).isFile() || ((File)filesToDelete.get(n)).delete()) continue;
                this.addWarning(((File)filesToDelete.get(n)).getPath() + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("interface.notRemove", "No entry found for interface.notRemove"));
                logger.error((Object)(((File)filesToDelete.get(n)).getPath() + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("interface.notRemove", "No entry found for interface.notRemove")));
            }
        }
        if (directoriesToDelete != null && directoriesToDelete.size() > 0) {
            for (int n = directoriesToDelete.size() - 1; n > 0; --n) {
                if (!((File)directoriesToDelete.get(n)).isDirectory() || ((File)directoriesToDelete.get(n)).listFiles().length != 0 || ((File)directoriesToDelete.get(n)).delete()) continue;
                this.addWarning(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("interface.DirectoryUndeleteable", "No entry found for interface.DirectoryUndeleteable") + ((File)directoriesToDelete.get(n)).getName());
                logger.error((Object)(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("interface.DirectoryUndeleteable", "No entry found for interface.DirectoryUndeleteable") + ((File)directoriesToDelete.get(n)).getName()));
            }
        }
        return ret;
    }

    private void rollbackInstallation(List<InstallationLogEntry> log) {
        Collections.reverse(log);
        for (InstallationLogEntry entry : log) {
            switch (entry.getType()) {
                case FILE_INSTALLATION: {
                    logger.warn((Object)("Rollback: removing " + entry.getTargetFile()));
                    if (!entry.getTargetFile().exists() || entry.getTargetFile().delete()) break;
                    this.addWarning(entry.getTargetFile() + " " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("setProperties.notRemove", "No entry found for setProperties.notRemove"));
                    logger.error((Object)(entry.getTargetFile() + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("interface.notRemove", "No entry found for interface.notRemove")));
                    break;
                }
                case SYMLINK_INSTALLATION: {
                    logger.warn((Object)("Rollback: removing symlink " + entry.getTargetFile()));
                    if (!entry.getTargetFile().exists() || entry.getTargetFile().delete()) break;
                    this.addWarning(entry.getTargetFile() + " " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("setProperties.notRemove", "No entry found for setProperties.notRemove"));
                    logger.error((Object)(entry.getTargetFile() + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("interface.notRemove", "No entry found for interface.notRemove")));
                    break;
                }
                case FILE_MODIFICATION: {
                    logger.warn((Object)("Rollback: reverting modification on " + entry.getTargetFile()));
                    if (entry.getBackupFile().renameTo(entry.getTargetFile())) break;
                    this.addWarning(entry.getTargetFile() + " " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("setProperties.cantMove", "No entry found for setProperties.cantMove"));
                    logger.error((Object)(entry.getBackupFile() + " " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("setProperties.cantMove", "No entry found for setProperties.cantMove") + " " + entry.getTargetFile()));
                    break;
                }
                case FILE_REMOVAL: {
                    logger.warn((Object)("Rollback: reverting deletion of " + entry.getTargetFile()));
                    if (entry.getBackupFile().renameTo(entry.getTargetFile())) break;
                    this.addWarning(entry.getTargetFile() + " " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("setProperties.cantMove", "No entry found for setProperties.cantMove"));
                    logger.error((Object)(entry.getBackupFile() + " " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("setProperties.cantMove", "No entry found for setProperties.cantMove") + " " + entry.getTargetFile()));
                    break;
                }
                case DIRECTORY_CREATION: {
                    logger.warn((Object)("Rollback: reverting creation of directory " + entry.getTargetFile()));
                    if (entry.getTargetFile().delete()) break;
                    this.addWarning(entry.getTargetFile() + " " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("setProperties.cantMove", "No entry found for setProperties.cantMove"));
                    logger.error((Object)(entry.getTargetFile() + " " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("setProperties.cantMove", "No entry found for setProperties.cantMove")));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String checkForAlreadyInstalled(List<Package> installList) {
        this.lock.readLock().lock();
        try {
            String string;
            for (Package toBeInstalled : installList) {
                if (!installedPackages.isPackageInstalled(toBeInstalled.getName())) continue;
                if (this.conflicts == null) {
                    this.conflicts = new ArrayList<PackagingConflict>();
                }
                this.conflicts.add(new PackagingConflict(PackagingConflict.Type.ALREADY_INSTALLED, toBeInstalled));
            }
            if (this.conflicts.size() > 0) {
                string = this.conflicts.toString();
                return string;
            }
            string = "";
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean removeConflicts() {
        return null == this.conflicts || this.conflicts.removeAll(this.conflicts);
    }

    @Override
    public void invokeDeploymentScan() {
        try {
            ObjectName objectName = new ObjectName("jboss.deployment:flavor=URL,type=DeploymentScanner");
            MBeanServer server = MBeanServerFactory.findMBeanServer(null).get(0);
            server.invoke(objectName, "scan", new Object[0], new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.addWarning(e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Package> solveDependencies(Collection<Package> installList) {
        HashMap<PackageReference, List<Package>> unsatisfiedDependencies = new HashMap<PackageReference, List<Package>>();
        for (Package toBeInstalled : installList) {
            int x;
            int i;
            int j;
            if (toBeInstalled.getDepends() instanceof ANDReference) {
                PackageReference[] dependsPackRef = new PackageReference[((ANDReference)toBeInstalled.getDepends()).getRefs().length];
                for (j = 0; j < dependsPackRef.length; ++j) {
                    dependsPackRef[j] = ((ANDReference)toBeInstalled.getDepends()).getRefs()[j];
                }
                for (i = 0; i < dependsPackRef.length; ++i) {
                    if (dependsPackRef[i] instanceof ORReference) {
                        PackageReference[] deopendsOrPackRef = new PackageReference[((ORReference)dependsPackRef[i]).getRefs().length];
                        for (x = 0; x < deopendsOrPackRef.length; ++x) {
                            deopendsOrPackRef[x] = ((ORReference)dependsPackRef[i]).getRefs()[x];
                        }
                        for (x = 0; x < deopendsOrPackRef.length; ++x) {
                            this.addDependency(unsatisfiedDependencies, deopendsOrPackRef[0], toBeInstalled);
                        }
                        continue;
                    }
                    this.addDependency(unsatisfiedDependencies, dependsPackRef[i], toBeInstalled);
                }
            } else {
                this.addDependency(unsatisfiedDependencies, toBeInstalled.getDepends(), toBeInstalled);
            }
            if (toBeInstalled.getPreDepends() instanceof ANDReference) {
                PackageReference[] packRef = new PackageReference[((ANDReference)toBeInstalled.getPreDepends()).getRefs().length];
                for (j = 0; j < packRef.length; ++j) {
                    packRef[j] = ((ANDReference)toBeInstalled.getPreDepends()).getRefs()[j];
                }
                for (i = 0; i < packRef.length; ++i) {
                    if (packRef[i] instanceof ORReference) {
                        PackageReference[] orPackRef = new PackageReference[((ORReference)packRef[i]).getRefs().length];
                        for (x = 0; x < orPackRef.length; ++x) {
                            orPackRef[x] = ((ORReference)packRef[i]).getRefs()[x];
                        }
                        for (x = 0; x < orPackRef.length; ++x) {
                            this.addDependency(unsatisfiedDependencies, orPackRef[0], toBeInstalled);
                        }
                        continue;
                    }
                    this.addDependency(unsatisfiedDependencies, packRef[i], toBeInstalled);
                }
                continue;
            }
            this.addDependency(unsatisfiedDependencies, toBeInstalled.getPreDepends(), toBeInstalled);
        }
        HashMap<String, Package> virtualPackagesToBeInstalled = new HashMap<String, Package>();
        for (Package pkg : installList) {
            virtualPackagesToBeInstalled.put(pkg.getName(), pkg);
            if (pkg.getProvides() instanceof ANDReference) {
                for (PackageReference r : ((ANDReference)pkg.getProvides()).getRefs()) {
                    virtualPackagesToBeInstalled.put(r.getName(), pkg);
                }
                continue;
            }
            virtualPackagesToBeInstalled.put(pkg.getProvides().getName(), pkg);
        }
        this.lock.readLock().lock();
        try {
            Iterator i = unsatisfiedDependencies.keySet().iterator();
            while (i.hasNext()) {
                PackageReference ref = (PackageReference)i.next();
                if (!ref.isSatisfiedBy(installedPackages.getProvidedPackages()) && !ref.isSatisfiedBy(virtualPackagesToBeInstalled)) continue;
                i.remove();
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        ArrayList deps = new ArrayList(unsatisfiedDependencies.entrySet());
        Collections.sort(deps, new Comparator<Map.Entry<PackageReference, List<Package>>>(){

            @Override
            public int compare(Map.Entry<PackageReference, List<Package>> o1, Map.Entry<PackageReference, List<Package>> o2) {
                return o1.getKey().getName().compareTo(o2.getKey().getName());
            }
        });
        LinkedList<Package> ret = new LinkedList<Package>();
        boolean anotherDependency = false;
        boolean check = false;
        for (Map.Entry entry : deps) {
            this.lock.readLock().lock();
            try {
                for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                    if (availablePackages.getPackage(((PackageReference)entry.getKey()).getName()) == null) {
                        ArrayList<Package> provided = new ArrayList<Package>();
                        for (int t = 0; t < availablePackages.getProvidesPackages(((PackageReference)entry.getKey()).getName()).size(); ++t) {
                            provided.add(availablePackages.getProvidesPackages(((PackageReference)entry.getKey()).getName()).get(t));
                        }
                        if (provided.size() <= 0) continue;
                        String ausw = "";
                        BufferedReader in1 = new BufferedReader(new InputStreamReader(new DataInputStream(System.in)));
                        try {
                            ausw = in1.readLine();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        int prov = Integer.valueOf(ausw);
                        ret.add((Package)provided.get(prov - 1));
                        anotherDependency = true;
                        continue;
                    }
                    for (int n = 0; n < ret.size(); ++n) {
                        if (!((Package)ret.get(n)).getName().equalsIgnoreCase(((PackageReference)entry.getKey()).getName())) continue;
                        check = true;
                    }
                    for (int x = 0; x < this.pack.size(); ++x) {
                        if (!this.pack.get(x).getName().equalsIgnoreCase(((PackageReference)entry.getKey()).getName())) continue;
                        check = true;
                    }
                    if (!check) {
                        ret.add(availablePackages.getPackage(((PackageReference)entry.getKey()).getName()));
                        anotherDependency = true;
                    }
                    check = false;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        ArrayList<Package> samePackages = new ArrayList<Package>();
        for (Package pkg1 : this.pack) {
            for (Package pkg2 : installList) {
                if (!pkg1.equals(pkg2)) continue;
                samePackages.add(pkg2);
            }
        }
        if (samePackages.size() != 0) {
            for (Package pkg : samePackages) {
                installList.remove(pkg);
            }
        }
        this.pack.addAll(installList);
        if (anotherDependency) {
            this.solveDependencies(ret);
            return this.pack;
        }
        return this.pack;
    }

    @Override
    public void refreshSolveDependencies() {
        this.pack.removeAll(this.pack);
    }

    private void addDependency(Map<PackageReference, List<Package>> unsatisfiedDependencies, PackageReference r, Package toBeInstalled) {
        if (!unsatisfiedDependencies.containsKey(r)) {
            unsatisfiedDependencies.put(r, new LinkedList());
        }
        unsatisfiedDependencies.get(r).add(toBeInstalled);
    }

    @Override
    public List<Package> isDependencyOf(Collection<Package> packList) {
        this.packForDelete.removeAll(this.packForDelete);
        return this.getDependencyOf(packList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findConflicts(List<Package> packList) {
        this.lock.readLock().lock();
        Collection<Object> existingPackages = Collections.EMPTY_LIST;
        try {
            existingPackages = installedPackages.getPackages();
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.conflicts.addAll(this.findConflicts(existingPackages, packList, PackagingConflict.Type.CONFLICT_EXISTING));
        this.conflicts.addAll(this.findConflicts(packList, existingPackages, PackagingConflict.Type.CONFLICT_NEW));
        this.conflicts.addAll(this.findConflicts(packList, packList, PackagingConflict.Type.CONFLICT_WITHIN));
        if (this.conflicts.size() > 0) {
            return this.conflicts.toString();
        }
        return "";
    }

    private Collection<PackagingConflict> findConflicts(Collection<Package> l1, Collection<Package> l2, PackagingConflict.Type type) {
        ArrayList<PackagingConflict> conflicts = new ArrayList<PackagingConflict>();
        for (Package p1 : l1) {
            for (Package p2 : l2) {
                if (p1 == p2 || !p1.getConflicts().matches(p2)) continue;
                conflicts.add(new PackagingConflict(type, p2, p1));
            }
        }
        return conflicts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Package> getInstallablePackages() throws PackageManagerException {
        ArrayList<Package> installable = new ArrayList<Package>();
        ArrayList<Package> installed = new ArrayList<Package>();
        this.lock.readLock().lock();
        try {
            for (Package pkg : availablePackages.getPackages()) {
                installable.add((Package)DeepObjectCopy.clone(pkg, this.taskSummary));
            }
            for (Package pkg : installable) {
                if (!installedPackages.isPackageInstalled(pkg.getName())) continue;
                installed.add(pkg);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        installable.removeAll(installed);
        installed.removeAll(installed);
        return installable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Package> getInstalledPackages() {
        this.lock.readLock().lock();
        try {
            ArrayList<Object> ret = null == installedPackages.getPackages() ? new ArrayList(Collections.EMPTY_LIST) : new ArrayList<Package>(installedPackages.getPackages());
            ArrayList<Package> arrayList = ret;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Package> getUpdateablePackages() {
        ArrayList<Package> update = new ArrayList<Package>();
        this.lock.readLock().lock();
        try {
            for (Package pkg : installedPackages.getPackages()) {
                String s = pkg.getName();
                if (!availablePackages.isPackageInstalled(s) || pkg.getVersion().compareTo(availablePackages.getPackage(s).getVersion()) != -1) continue;
                update.add(availablePackages.getPackage(s));
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (update.size() < 1) {
            update = new ArrayList(Collections.EMPTY_LIST);
        }
        return update;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Package> getDebianFilePackages() {
        this.lock.readLock().lock();
        try {
            if (archivesDB == null) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            Collection<Package> collection = archivesDB.getPackages();
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private String getFormattedDate() {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yyyy'_'MM'_'dd'_'HH'_'mm'_'ss");
        return sdf.format(new GregorianCalendar().getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean downloadPackages(ArrayList<Package> downloadable) throws IOException, PackageManagerException {
        block11: {
            block12: {
                ret = false;
                if (downloadable.size() <= 0) break block11;
                conflictString = this.findConflicts(downloadable = new ArrayList<Package>(this.checkIfFilesAreInDatabase(downloadable)));
                if (conflictString == "") break block12;
                this.addWarning(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("DPKGPackageManager.downloadPackages.conflicts", "No enry found for DPKGPackageManager.downloadPackages.conflicts"));
                DPKGPackageManager.logger.error((Object)PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("DPKGPackageManager.downloadPackages.conflicts", "No enry found for DPKGPackageManager.downloadPackages.conflicts"));
                break block11;
            }
            if (downloadable.size() <= 0) ** GOTO lbl50
            installSizeInKB = 0L;
            for (Package pack : downloadable) {
                installSizeInKB += pack.getSize() / 1024L;
                installSizeInKB += pack.getInstalledSize();
                this.maxVolumeinByte += pack.getSize();
            }
            if (installSizeInKB < FileSystemUtils.freeSpaceKb((String)this.installDir)) {
                if (new DownloadFiles(this).downloadAndMD5sumCheck(downloadable, this.taskSummary)) {
                    if (this.getActprogress() < new Double(60.0).intValue()) {
                        this.setActprogress(new Double(60.0).intValue());
                    }
                    this.lock.writeLock().lock();
                    try {
                        for (Package pkg : downloadable) {
                            pack = null;
                            if (DPKGPackageManager.archivesDB.isPackageInstalledDontVerifyVersion(pkg.getName())) {
                                if (DPKGPackageManager.archivesDB.getPackage(pkg.getName()).getVersion().equals(pkg.getVersion()) || (pack = (Package)DeepObjectCopy.clone(pkg, this.taskSummary)) == null) continue;
                                pack.setName(pack.getFilename());
                                DPKGPackageManager.archivesDB.addPackageDontVerifyVersion(pack);
                                continue;
                            }
                            pack = (Package)DeepObjectCopy.clone(pkg, this.taskSummary);
                            if (null == pack) continue;
                            pack.setName(pack.getFilename());
                            DPKGPackageManager.archivesDB.addPackageDontVerifyVersion(pack);
                        }
                        this.setActprogress(new Double(70.0).intValue());
                        DPKGPackageManager.archivesDB.save();
                        if (!this.installPackages(downloadable)) ** GOTO lbl53
                        ret = true;
                    }
                    finally {
                        this.lock.writeLock().unlock();
                    }
                } else {
                    this.addWarning(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("DPKGPackageManager.downloadPackages.MD5Failed", "No enry found for DPKGPackageManager.downloadPackages.MD5Failed"));
                    DPKGPackageManager.logger.error((Object)PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("DPKGPackageManager.downloadPackages.MD5Failed", "No enry found for DPKGPackageManager.downloadPackages.MD5Failed"));
                }
            } else {
                downloadable.removeAll(downloadable);
                throw new PackageManagerException(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("interface.notEnoughtSpaceOnDisk", "No enry found for interface.notEnoughtSpaceOnDisk"));
lbl50:
                // 1 sources

                this.addWarning(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("DPKGPackageManager.downloadPackages.fileSizeNull", "No enry found for DPKGPackageManager.downloadPackages.fileSizeNull"));
                DPKGPackageManager.logger.error((Object)PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("DPKGPackageManager.downloadPackages.fileSizeNull", "No enry found for DPKGPackageManager.downloadPackages.fileSizeNull"));
            }
        }
        downloadable.removeAll(downloadable);
        this.maxVolumeinByte = 0L;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(Collection<Package> oldPacks) throws PackageManagerException {
        boolean ret = false;
        ArrayList<Package> newPacks = new ArrayList<Package>();
        if (oldPacks.size() > 0) {
            this.lock.readLock().lock();
            try {
                for (Package pkg : oldPacks) {
                    newPacks.add(availablePackages.getPackage(pkg.getName()));
                }
                this.lock.readLock().unlock();
                if (this.downloadPackages(newPacks)) {
                    ret = true;
                    this.setActprogress(100);
                    boolean i$ = ret;
                    return i$;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.addWarning(e.toString());
                logger.error((Object)e);
            }
        }
        this.setActprogress(100);
        this.setIsDoneTrue();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Package> checkIfFilesAreInDatabase(ArrayList<Package> downloadable) {
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < downloadable.size(); ++i) {
                if (!installedPackages.isPackageInstalled(downloadable.get(i).getName())) continue;
                downloadable.remove(i);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return downloadable;
    }

    @Override
    public boolean install(Collection<Package> installList) throws PackageManagerException {
        boolean ret = false;
        try {
            if (this.downloadPackages(new ArrayList<Package>(installList))) {
                ret = true;
            }
            installList.removeAll(installList);
            this.pack.removeAll(this.pack);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.addWarning(e.toString());
            logger.error((Object)e);
        }
        this.setActprogress(100);
        this.setIsDoneTrue();
        return ret;
    }

    public boolean doDelete(Collection<Package> deleteList, int what) throws PackageManagerException {
        String path = "";
        switch (what) {
            case 0: {
                path = this.oldInstallDir;
                break;
            }
            case 1: {
                path = this.installDir;
            }
        }
        int packageProg = this.getMaxProgress() / deleteList.size();
        for (Package p : deleteList) {
            int fileProg = packageProg / p.getFileList().size();
            for (File f : p.getFileList()) {
                if (!new File(path, f.getPath()).delete()) {
                    this.addWarning(PreferenceStoreHolder.getPreferenceStoreByName((String)"screen").getPreferenceAsString("PackageManagerBean.doNFSmove.couldNotRemove", "No entry found for PackageManagerBean.doNFSmove.couldNotRemove") + " " + new File(path, f.getPath()).getAbsolutePath());
                    logger.error((Object)(PreferenceStoreHolder.getPreferenceStoreByName((String)"screen").getPreferenceAsString("PackageManagerBean.doNFSmove.couldNotRemove", "No entry found for PackageManagerBean.doNFSmove.couldNotRemove") + " " + new File(path, f.getPath()).getAbsolutePath()));
                }
                this.setActprogress(this.getActprogress() + fileProg);
            }
            ArrayList<File> directories = new ArrayList<File>(p.getDirectoryList());
            Collections.sort(directories);
            Collections.reverse(directories);
            for (File dir : directories) {
                if (!new File(path, dir.getPath()).exists() || !new File(path, dir.getPath()).isDirectory() || new File(path, dir.getPath()).listFiles().length != 0 || new File(path, dir.getPath()).delete()) continue;
                this.addWarning(PreferenceStoreHolder.getPreferenceStoreByName((String)"screen").getPreferenceAsString("PackageManagerBean.doNFSmove.couldNotRemove", "No entry found for PackageManagerBean.doNFSmove.couldNotRemove") + " " + new File(path, dir.getPath()).getAbsolutePath());
                logger.error((Object)(PreferenceStoreHolder.getPreferenceStoreByName((String)"screen").getPreferenceAsString("PackageManagerBean.doNFSmove.couldNotRemove", "No entry found for PackageManagerBean.doNFSmove.couldNotRemove") + " " + new File(path, dir.getPath()).getAbsolutePath()));
            }
        }
        this.setActprogress(this.getMaxProgress());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Package> getAlreadyDeletedPackages() {
        if (!new File(this.oldInstallDir).isDirectory()) {
            return Collections.EMPTY_LIST;
        }
        this.lock.readLock().lock();
        try {
            ArrayList<Package> deletePackages;
            if (removedDB.getPackages() == null || removedDB.getPackages().size() == 0) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            ArrayList<Package> arrayList = deletePackages = new ArrayList<Package>(removedDB.getPackages());
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean deleteOldPackages(Collection<Package> deleteList) throws PackageManagerException {
        return this.doDelete(deleteList, 0);
    }

    public boolean realyDelete(Collection<File> directory) {
        boolean ret = true;
        ArrayList<File> otherDirectories = new ArrayList<File>();
        for (File file : directory) {
            if (file.isFile() && !file.delete()) {
                ret = false;
            }
            if (!file.isDirectory()) continue;
            if (file.listFiles().length == 0) {
                file.delete();
                continue;
            }
            for (File fi : file.listFiles()) {
                otherDirectories.add(fi);
            }
            otherDirectories.add(file);
        }
        if (!otherDirectories.isEmpty()) {
            this.realyDelete(otherDirectories);
        }
        otherDirectories.removeAll(otherDirectories);
        return ret;
    }

    @Override
    public long getFreeDiskSpace() throws PackageManagerException {
        try {
            return FileSystemUtils.freeSpaceKb((String)this.installDir);
        }
        catch (IOException io) {
            io.printStackTrace();
            this.addWarning(io.toString());
            logger.error((Object)io);
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteDebianPackages(Collection<Package> deleteList) {
        boolean ret = true;
        int multiplier = 100 / deleteList.size();
        int i = 1;
        this.lock.writeLock().lock();
        try {
            for (Package pkg : deleteList) {
                if (!new File(archivesDir, pkg.getFilename()).delete() || !archivesDB.removePackage(pkg)) {
                    ret = false;
                }
                this.setActprogress(i * multiplier);
                ++i;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.setActprogress(100);
        this.setIsDoneTrue();
        return ret;
    }

    public ArrayList<String> getChangelogFile(Package p) throws IOException {
        String line;
        String name = new File(this.listsDir + File.separator + p.getChangelogDir(), p.getName() + ".changelog").getCanonicalPath();
        if (!new File(name).isFile()) {
            return new ArrayList<String>(Collections.EMPTY_LIST);
        }
        InputStream stream = null;
        BufferedReader br = null;
        if (new File(name).length() != 0L) {
            stream = new FileInputStream(name);
        }
        if (stream == null) {
            ClassLoader aClassLoader = PreferenceStoreHolder.class.getClassLoader();
            stream = aClassLoader == null ? ClassLoader.getSystemResourceAsStream(name) : aClassLoader.getResourceAsStream(name);
        }
        if (stream == null) {
            return null;
        }
        br = new BufferedReader(new InputStreamReader(stream));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            lines.add(line);
        }
        br.close();
        stream.close();
        return lines;
    }

    @Override
    public Collection<Package> solveConflicts(Collection<Package> selectedList) {
        for (PackagingConflict pkconf : this.conflicts) {
            selectedList.removeAll(pkconf.pkgs);
        }
        return selectedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Package> filesToRename(Collection<Package> packages) throws PackageManagerException {
        this.fromToFileMap = new HashMap();
        this.removeDirectoryList = new ArrayList<File>();
        ArrayList<Package> remove = new ArrayList<Package>();
        for (Package pkg : packages) {
            remove.add((Package)DeepObjectCopy.clone(pkg, this.taskSummary));
        }
        String newDirName = null;
        if (!new File(this.oldInstallDir).isDirectory()) {
            new File(this.oldInstallDir).mkdirs();
        }
        this.lock.readLock().lock();
        try {
            for (int x = 0; x < remove.size(); ++x) {
                Package pack = installedPackages.getPackage(((Package)remove.get(x)).getName());
                remove.remove(x);
                remove.add(x, pack);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        for (int i = 0; i < remove.size(); ++i) {
            String dateForFolder = this.getFormattedDate();
            newDirName = new File(dateForFolder + "#" + remove.get(i).getName() + "#" + remove.get(i).getVersion().toString().replaceAll(":", "_").replaceAll("\\.", "_")).getPath();
            String newDirNamePath = this.oldInstallDir + File.separator + newDirName;
            if (!new File(newDirNamePath).mkdir()) {
                this.addWarning(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("DPKGPackageManager.getDebianFilePackages.unableToCreateDir", "NO entry for DPKGPackageManager.getDebianFilePackages.unableToCreateDir"));
                logger.error((Object)PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("DPKGPackageManager.getDebianFilePackages.unableToCreateDir", "NO entry for DPKGPackageManager.getDebianFilePackages.unableToCreateDir"));
            }
            remove.get(i).setoldFolder(newDirName);
            for (int z = 0; z < remove.get(i).getFileList().size(); ++z) {
                String fi = remove.get(i).getFileList().get(z).getPath();
                if (!new File(this.installDir, fi).exists()) {
                    ArrayList<File> removeDirs = new ArrayList<File>();
                    for (int n = 0; n < i; ++n) {
                        for (File file : remove.get(n).getDirectoryList()) {
                            removeDirs.add(new File(this.oldInstallDir + File.separator + remove.get(n).getoldFolder(), file.getPath()));
                        }
                        removeDirs.add(new File(this.oldInstallDir + File.separator + remove.get(n).getoldFolder()));
                    }
                    removeDirs.add(new File(newDirNamePath));
                    Collections.sort(removeDirs);
                    Collections.reverse(removeDirs);
                    for (File file : removeDirs) {
                        if (file.delete()) continue;
                        this.addWarning(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("DPKGPackageManager.filesToRename.notExisting", "No entry found for DPKGPackageManager.filesToRename.notExisting") + " \n" + new File(this.installDir, fi).getPath());
                        logger.error((Object)(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("DPKGPackageManager.filesToRename.notExisting", "No entry found for DPKGPackageManager.filesToRename.notExisting") + " \n" + new File(this.installDir, fi).getPath()));
                    }
                }
                if (!new File(this.installDir, fi).isFile()) continue;
                this.fromToFileMap.put(new File(this.installDir, fi), new File(newDirNamePath, fi));
            }
            for (File f : remove.get(i).getDirectoryList()) {
                new File(newDirNamePath, f.getPath()).mkdirs();
                if (this.removeDirectoryList.contains(f)) continue;
                this.removeDirectoryList.add(f);
            }
        }
        return remove;
    }

    public HashMap<File, File> getFromToFileMap() {
        return this.fromToFileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveChangesInDB(Collection<Package> remove) throws IOException, PackageManagerException {
        boolean ret = true;
        this.lock.writeLock().lock();
        try {
            for (Package pkg : remove) {
                if (installedPackages.removePackage(pkg)) {
                    ArrayList<File> directoryList = new ArrayList<File>();
                    ArrayList<File> fileList = new ArrayList<File>();
                    for (File file : pkg.getDirectoryList()) {
                        directoryList.add(new File(new File(pkg.getoldFolder()), file.getPath()));
                    }
                    for (File file : pkg.getFileList()) {
                        fileList.add(new File(new File(pkg.getoldFolder()), file.getPath()));
                    }
                    directoryList.add(new File(pkg.getoldFolder()));
                    pkg.setDirectoryList(directoryList);
                    pkg.setFileList(fileList);
                    pkg.setName(new File(pkg.getoldFolder()).getName());
                    removedDB.addPackage(pkg);
                    removedDB.save();
                    installedPackages.save();
                    continue;
                }
                this.addWarning(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("DPKGPackageManager.saveChangesInDB.unableToRemove", "No entry found for DPKGPackageManager.saveChangesInDB.unableToRemove"));
                logger.error((Object)PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("DPKGPackageManager.saveChangesInDB.unableToRemove", "No entry found for DPKGPackageManager.saveChangesInDB.unableToRemove"));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return true;
    }

    @Override
    public Collection<Package> checkIfPackageMangerIsIn(Collection<Package> deleteList) {
        Package packageManager = null;
        for (Package pkg : deleteList) {
            if (!pkg.isPackageManager()) continue;
            packageManager = pkg;
        }
        if (packageManager != null) {
            deleteList.remove(packageManager);
        }
        return deleteList;
    }

    public boolean deleteDirectories(List<File> directorysToDelete) {
        while (directorysToDelete.size() > 0) {
            if (directorysToDelete.get(0).isDirectory()) {
                if (directorysToDelete.get(0).listFiles().length == 0 && directorysToDelete.get(0).delete() || directorysToDelete.get(0).listFiles().length > 0) {
                    directorysToDelete.remove(0);
                    continue;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Package> getDependencyOf(Collection<Package> packList) {
        boolean anotherDepends = false;
        ArrayList<Package> remove = new ArrayList<Package>();
        this.lock.readLock().lock();
        try {
            for (Package p1 : packList) {
                for (Package p2 : installedPackages.getDependency(p1)) {
                    remove.add(p2);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (packList.size() > 0) {
            for (Package p1 : packList) {
                boolean check = false;
                for (Package p2 : this.packForDelete) {
                    if (!p1.getName().equals(p2.getName())) continue;
                    check = true;
                }
                if (check) continue;
                this.packForDelete.add(p1);
                anotherDepends = true;
            }
        }
        if (anotherDepends) {
            this.getDependencyOf(remove);
            return this.packForDelete;
        }
        packList.removeAll(packList);
        return this.packForDelete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<File> getRemoveDBFileList(String packName) {
        this.lock.readLock().lock();
        try {
            ArrayList<File> fileListAbsolute = new ArrayList<File>();
            for (File f : removedDB.getPackage(packName).getFileList()) {
                fileListAbsolute.add(new File(this.oldInstallDir, f.getPath()));
            }
            ArrayList<File> arrayList = fileListAbsolute;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<File> getRemoveDBDirList(String packName) {
        this.lock.readLock().lock();
        try {
            ArrayList<File> dirListAbsolute = new ArrayList<File>();
            for (File d : removedDB.getPackage(packName).getDirectoryList()) {
                dirListAbsolute.add(new File(this.oldInstallDir, d.getPath()));
            }
            ArrayList<File> arrayList = dirListAbsolute;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePackagesFromRemovedDB(List<Package> removeList) throws PackageManagerException {
        this.lock.writeLock().lock();
        try {
            for (Package pkg : removeList) {
                if (removedDB.removePackage(pkg)) continue;
                removedDB.save();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.addWarning(e.toString());
            logger.error((Object)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePackagesFromInstalledDB(List<Package> removeList) throws PackageManagerException {
        this.lock.writeLock().lock();
        try {
            for (Package pkg : removeList) {
                if (installedPackages.removePackage(pkg)) continue;
                boolean bl = false;
                return bl;
            }
            installedPackages.save();
        }
        catch (IOException e) {
            this.addWarning(e.toString());
            logger.error((Object)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return true;
    }

    public List<File> getRemoveDirectoryList() {
        return this.removeDirectoryList;
    }

    @Override
    public int getActprogress() {
        return this.actprogress;
    }

    @Override
    public void setActprogress(int actprogress) {
        this.actprogress = actprogress;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public void refreshIsDone() {
        this.isDone = false;
    }

    @Override
    public int getMaxProgress() {
        return 100;
    }

    @Override
    public void setIsDoneTrue() {
        this.isDone = true;
    }

    public long getMaxVolumeinByte() {
        return this.maxVolumeinByte;
    }

    public void setActprogressPlusX(int actprogress, int actually, int maxFile, String Name) {
        this.maxFile = maxFile;
        this.actually = actually;
        this.actPackName = Name;
        this.actprogress = actprogress;
    }

    @Override
    public int[] getActMaxFileSize() {
        return new int[]{this.actually, this.maxFile};
    }

    @Override
    public String getActPackName() {
        return this.actPackName;
    }

    @Override
    public void resetValuesForDisplaying() {
        this.actPackName = null;
        this.actually = 0;
        this.maxFile = 0;
        this.refreshIsDone();
        this.setActprogress(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateCacheDB() throws PackageManagerException {
        this.lock.writeLock().lock();
        try {
            this.setActprogress(new Double((double)this.getMaxProgress() * 0.1).intValue());
            this.setActprogress(new Double((double)this.getActprogress() + (double)this.getMaxProgress() * 0.1).intValue());
            availablePackages = new UpdateDatabase().doUpdate(true, this.taskSummary);
            this.setActprogress(new Double((double)this.getActprogress() + (double)this.getMaxProgress() * 0.5).intValue());
            availablePackages.save();
            this.setActprogress(100);
            this.setIsDoneTrue();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.addWarning(e.toString());
            logger.error((Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean delete(Collection<Package> collection) throws IOException, PackageManagerException {
        return this.doDelete(collection, 1);
    }

    @Override
    public boolean addWarning(String warning) {
        this.taskSummary.addWarning(warning);
        return true;
    }

    public void setTaskSummary(PackageManagerTaskSummary taskSummary) {
        if (taskSummary == null) {
            throw new IllegalArgumentException("taskSummary must not be null");
        }
        this.taskSummary = taskSummary;
    }

    @Override
    public PackageManagerTaskSummary fetchTaskSummary() {
        PackageManagerTaskSummary result = this.taskSummary;
        this.taskSummary = new PackageManagerTaskSummary();
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PackagingConflict {
        private final Type type;
        private final Package pkg;
        private Package conflicting;
        private List<Package> pkgs;
        private PackageReference ref;
        private File file;

        public PackagingConflict(Type type, Package pkg) {
            this.type = type;
            this.pkg = pkg;
        }

        public PackagingConflict(Type type, Package pkg, Package conflicting) {
            this(type, pkg);
            this.conflicting = conflicting;
        }

        public PackagingConflict(Type type, PackageReference ref, List<Package> pkgs) {
            this(type, null);
            this.ref = ref;
            this.pkgs = pkgs;
        }

        public PackagingConflict(Type type, Package pkg, Package conflicting, File f) {
            this(type, pkg, conflicting);
            this.file = f;
        }

        public Package getConflictingPackage() {
            return this.pkg;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            switch (this.type) {
                case ALREADY_INSTALLED: {
                    sb.append(this.pkg).append(" ");
                    break;
                }
                case CONFLICT_EXISTING: {
                    sb.append(this.pkg.forConflictsToString()).append(" ").append(" ").append(this.conflicting.forConflictsToString());
                    break;
                }
                case CONFLICT_NEW: {
                    sb.append(this.pkg.forConflictsToString()).append(" ").append(" ").append(this.conflicting.forConflictsToString());
                    break;
                }
                case UNSATISFIED: {
                    sb.append(" ").append(this.ref).append(" ").append(" ");
                    for (Package pkg : this.pkgs) {
                        sb.append(pkg.getName()).append(" ");
                    }
                    break;
                }
                case FILE_CONFLICT: {
                    sb.append(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.toString.ALREADY_INSTALLED", "No entry found for packageManager.toString.ALREADY_INSTALLED")).append(" ").append(this.file).append(" ").append(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.toString.ALREADY_INSTALLED", "No entry found for packageManager.toString.ALREADY_INSTALLED")).append(" ").append(this.pkg).append(" ").append(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageManager.toString.ALREADY_INSTALLED", "No entry found for packageManager.toString.ALREADY_INSTALLED")).append(" ").append(this.conflicting);
                }
            }
            return sb.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            ALREADY_INSTALLED,
            CONFLICT_EXISTING,
            CONFLICT_NEW,
            UNSATISFIED,
            FILE_CONFLICT,
            CONFLICT_WITHIN;

        }
    }
}

