/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.util.dpkg;

import com.levigo.util.preferences.PreferenceStoreHolder;
import java.io.Serializable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openthinclient.util.dpkg.ANDReference;
import org.openthinclient.util.dpkg.Package;
import org.openthinclient.util.dpkg.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageReference
implements Serializable {
    private static final long serialVersionUID = 3977016258086907959L;
    private static final Pattern SPECIFIER_PATTERN = Pattern.compile("(\\S+)(?:\\s+\\((<<|<|<=|=|>=|>|>>)\\s+(\\S+)\\s*\\))?");
    private String packageName;
    private Version version;
    private Relation relation;
    protected int hashCode;

    protected PackageReference() {
        this.packageName = "one-of";
    }

    public PackageReference(String specifier) {
        try {
            specifier.trim();
            Matcher m = SPECIFIER_PATTERN.matcher(specifier);
            if (!m.matches()) {
                throw new IllegalArgumentException(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageReference.IllegalArgument", "No entry found forPackageReference.IllegalArgument") + ": " + specifier);
            }
            this.packageName = m.group(1);
            if (m.group(2) != null) {
                this.relation = Relation.getByTextualRepresentation(m.group(2));
                this.version = new Version(m.group(3));
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageReference.IllegalArgument", "No entry found forPackageReference.IllegalArgument") + ": ", e);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.packageName);
        if (null != this.relation) {
            sb.append(" (").append((Object)this.relation).append(" ").append(this.version).append(")");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PackageReference)) {
            return false;
        }
        PackageReference r = (PackageReference)obj;
        if (!this.packageName.equals(r.packageName)) {
            return false;
        }
        if (null != this.version && null == r.version || null == this.version && null != r.version) {
            return false;
        }
        return null == this.version && null == r.version || this.version.equals(r.version);
    }

    public int hashCode() {
        if (-1 == this.hashCode) {
            this.hashCode = 0x588962D ^ this.packageName.hashCode() ^ (this.version != null ? this.version.hashCode() : 0);
        }
        return this.hashCode;
    }

    public boolean matches(Package pkg) {
        if (!this.packageName.equalsIgnoreCase(pkg.getName())) {
            return false;
        }
        if (null == this.relation) {
            return true;
        }
        Version v = pkg.getVersion();
        switch (this.relation) {
            case EARLIER: {
                return v.compareTo(this.version) < 0;
            }
            case EARLIER_OR_EQUAL: {
                return v.compareTo(this.version) <= 0;
            }
            case EQUAL: {
                return v.equals(this.version);
            }
            case LATER_OR_EQUAL: {
                return v.compareTo(this.version) >= 0;
            }
            case LATER: {
                return v.compareTo(this.version) > 0;
            }
        }
        return false;
    }

    public String getName() {
        return this.packageName;
    }

    public boolean isSatisfiedBy(Map<String, Package> pkgs) {
        Package definingPackage = pkgs.get(this.packageName);
        if (null == definingPackage) {
            return false;
        }
        if (this.packageName.equals(definingPackage.getName())) {
            return this.matches(definingPackage);
        }
        if (null == this.version) {
            if (definingPackage.getProvides() instanceof ANDReference) {
                for (PackageReference ref : ((ANDReference)definingPackage.getProvides()).getRefs()) {
                    if (!this.packageName.equals(ref.getName())) continue;
                    return true;
                }
            } else if (this.packageName.equals(definingPackage.getProvides().getName())) {
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Relation {
        EARLIER("<<"),
        EARLIER_OR_EQUAL("<="),
        EQUAL("="),
        LATER_OR_EQUAL(">="),
        LATER(">>");

        private String textualRepresentation;

        public static Relation getByTextualRepresentation(String s) {
            for (Relation r : Relation.values()) {
                if (!r.textualRepresentation.equals(s)) continue;
                return r;
            }
            return null;
        }

        private Relation(String s) {
            this.textualRepresentation = s;
        }

        public String toString() {
            return this.textualRepresentation;
        }
    }
}

