/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr;

import com.levigo.util.preferences.PreferenceStore;
import com.levigo.util.preferences.PreferenceStoreHolder;
import com.levigo.util.preferences.PropertiesPreferenceStore;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.pkgmgr.PackageManagerTaskSummary;
import org.openthinclient.pkgmgr.UpdateDatabase;
import org.openthinclient.pkgmgr.connect.InitProperties;
import org.openthinclient.pkgmgr.connect.ProxyManager;
import org.openthinclient.util.dpkg.DPKGPackageManager;
import org.openthinclient.util.dpkg.PackageDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageManagerFactory {
    private static String programRootDirectory;
    private static String tempStoreName;
    private static final Logger logger;

    public static DPKGPackageManager getPackageManager() {
        programRootDirectory = System.getProperty("jboss.server.data.dir");
        try {
            InitProperties.initProperties(programRootDirectory);
            PackageManagerFactory.initWarningProperties();
        }
        catch (PackageManagerException e) {
            logger.error((Object)"Could not initialize the Properties of the PackageManager please check this.", (Throwable)e);
            e.printStackTrace();
        }
        new ProxyManager().checkForProxy();
        PackageManagerFactory.checkIfDirectoriesAreCreated(PreferenceStoreHolder.getPreferenceStoreByName((String)tempStoreName).getPreferenceAsString("archivesDir", null), PreferenceStoreHolder.getPreferenceStoreByName((String)tempStoreName).getPreferenceAsString("partialDir", null), PreferenceStoreHolder.getPreferenceStoreByName((String)tempStoreName).getPreferenceAsString("testinstallDir", null), PreferenceStoreHolder.getPreferenceStoreByName((String)tempStoreName).getPreferenceAsString("listsDir", null), PreferenceStoreHolder.getPreferenceStoreByName((String)tempStoreName).getPreferenceAsString("installOldDir", null), PreferenceStoreHolder.getPreferenceStoreByName((String)tempStoreName).getPreferenceAsString("packageDB", null));
        PackageDatabase installedDB = null;
        PackageDatabase removedDB = null;
        PackageDatabase cacheDB = null;
        PackageDatabase archivesDB = null;
        System.out.println("proxySet" + System.getProperty("proxySet"));
        System.out.println("http.proxyHost" + System.getProperty("http.proxyHost"));
        System.out.println("http.proxyPort" + System.getProperty("http.proxyPort"));
        try {
            archivesDB = PackageDatabase.open(new File(PreferenceStoreHolder.getPreferenceStoreByName((String)tempStoreName).getPreferenceAsString("archivesDB", null)));
            installedDB = PackageDatabase.open(new File(PreferenceStoreHolder.getPreferenceStoreByName((String)tempStoreName).getPreferenceAsString("packageDB", null)));
            removedDB = PackageDatabase.open(new File(PreferenceStoreHolder.getPreferenceStoreByName((String)tempStoreName).getPreferenceAsString("oldDB", null)));
            PackageManagerTaskSummary taskSummary = new PackageManagerTaskSummary();
            try {
                cacheDB = new UpdateDatabase(PreferenceStoreHolder.getPreferenceStoreByName((String)tempStoreName).getPreferenceAsString("cacheDB", null), PreferenceStoreHolder.getPreferenceStoreByName((String)tempStoreName).getPreferenceAsString("listsDir", null)).doUpdate(false, taskSummary);
            }
            catch (PackageManagerException e) {
                logger.error((Object)"Unable to create the Cache Database!", (Throwable)e);
                taskSummary.addWarning("Unable to create the Cache Database! Cause: " + e.getMessage());
            }
            ArrayList<String> locations = new ArrayList<String>();
            PackageManagerFactory.addLocation("installDir", locations);
            PackageManagerFactory.addLocation("archivesDir", locations);
            PackageManagerFactory.addLocation("testinstallDir", locations);
            PackageManagerFactory.addLocation("installOldDir", locations);
            PackageManagerFactory.addLocation("listsDir", locations);
            boolean removeItReally = Boolean.valueOf(PreferenceStoreHolder.getPreferenceStoreByName((String)"PackageManager").getPreferenceAsString("removeItReally", "false"));
            DPKGPackageManager dpkgPackageManager = new DPKGPackageManager(cacheDB, removedDB, installedDB, archivesDB, locations, removeItReally);
            dpkgPackageManager.setTaskSummary(taskSummary);
            return dpkgPackageManager;
        }
        catch (IOException e) {
            logger.error((Object)"Probably there are existing Problems with the Databases", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    private static void addLocation(String what, Collection<String> locations) {
        String value = PreferenceStoreHolder.getPreferenceStoreByName((String)tempStoreName).getPreferenceAsString(what, null);
        if (value.length() > 1) {
            locations.add(value);
        }
    }

    private static void checkIfDirectoriesAreCreated(String archivesDir, String partialDir, String testinstallDir, String listsDir, String oldDir, String packagesDB) {
        if (!new File(archivesDir).isDirectory()) {
            new File(partialDir).mkdirs();
            new File(testinstallDir).mkdirs();
        } else {
            if (!new File(partialDir).isDirectory()) {
                new File(partialDir).mkdirs();
            }
            if (!new File(testinstallDir).isDirectory()) {
                new File(testinstallDir).mkdirs();
            }
        }
        if (!new File(listsDir).isDirectory()) {
            new File(listsDir).mkdirs();
        }
        if (!new File(oldDir).isDirectory()) {
            new File(oldDir).mkdirs();
        }
        if (!new File(packagesDB).isFile()) {
            new File(packagesDB.substring(0, packagesDB.lastIndexOf(File.separator))).mkdirs();
        }
    }

    private static boolean initWarningProperties() throws PackageManagerException {
        try {
            PropertiesPreferenceStore prefStore = new PropertiesPreferenceStore();
            prefStore.load("ScreenOutput.properties", PreferenceStoreHolder.class);
            PreferenceStoreHolder.addPreferenceStoreByName((String)"Screen", (PreferenceStore)prefStore);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new PackageManagerException(e);
        }
    }

    static {
        tempStoreName = "tempPackageManager";
        logger = Logger.getLogger(PackageManagerFactory.class);
    }
}

