/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr.connect;

import com.levigo.util.preferences.PreferenceStoreHolder;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.pkgmgr.PackageManagerTaskSummary;
import org.openthinclient.pkgmgr.connect.ProxyProperties;

public class ConnectToServer {
    private static final Logger logger = Logger.getLogger(ConnectToServer.class);
    private PackageManagerTaskSummary taskSummaryManager;

    public ConnectToServer(PackageManagerTaskSummary taskSummary) {
        this.taskSummaryManager = taskSummary;
    }

    public InputStream getInputStream(String adress) throws IOException, PackageManagerException {
        if (ConnectToServer.isProxyInUse()) {
            return this.getInputProxyStream(adress);
        }
        return new URL(adress).openStream();
    }

    public InputStream getInputStream(URL url) throws PackageManagerException, IOException {
        if (ConnectToServer.isProxyInUse()) {
            return this.getInputProxyStream(url.toString());
        }
        return url.openStream();
    }

    private static boolean isProxyInUse() {
        return System.getProperty("proxySet") != null && System.getProperty("proxySet") == "true";
    }

    private InputStream getInputProxyStream(String URLName) throws PackageManagerException {
        try {
            Properties systemSettings = System.getProperties();
            systemSettings.put("http.proxyHost", ProxyProperties.getProxyHost());
            systemSettings.put("http.proxyPort", ProxyProperties.getProxyPort());
            System.setProperties(systemSettings);
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(ProxyProperties.getProxyAccount(), ProxyProperties.getProxyPassword().toCharArray());
                }
            });
            URL u = new URL(URLName);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            con.connect();
            return con.getInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (null != this.taskSummaryManager) {
                this.taskSummaryManager.addWarning(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("ProxyManager.getInputStreamByProxy.IOException.connect", "No Entry for ProxyManager.getInputStreamByProxy.IOException.connect found"));
                logger.error((Object)PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("ProxyManager.getInputStreamByProxy.IOException.connect", "No Entry for ProxyManager.getInputStreamByProxy.IOException.connect found"), (Throwable)e);
            } else {
                logger.error((Object)PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("ProxyManager.getInputStreamByProxy.IOException.connect", "No Entry for ProxyManager.getInputStreamByProxy.IOException.connect found"), (Throwable)e);
            }
            throw new PackageManagerException(PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("ProxyManager.getInputStreamByProxy.IOException.connect", "No Entry for ProxyManager.getInputStreamByProxy.IOException.connect found"), e);
        }
    }
}

