/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr.connect;

import com.levigo.util.preferences.PreferenceStore;
import com.levigo.util.preferences.PreferenceStoreHolder;
import com.levigo.util.preferences.PropertiesPreferenceStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.pkgmgr.connect.ProxyProperties;

public class InitProperties {
    private static PreferenceStoreHolder prefStHo = PreferenceStoreHolder.getInstance();
    private static String tempStoreName = "tempPackageManager";

    public static boolean initProperties(String programRootDirectory) throws PackageManagerException {
        String propertiesFileName = "package_manager.properties";
        String configDir = new File(programRootDirectory + File.separator + "nfs" + File.separator + "root" + File.separator + "etc" + File.separator).getPath();
        PropertiesPreferenceStore prefStore = new PropertiesPreferenceStore();
        try {
            InputStream stream = null;
            if (new File(configDir, propertiesFileName).isFile() && new File(configDir, propertiesFileName).length() != 0L) {
                stream = new FileInputStream(new File(configDir, propertiesFileName));
            }
            if (stream == null) {
                ClassLoader aClassLoader = PreferenceStoreHolder.class.getClassLoader();
                stream = aClassLoader == null ? ClassLoader.getSystemResourceAsStream(propertiesFileName) : aClassLoader.getResourceAsStream(propertiesFileName);
                if (stream == null) {
                    Class<PreferenceStoreHolder> aClass = PreferenceStoreHolder.class;
                    stream = aClass.getResourceAsStream(propertiesFileName);
                }
                if (stream == null) {
                    if (new File(propertiesFileName).length() != 0L) {
                        stream = new FileInputStream(propertiesFileName);
                    } else {
                        throw new PackageManagerException("FATAL ERROR the file " + propertiesFileName + " which should be located in the " + configDir + " could not be loaded");
                    }
                }
            }
            if (stream != null) {
                prefStore.load(stream);
                PreferenceStoreHolder.addPreferenceStoreByName((String)"PackageManager", (PreferenceStore)prefStore);
                stream.close();
                PropertiesPreferenceStore tempPrefStore = new PropertiesPreferenceStore();
                tempPrefStore.putPreference("installDir", (Object)(InitProperties.getRealPath(programRootDirectory, prefStHo.getPreferenceAsString("PackageManager", "installDir", null)) + File.separator));
                tempPrefStore.putPreference("workingDir", (Object)(InitProperties.getRealPath(programRootDirectory, prefStHo.getPreferenceAsString("PackageManager", "workingDir", null)) + File.separator));
                tempPrefStore.putPreference("archivesDir", (Object)(InitProperties.getRealPath(programRootDirectory, prefStHo.getPreferenceAsString("PackageManager", "archivesDir", null)) + File.separator));
                tempPrefStore.putPreference("testinstallDir", (Object)(InitProperties.getRealPath(programRootDirectory, prefStHo.getPreferenceAsString("PackageManager", "testinstallDir", null)) + File.separator));
                tempPrefStore.putPreference("partialDir", (Object)(InitProperties.getRealPath(programRootDirectory, prefStHo.getPreferenceAsString("PackageManager", "partialDir", null)) + File.separator));
                tempPrefStore.putPreference("listsDir", (Object)(InitProperties.getRealPath(programRootDirectory, prefStHo.getPreferenceAsString("PackageManager", "listsDir", null)) + File.separator));
                tempPrefStore.putPreference("packageDB", (Object)InitProperties.getRealPath(programRootDirectory, prefStHo.getPreferenceAsString("PackageManager", "packageDB", null)));
                tempPrefStore.putPreference("cacheDB", (Object)InitProperties.getRealPath(programRootDirectory, prefStHo.getPreferenceAsString("PackageManager", "cacheDB", null)));
                tempPrefStore.putPreference("sourcesList", (Object)InitProperties.getRealPath(programRootDirectory, prefStHo.getPreferenceAsString("PackageManager", "sourcesList", null)));
                tempPrefStore.putPreference("installOldDir", (Object)InitProperties.getRealPath(programRootDirectory, prefStHo.getPreferenceAsString("PackageManager", "installOldDir", null)));
                tempPrefStore.putPreference("oldDB", (Object)InitProperties.getRealPath(programRootDirectory, prefStHo.getPreferenceAsString("PackageManager", "oldDB", null)));
                tempPrefStore.putPreference("removeItReally", (Object)InitProperties.getRealPath(programRootDirectory, prefStHo.getPreferenceAsString("PackageManager", "removeItReally", null)));
                tempPrefStore.putPreference("archivesDB", (Object)InitProperties.getRealPath(programRootDirectory, prefStHo.getPreferenceAsString("PackageManager", "archivesDB", null)));
                if (prefStHo.isAccessible()) {
                    PreferenceStoreHolder.removePreferenceStore((String)tempStoreName);
                }
                PreferenceStoreHolder.addPreferenceStoreByName((String)tempStoreName, (PreferenceStore)tempPrefStore);
                new ProxyProperties(prefStHo.getPreferenceAsString("PackageManager", "proxyHost", null), prefStHo.getPreferenceAsString("PackageManager", "proxyPort", null), prefStHo.getPreferenceAsString("PackageManager", "proxyUser", null), prefStHo.getPreferenceAsString("PackageManager", "proxyPass", null), prefStHo.getPreferenceAsBoolean("proxyInUse", false));
            }
            return true;
        }
        catch (IOException x) {
            x.printStackTrace();
            throw new PackageManagerException(x);
        }
    }

    private static String getRealPath(String programRootDirectory, String path) throws IOException {
        File f = new File(path);
        if (!f.isAbsolute()) {
            f = new File(programRootDirectory, path);
        }
        return f.getAbsoluteFile().getCanonicalPath();
    }
}

