/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr.ejb;

import com.levigo.util.preferences.PreferenceStoreHolder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log4j.Logger;
import org.jboss.annotation.ejb.RemoteBinding;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.pkgmgr.PackageManagerFactory;
import org.openthinclient.pkgmgr.PackageManagerTaskSummary;
import org.openthinclient.util.dpkg.DPKGPackageManager;
import org.openthinclient.util.dpkg.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@RemoteBinding(jndiBinding="PackageManagerBean/remote")
@Remote(value={PackageManager.class})
public class PackageManagerBean
implements PackageManager {
    private static final Logger logger = Logger.getLogger(PackageManagerBean.class);
    private static final DPKGPackageManager delegate = PackageManagerFactory.getPackageManager();

    @PostConstruct
    public void init() {
        try {
            if (null == delegate) {
                throw new PackageManagerException("Not Possible to create an Instance of the PackageManager!");
            }
        }
        catch (PackageManagerException e) {
            e.printStackTrace();
            logger.error((Object)e.toString());
            throw new RuntimeException(e);
        }
    }

    public void deinit() {
    }

    @Override
    public String checkForAlreadyInstalled(List<Package> installList) {
        return delegate.checkForAlreadyInstalled(installList);
    }

    @Override
    public void close() throws PackageManagerException {
        delegate.close();
    }

    @Override
    public boolean delete(Collection<Package> deleteList) throws IOException, PackageManagerException {
        boolean ret = false;
        try {
            if (MBeanServerFactory.findMBeanServer(null).get(0).isRegistered(new ObjectName("tcat:service=NFSService"))) {
                ret = this.startDelete(deleteList);
            } else if (delegate.delete(deleteList)) {
                if (delegate.removePackagesFromInstalledDB(new ArrayList<Package>(deleteList))) {
                    delegate.setActprogress(new Double((double)delegate.getMaxProgress() * 0.95).intValue());
                    delegate.setActprogress(new Double(delegate.getMaxProgress()).intValue());
                    delegate.setIsDoneTrue();
                    ret = true;
                } else {
                    String message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.doNFSremove.removedDB", "No entry found for PackageManagerBean.doNFSremove.removedDB");
                    logger.warn((Object)message);
                    this.addWarning(message);
                }
            }
        }
        catch (MalformedObjectNameException e) {
            String message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.doNFSremove.removedDB", "No entry found for PackageManagerBean.doNFSremove.removedDB");
            logger.warn((Object)message);
            this.addWarning(message);
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            String message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.doNFSremove.removedDB", "No entry found for PackageManagerBean.doNFSremove.removedDB");
            logger.warn((Object)message);
            this.addWarning(message);
            e.printStackTrace();
        }
        delegate.invokeDeploymentScan();
        delegate.setActprogress(delegate.getMaxProgress());
        delegate.setIsDoneTrue();
        return ret;
    }

    private boolean startDelete(Collection<Package> deleteList) throws IOException, PackageManagerException {
        ArrayList<Package> pkgs = new ArrayList<Package>(delegate.filesToRename(deleteList));
        if (this.doNFSmove(delegate.getFromToFileMap())) {
            delegate.setActprogress(delegate.getActprogress() + new Double((double)delegate.getMaxProgress() * 0.2).intValue());
            if (delegate.saveChangesInDB(pkgs)) {
                delegate.setActprogress(delegate.getActprogress() + new Double((double)delegate.getMaxProgress() * 0.2).intValue());
                if (this.callDeleteNFS(delegate.getRemoveDirectoryList())) {
                    return true;
                }
                StringBuffer sb = new StringBuffer();
                for (File fi : delegate.getRemoveDirectoryList()) {
                    sb.append(fi.getPath());
                }
                String message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.doNFSremove.NFSProblem", "No entry found for PackageManagerBean.doNFSremove.NFSProblem") + " \n" + sb.toString();
                logger.warn((Object)message);
                this.addWarning(message);
            } else {
                String message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.delete.DBtransfer", "No entry found for PackageManagerBean.delete.DBtransfer");
                logger.warn((Object)message);
                this.addWarning(message);
            }
        } else {
            this.callDeleteNFS(this.selectDirectories(delegate.getFromToFileMap().values()));
            String message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.delete.doNFSmoveFailed", "No entry found for PackageManagerBean.delete.doNFSmoveFailed");
            logger.warn((Object)message);
            this.addWarning(message);
        }
        return false;
    }

    private List<File> selectDirectories(Collection<File> filesAndDirs) {
        ArrayList<File> directories = new ArrayList<File>();
        for (File file : filesAndDirs) {
            if (!file.isDirectory()) continue;
            directories.add(file);
        }
        Collections.sort(directories);
        Collections.reverse(directories);
        return directories;
    }

    @Override
    public boolean deleteDebianPackages(Collection<Package> deleteList) {
        return delegate.deleteDebianPackages(deleteList);
    }

    @Override
    public boolean deleteOldPackages(Collection<Package> deleteList) throws PackageManagerException {
        boolean ret = false;
        try {
            if (MBeanServerFactory.findMBeanServer(null).get(0).isRegistered(new ObjectName("tcat:service=NFSService"))) {
                ret = this.doNFSremove(deleteList);
            } else if (delegate.deleteOldPackages(deleteList)) {
                if (delegate.removePackagesFromRemovedDB(new ArrayList<Package>(deleteList))) {
                    ret = true;
                    delegate.setActprogress(new Double(delegate.getMaxProgress()).intValue());
                    delegate.setIsDoneTrue();
                } else {
                    String message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.doNFSremove.removedDB", "No entry found for PackageManagerBean.doNFSremove.removedDB");
                    logger.warn((Object)message);
                    this.addWarning(message);
                }
            }
        }
        catch (MalformedObjectNameException e) {
            String message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.deleteOldPackages.NFSServerConnectionFaild", "No entry found for PackageManagerBean.deleteOldPackages.NFSServerConnectionFaild");
            logger.warn((Object)message);
            this.addWarning(message);
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public String findConflicts(List<Package> packList) {
        return delegate.findConflicts(packList);
    }

    @Override
    public Collection<Package> getAlreadyDeletedPackages() {
        return delegate.getAlreadyDeletedPackages();
    }

    @Override
    public Collection<Package> getDebianFilePackages() {
        return delegate.getDebianFilePackages();
    }

    @Override
    public long getFreeDiskSpace() throws PackageManagerException {
        return delegate.getFreeDiskSpace();
    }

    @Override
    public Collection<Package> getInstallablePackages() throws PackageManagerException {
        return delegate.getInstallablePackages();
    }

    @Override
    public Collection<Package> getInstalledPackages() {
        return delegate.getInstalledPackages();
    }

    @Override
    public Collection<Package> getUpdateablePackages() {
        return delegate.getUpdateablePackages();
    }

    @Override
    public boolean install(Collection<Package> installList) throws PackageManagerException {
        boolean ret = delegate.install(installList);
        delegate.invokeDeploymentScan();
        return ret;
    }

    @Override
    public List<Package> isDependencyOf(Collection<Package> packList) {
        return delegate.isDependencyOf(packList);
    }

    @Override
    public List<Package> solveDependencies(Collection<Package> installList) {
        return delegate.solveDependencies(installList);
    }

    @Override
    public boolean update(Collection<Package> oldPacks) throws PackageManagerException {
        boolean ret = false;
        try {
            if (MBeanServerFactory.findMBeanServer(null).get(0).isRegistered(new ObjectName("tcat:service=NFSService"))) {
                if (this.startDelete(oldPacks)) {
                    if (delegate.update(oldPacks)) {
                        ret = true;
                    } else {
                        String message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.update.couldNotDownloadAndInstall", "No entry found for PackageManagerBean.update.couldNotDownloadAndInstall");
                        logger.warn((Object)message);
                        this.addWarning(message);
                    }
                } else {
                    String message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.update.couldNotMoveOldPackages", "No entry found for PackageManagerBean.update.couldNotMoveOldPackages");
                    logger.warn((Object)message);
                    this.addWarning(message);
                }
            } else if (delegate.delete(oldPacks)) {
                if (delegate.update(oldPacks)) {
                    ret = true;
                } else {
                    String message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.update.couldNotDownloadAndInstall", "No entry found for PackageManagerBean.update.couldNotDownloadAndInstall");
                    logger.warn((Object)message);
                    this.addWarning(message);
                }
            } else {
                String message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.update.couldNotMoveOldPackages", "No entry found for PackageManagerBean.update.couldNotMoveOldPackages");
                logger.warn((Object)message);
                this.addWarning(message);
            }
        }
        catch (IOException e) {
            String message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.update.couldNotMoveOldPackages", "No entry found for PackageManagerBean.update.couldNotMoveOldPackages");
            logger.warn((Object)message);
            this.addWarning(message);
            e.printStackTrace();
        }
        catch (MalformedObjectNameException e) {
            String message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.update.NFSServerConnectionFaild", "No entry found for PackageManagerBean.update.NFSServerConnectionFaild");
            logger.warn((Object)message);
            this.addWarning(message);
            e.printStackTrace();
        }
        delegate.invokeDeploymentScan();
        delegate.setIsDoneTrue();
        return ret;
    }

    @Override
    public Collection<String> getChangelogFile(Package p) throws IOException {
        return delegate.getChangelogFile(p);
    }

    @Override
    public boolean removeConflicts() {
        return delegate.removeConflicts();
    }

    @Override
    public Collection<Package> solveConflicts(Collection<Package> selectedList) {
        return delegate.solveConflicts(selectedList);
    }

    private boolean doNFSmove(HashMap<File, File> fromToMap) throws PackageManagerException {
        String message;
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("tcat:service=NFSService");
        }
        catch (MalformedObjectNameException e1) {
            message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.doNFSmove.NFSServerConnectionFaild", "No entry found for PackageManagerBean.doNFSmove.NFSServerConnectionFaild");
            logger.warn((Object)message);
            this.addWarning(message);
            e1.printStackTrace();
        }
        catch (NullPointerException e1) {
            message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.doNFSmove.NFSServerConnectionFaild", "No entry found for PackageManagerBean.doNFSmove.NFSServerConnectionFaild");
            logger.warn((Object)message);
            this.addWarning(message);
            e1.printStackTrace();
        }
        MBeanServer server = MBeanServerFactory.findMBeanServer(null).get(0);
        try {
            if (Boolean.FALSE.equals(server.invoke(objectName, "moveMoreFiles", new Object[]{delegate.getFromToFileMap()}, new String[]{"java.util.HashMap"}))) {
                HashMap<File, File> backmap = new HashMap<File, File>();
                for (Map.Entry<File, File> entry : delegate.getFromToFileMap().entrySet()) {
                    backmap.put(entry.getValue(), entry.getKey());
                }
                if (Boolean.FALSE.equals(server.invoke(objectName, "moveMoreFiles", new Object[]{backmap}, new String[]{"java.util.HashMap"}))) {
                    StringBuffer sb = new StringBuffer();
                    for (Map.Entry<File, File> en : delegate.getFromToFileMap().entrySet()) {
                        sb.append(en.getKey().getPath() + " -> " + en.getValue().getPath());
                    }
                    String message2 = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.doNFSmove.fatalError", "No entry found for PackageManagerBean.doNFSmove.fatalError") + " \n" + sb.toString();
                    logger.warn((Object)message2);
                    this.addWarning(message2);
                } else {
                    String message3 = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.doNFSmove.couldNotMove", "No entry found for PackageManagerBean.doNFSmove.couldNotMove");
                    logger.warn((Object)message3);
                    this.addWarning(message3);
                }
            } else if (!this.callDeleteNFS(delegate.getRemoveDirectoryList())) {
                StringBuffer sb = new StringBuffer();
                for (File fi : delegate.getRemoveDirectoryList()) {
                    sb.append(fi.getPath());
                }
                String message4 = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.doNFSmove.couldNotRemove", "No entry found for PackageManagerBean.doNFSmove.couldNotRemove") + " \n" + sb.toString();
                logger.warn((Object)message4);
                this.addWarning(message4);
            }
            return true;
        }
        catch (InstanceNotFoundException e) {
            String message5 = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.doNFSmove.NFSServerConnectionFaild", "No entry found for PackageManagerBean.doNFSmove.NFSServerConnectionFaild");
            logger.warn((Object)message5);
            this.addWarning(message5);
            e.printStackTrace();
        }
        catch (MBeanException e) {
            String message6 = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.doNFSmove.NFSServerConnectionFaild", "No entry found for PackageManagerBean.doNFSmove.NFSServerConnectionFaild");
            logger.warn((Object)message6);
            this.addWarning(message6);
            e.printStackTrace();
        }
        catch (ReflectionException e) {
            String message7 = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.doNFSmove.NFSServerConnectionFaild", "No entry found for PackageManagerBean.doNFSmove.NFSServerConnectionFaild");
            logger.warn((Object)message7);
            this.addWarning(message7);
            e.printStackTrace();
        }
        return false;
    }

    private boolean doNFSremove(Collection<Package> packList) throws PackageManagerException {
        String message;
        StringBuffer sb;
        ArrayList<File> fileList = new ArrayList<File>();
        for (Package pkg : packList) {
            fileList.addAll(delegate.getRemoveDBFileList(pkg.getName()));
            fileList.addAll(delegate.getRemoveDBDirList(pkg.getName()));
        }
        Collections.sort(fileList);
        Collections.reverse(fileList);
        delegate.setActprogress(new Double((double)delegate.getMaxProgress() * 0.1).intValue());
        if (this.callDeleteNFS(fileList)) {
            delegate.setActprogress(new Double((double)delegate.getMaxProgress() * 0.8).intValue());
            if (delegate.removePackagesFromRemovedDB(new ArrayList<Package>(packList))) {
                delegate.setActprogress(new Double(delegate.getMaxProgress()).intValue());
                delegate.setIsDoneTrue();
                return true;
            }
            sb = new StringBuffer();
            for (File fi : fileList) {
                sb.append(fi.getPath());
            }
            message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.doNFSremove.NFSProblem", "No entry found for PackageManagerBean.doNFSremove.NFSProblem") + " \n" + sb.toString();
            logger.warn((Object)message);
            this.addWarning(message);
        } else {
            sb = new StringBuffer();
            for (File fi : fileList) {
                sb.append(fi.getPath());
            }
            message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.doNFSremove.NFSProblem", "No entry found for PackageManagerBean.doNFSremove.NFSProblem") + " \n" + sb.toString();
            logger.warn((Object)message);
            this.addWarning(message);
        }
        return false;
    }

    private boolean callDeleteNFS(List<File> fileList) throws PackageManagerException {
        String message;
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("tcat:service=NFSService");
        }
        catch (MalformedObjectNameException e1) {
            message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.callDeleteNFS.NFSServerConnectionFaild", "No entry found for PackageManagerBean.callDeleteNFS.NFSServerConnectionFaild");
            logger.warn((Object)message);
            this.addWarning(message);
            e1.printStackTrace();
        }
        catch (NullPointerException e1) {
            message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.callDeleteNFS.NFSServerConnectionFaild", "No entry found for PackageManagerBean.callDeleteNFS.NFSServerConnectionFaild");
            logger.warn((Object)message);
            this.addWarning(message);
            e1.printStackTrace();
        }
        MBeanServer server = MBeanServerFactory.findMBeanServer(null).get(0);
        try {
            if (!Boolean.FALSE.equals(server.invoke(objectName, "removeFilesFromNFS", new Object[]{fileList}, new String[]{"java.util.List"}))) {
                return true;
            }
            message = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.callDeleteNFS.NFSServerConnectionFaild.removeFilesFromNFS", "No entry found for PackageManagerBean.callDeleteNFS.NFSServerConnectionFaild.removeFilesFromNFS");
            logger.warn((Object)message);
            this.addWarning(message);
        }
        catch (InstanceNotFoundException e) {
            String message2 = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.callDeleteNFS.NFSServerConnectionFaild", "No entry found for PackageManagerBean.callDeleteNFS.NFSServerConnectionFaild");
            logger.warn((Object)message2);
            this.addWarning(message2);
            e.printStackTrace();
        }
        catch (MBeanException e) {
            String message3 = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.callDeleteNFS.NFSServerConnectionFaild", "No entry found for PackageManagerBean.callDeleteNFS.NFSServerConnectionFaild");
            logger.warn((Object)message3);
            this.addWarning(message3);
            e.printStackTrace();
        }
        catch (ReflectionException e) {
            e.printStackTrace();
            String message4 = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("PackageManagerBean.callDeleteNFS.NFSServerConnectionFaild", "No entry found for PackageManagerBean.callDeleteNFS.NFSServerConnectionFaild");
            logger.warn((Object)message4);
            this.addWarning(message4);
        }
        return false;
    }

    @Override
    public Collection<Package> checkIfPackageMangerIsIn(Collection<Package> deleteList) {
        return delegate.checkIfPackageMangerIsIn(deleteList);
    }

    @Override
    public int getActprogress() {
        return delegate.getActprogress();
    }

    @Override
    public boolean isDone() {
        return delegate.isDone();
    }

    @Override
    public void setActprogress(int actprogress) {
        delegate.setActprogress(actprogress);
    }

    @Override
    public void refreshIsDone() {
        delegate.refreshIsDone();
    }

    @Override
    public int getMaxProgress() {
        return delegate.getMaxProgress();
    }

    @Override
    public int[] getActMaxFileSize() {
        return delegate.getActMaxFileSize();
    }

    @Override
    public String getActPackName() {
        return delegate.getActPackName();
    }

    @Override
    public void resetValuesForDisplaying() {
        delegate.resetValuesForDisplaying();
    }

    @Override
    public void refreshSolveDependencies() {
        delegate.refreshSolveDependencies();
    }

    @Override
    public boolean updateCacheDB() throws PackageManagerException {
        return delegate.updateCacheDB();
    }

    @Override
    public void setIsDoneTrue() {
        delegate.setIsDoneTrue();
    }

    @Override
    public boolean addWarning(String warning) {
        return delegate.addWarning(warning);
    }

    @Override
    public PackageManagerTaskSummary fetchTaskSummary() {
        return delegate.fetchTaskSummary();
    }

    @Override
    public void invokeDeploymentScan() {
        delegate.invokeDeploymentScan();
    }
}

