/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.util.ar;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openthinclient.util.ar.AREntry;

public class ARInputStream
extends FilterInputStream {
    private static final int ENTRY_HEADER_LENGTH = 61;
    private AREntry currentEntry;
    private long bytesReadFromEntry;
    private AREntry queuedEntry;
    private byte[] extendedDirectory;
    private boolean eofReached;

    public static void main(String[] arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            String arg = arguments[i];
            File f = new File(arg);
            try {
                AREntry e;
                ARInputStream ais = new ARInputStream(new FileInputStream(f));
                System.out.println(f + ":");
                while ((e = ais.getNextEntry()) != null) {
                    System.out.println("   " + e);
                }
                continue;
            }
            catch (FileNotFoundException e) {
                System.err.println(f + ": " + e.toString());
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                System.err.println("Exception processing " + f);
                e.printStackTrace();
            }
        }
    }

    public ARInputStream(InputStream in) throws IOException {
        super(new BufferedInputStream(in));
        this.verifyARHeader();
        this.checkForDirectoryEntry();
    }

    public int read() throws IOException {
        if (null != this.currentEntry && this.bytesReadFromEntry >= this.currentEntry.getLength()) {
            return -1;
        }
        int r = this.in.read();
        if (r < 0) {
            this.eofReached = true;
        } else {
            ++this.bytesReadFromEntry;
        }
        return r;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (null != this.currentEntry && this.bytesReadFromEntry >= this.currentEntry.getLength()) {
            return -1;
        }
        int r = this.in.read(b, off, Math.min(len, (int)(this.currentEntry.getLength() - this.bytesReadFromEntry)));
        if (r < 0) {
            this.eofReached = true;
        } else {
            this.bytesReadFromEntry += (long)r;
        }
        return r;
    }

    private void checkForDirectoryEntry() throws IOException {
        AREntry next = this.getNextEntry();
        if (next.getName().startsWith("//")) {
            this.extendedDirectory = new byte[(int)next.getLength()];
            if ((long)this.readFully(this.extendedDirectory) != next.getLength()) {
                throw new IOException("Invalid format of archive: incomplete extended directory");
            }
        } else {
            this.queuedEntry = next;
        }
    }

    private int readFully(byte[] buffer) throws IOException {
        int read;
        int r;
        for (read = 0; read < buffer.length && (r = this.in.read(buffer, read, buffer.length - read)) >= 0; read += r) {
        }
        return read;
    }

    public AREntry getNextEntry() throws IOException {
        if (null != this.queuedEntry) {
            AREntry tmp = this.queuedEntry;
            this.queuedEntry = null;
            return tmp;
        }
        if (this.eofReached) {
            return null;
        }
        if (null != this.currentEntry) {
            while (this.bytesReadFromEntry < this.currentEntry.getLength()) {
                this.bytesReadFromEntry += this.skip(this.currentEntry.getLength() - this.bytesReadFromEntry);
            }
        }
        this.currentEntry = null;
        String entryHeader = this.readLine(61);
        if (entryHeader.equals("\n") && !this.eofReached) {
            entryHeader = this.readLine(61);
        }
        if (this.eofReached) {
            return null;
        }
        this.bytesReadFromEntry = 0L;
        if (!entryHeader.endsWith("`\n")) {
            throw new IOException("Invalid format of archive: Entry header not found");
        }
        AREntry entry = new AREntry(entryHeader);
        this.resolveLongNames(entry);
        this.currentEntry = entry;
        return entry;
    }

    private void resolveLongNames(AREntry entry) throws IOException {
        if (null != this.extendedDirectory && entry.getName().startsWith("/")) {
            try {
                int directoryOffset = Integer.parseInt(entry.getName().substring(1));
                if (directoryOffset >= this.extendedDirectory.length - 1) {
                    throw new IOException("Invalid format of archive: extended name entry points outside directory");
                }
                int i = directoryOffset;
                while (i < this.extendedDirectory.length && this.extendedDirectory[i] != 10) {
                }
                if (i == directoryOffset) {
                    throw new IOException("Invalid format of archive: extended name entry of length null");
                }
                entry.setName(new String(this.extendedDirectory, directoryOffset, i, "ISO8859-1"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void verifyARHeader() throws IOException {
        String header = this.readLine(20);
        if (!header.startsWith("!<arch>\n")) {
            throw new IOException("Invalid format of archive: ar header not found.");
        }
    }

    private String readLine(int maxLength) throws IOException {
        int r;
        byte[] headerBuffer = new byte[maxLength];
        int i = 0;
        while (i < headerBuffer.length && (r = this.read()) >= 0) {
            headerBuffer[i++] = (byte)r;
            if (r != 10) continue;
            break;
        }
        return new String(headerBuffer, 0, i, "ISO8859-1");
    }
}

