/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.util.dpkg;

import com.levigo.util.preferences.PreferenceStoreHolder;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.pkgmgr.connect.ConnectToServer;
import org.openthinclient.util.ar.AREntry;
import org.openthinclient.util.ar.ARInputStream;
import org.openthinclient.util.dpkg.ANDReference;
import org.openthinclient.util.dpkg.InstallationLogEntry;
import org.openthinclient.util.dpkg.Package;
import org.openthinclient.util.dpkg.PackageReference;
import org.openthinclient.util.dpkg.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DPKGPackage
implements Package {
    static final Logger logger = Logger.getLogger(Package.class);
    private static final long serialVersionUID = 3257006574903111730L;
    private String architecture;
    private String changedBy;
    private PackageReference conflicts;
    private String date;
    private PackageReference depends;
    private String description;
    private String distribution;
    private PackageReference enhances;
    private boolean essential;
    private List<File> files = new ArrayList<File>();
    private List<File> directories;
    private long installedSize;
    private String maintainer;
    private String name;
    private URL packageURL;
    private PackageReference preDepends;
    private String priority;
    private PackageReference provides;
    private PackageReference recommends;
    private PackageReference replaces;
    private String section;
    private PackageReference suggests;
    private Version version;
    private String filename;
    private String serverPath;
    private String md5sum;
    private boolean packageManager;
    private long size;
    private String changelogDir;
    private String shortDescription;
    private String oldFolder;
    private final PackageManager pm;
    private String license;

    public DPKGPackage(List specLines, PackageManager pm) {
        String currentSection = null;
        HashMap<String, String> controlTable = new HashMap<String, String>();
        for (String line : specLines) {
            currentSection = this.parseControlFileLine(controlTable, line, currentSection);
        }
        this.populateFromControlTable(controlTable);
        this.pm = pm;
    }

    public DPKGPackage(File packageFile, String archivesPath, PackageManager pm) throws IOException, PackageManagerException {
        this.verifyCompatibility(archivesPath);
        this.loadControlFile(archivesPath);
        this.pm = pm;
    }

    private int findAREntry(String segmentName, EntryCallback callback, String archivePath) throws IOException, PackageManagerException {
        AREntry e;
        ARInputStream ais = new ARInputStream(this.getPackageStream(archivePath));
        int callbackCount = 0;
        while ((e = ais.getNextEntry()) != null) {
            if (!e.getName().equals(segmentName)) continue;
            callback.handleEntry(e.getName(), ais);
            ++callbackCount;
        }
        ais.close();
        return callbackCount;
    }

    private boolean findControlFile(String fileName, EntryCallback callback, String archivesPath) throws IOException, PackageManagerException {
        String matchName;
        if (!fileName.startsWith("." + File.separator)) {
            fileName = "." + File.separator + fileName;
        }
        return this.findAREntry("control.tar.gz", new EntryCallback(matchName = fileName, callback){
            final /* synthetic */ String val$matchName;
            final /* synthetic */ EntryCallback val$callback;
            {
                this.val$matchName = string;
                this.val$callback = entryCallback;
            }

            public void handleEntry(String entry, InputStream ais) throws IOException, PackageManagerException {
                TarEntry t;
                TarInputStream tis = new TarInputStream(new GZIPInputStream(ais));
                while ((t = tis.getNextEntry()) != null) {
                    if (!t.getName().equals(this.val$matchName) || t.isDirectory()) continue;
                    this.val$callback.handleEntry(t.getName(), tis);
                }
            }
        }, archivesPath) != 0;
    }

    @Override
    public PackageReference getConflicts() {
        return this.conflicts;
    }

    @Override
    public PackageReference getDepends() {
        return this.depends;
    }

    @Override
    public List<File> getFiles(String archivesPath, PackageManager pm) throws PackageManagerException {
        if (null == this.files) {
            this.files = new ArrayList<File>();
            try {
                if (this.findAREntry("data.tar.gz", new EntryCallback(){

                    public void handleEntry(String entry, InputStream ais) throws IOException {
                        TarEntry t;
                        TarInputStream tis = new TarInputStream(new GZIPInputStream(ais));
                        while ((t = tis.getNextEntry()) != null) {
                            if (t.getLinkFlag() == 53) continue;
                            DPKGPackage.this.files.add(t.getFile());
                        }
                    }
                }, archivesPath) == 0) {
                    String errorMessage = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("package.getFiles.firstRuntimeException", "No entry found for package.getFiles.firstRuntimeException");
                    if (pm != null) {
                        pm.addWarning(errorMessage);
                        logger.error((Object)errorMessage);
                    } else {
                        logger.error((Object)errorMessage);
                    }
                }
            }
            catch (IOException e) {
                String errorMessage = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("package.getFiles.IOException", "No entry found for package.getFiles.IOException");
                if (pm != null) {
                    pm.addWarning(errorMessage);
                    logger.error((Object)errorMessage);
                } else {
                    logger.error((Object)errorMessage);
                }
                e.printStackTrace();
            }
        }
        return this.files;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private FileInputStream getPackageStream(String archivePath) throws IOException, PackageManagerException {
        int lastSlashInName = this.filename.lastIndexOf("/");
        String newFileName = this.filename.substring(lastSlashInName);
        File packageFile = new File(archivePath + newFileName);
        if (null != packageFile) {
            return new FileInputStream(packageFile);
        }
        if (null != this.packageURL) {
            InputStream urlStream = new ConnectToServer(null).getInputStream(this.packageURL);
            packageFile = new File(this.getName() + ".deb");
            FileOutputStream fileStream = new FileOutputStream(packageFile);
            byte[] buffer = new byte[10240];
            int read = 0;
            while ((read = urlStream.read(buffer)) > 0) {
                ((OutputStream)fileStream).write(buffer, 0, read);
            }
            urlStream.close();
            ((OutputStream)fileStream).close();
            return new FileInputStream(packageFile);
        }
        String errorMessage = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("package.getPackageStream.packageURLIsNull", "No entry found for package.getPackageStream.packageURLIsNull");
        if (this.pm != null) {
            this.pm.addWarning(errorMessage);
            logger.error((Object)errorMessage);
        } else {
            logger.error((Object)errorMessage);
        }
        throw new FileNotFoundException();
    }

    @Override
    public PackageReference getPreDepends() {
        return this.preDepends;
    }

    @Override
    public PackageReference getProvides() {
        return this.provides;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public void install(final File rootPath, final List<InstallationLogEntry> log, String archivesPath, PackageManager pm) throws PackageManagerException {
        try {
            if (this.findAREntry("data.tar.gz", new EntryCallback(){

                public void handleEntry(String entry, InputStream ais) throws IOException, PackageManagerException {
                    TarEntry t;
                    TarInputStream tis = new TarInputStream(new GZIPInputStream(ais));
                    while ((t = tis.getNextEntry()) != null) {
                        DPKGPackage.this.installFile(tis, t, rootPath, log);
                    }
                }
            }, archivesPath) == 0) {
                String errorMessage = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("package.install.firstRuntimeException", "No entry found for package.install.firstRuntimeException");
                if (pm != null) {
                    pm.addWarning(errorMessage);
                    logger.error((Object)errorMessage);
                } else {
                    logger.error((Object)errorMessage);
                }
            }
        }
        catch (IOException e) {
            String errorMessage = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("package.install.IOException", "No entry found for package.install.IOException");
            if (pm != null) {
                pm.addWarning(errorMessage);
                logger.error((Object)errorMessage);
            } else {
                logger.error((Object)errorMessage);
            }
            e.printStackTrace();
        }
    }

    private void installFile(TarInputStream tis, TarEntry t, File rootPath, List<InstallationLogEntry> log) throws IOException, PackageManagerException {
        String path = DPKGPackage.getRealPath(new File(rootPath, t.getFile().getPath()).getAbsolutePath());
        File absoluteFile = new File(path);
        if (null == this.files) {
            this.files = new ArrayList<File>();
        }
        if (System.getProperty("os.name").toUpperCase().contains("WINDOWS") && t.getFile().getPath().contains("::")) {
            throw new IOException();
        }
        switch (t.getLinkFlag()) {
            default: {
                break;
            }
            case 0: 
            case 48: {
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(absoluteFile));
                tis.copyEntryContents(os);
                ((OutputStream)os).close();
                log.add(new InstallationLogEntry(InstallationLogEntry.Type.FILE_INSTALLATION, absoluteFile));
                logger.info((Object)("Installed " + absoluteFile));
                this.files.add(absoluteFile);
                break;
            }
            case 53: {
                if (!absoluteFile.exists()) {
                    if (!absoluteFile.mkdir()) {
                        throw new IOException("mkdir failed for " + absoluteFile);
                    }
                    log.add(new InstallationLogEntry(InstallationLogEntry.Type.DIRECTORY_CREATION, absoluteFile));
                    logger.info((Object)("Directory created: " + absoluteFile));
                }
                if (null == this.directories) {
                    this.directories = new ArrayList<File>();
                }
                this.directories.add(absoluteFile);
                break;
            }
            case 49: 
            case 50: {
                logger.info((Object)("Symlinking " + absoluteFile + " -> " + t.getLinkName()));
                String symlinkFile = absoluteFile + ".#%softlink%#";
                FileWriter w = new FileWriter(symlinkFile);
                w.write(t.getLinkName());
                w.close();
                log.add(new InstallationLogEntry(InstallationLogEntry.Type.SYMLINK_INSTALLATION, new File(symlinkFile)));
                this.files.add(new File(symlinkFile));
            }
        }
    }

    public static String getRealPath(String path) throws PackageManagerException {
        File file = new File(path);
        try {
            path = file.getCanonicalPath();
            path = path.replaceAll("\\./", "");
            return path;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new PackageManagerException(e);
        }
    }

    private void loadControlFile(String archivesPath) throws IOException, PackageManagerException {
        final HashMap<String, String> controlTable = new HashMap<String, String>();
        if (!this.findControlFile("control", new EntryCallback(){

            public void handleEntry(String entry, InputStream ais) throws IOException {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(ais, "ISO8859-1"));
                String currentSection = null;
                while ((line = br.readLine()) != null) {
                    currentSection = DPKGPackage.this.parseControlFileLine(controlTable, line, currentSection);
                }
            }
        }, archivesPath)) {
            String errorMessage = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("package.invalidDebianpackage", "No entry found for package.invalidDebianpackage") + " : " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("package.invalidDebianpackage.controlFile", "No entry found for package.invalidDebianpackage.controlFile");
            if (this.pm != null) {
                this.pm.addWarning(errorMessage);
                logger.error((Object)errorMessage);
            } else {
                logger.error((Object)errorMessage);
            }
        }
        this.populateFromControlTable(controlTable);
    }

    private String parseControlFileLine(Map<String, String> controlTable, String line, String currentSection) {
        if (line.startsWith(" ")) {
            if (null == currentSection) {
                logger.warn((Object)("Ignoring line starting with blank: no preceding section: \"" + line + "\""));
            } else {
                String existing;
                if (line.equals(" .")) {
                    line = "\n";
                }
                if ((existing = controlTable.get(currentSection)) != null) {
                    controlTable.put(currentSection, existing + line);
                } else {
                    controlTable.put(currentSection, line);
                }
            }
        } else if (line.indexOf(": ") > 0) {
            int index = line.indexOf(": ");
            String section = line.substring(0, index);
            String value = line.substring(index + 2);
            currentSection = section;
            if (section.equalsIgnoreCase("Description")) {
                controlTable.put("Short-Description", value);
            } else {
                controlTable.put(section, value);
            }
        } else {
            logger.warn((Object)("Ignoring unparseable line: \"" + line + "\""));
        }
        return currentSection;
    }

    private PackageReference parsePackageReference(Map controlTable, String fieldName) {
        return new ANDReference(this.parseStringField(controlTable, fieldName, ""));
    }

    private String parseStringField(Map controlTable, String fieldName) {
        return this.parseStringField(controlTable, fieldName, null);
    }

    private String parseStringField(Map controlTable, String fieldName, String defaultValue) {
        if (controlTable.containsKey(fieldName)) {
            return (String)controlTable.get(fieldName);
        }
        return defaultValue;
    }

    private void populateFromControlTable(Map<String, String> controlTable) {
        this.architecture = this.parseStringField(controlTable, "Architecture");
        this.changedBy = this.parseStringField(controlTable, "Changed-By");
        this.date = this.parseStringField(controlTable, "Date");
        this.description = this.parseStringField(controlTable, "Description");
        this.distribution = this.parseStringField(controlTable, "Distribution");
        this.essential = this.parseStringField(controlTable, "Essential", "no").equalsIgnoreCase("yes");
        this.packageManager = this.parseStringField(controlTable, "Is-Package-Manager", "no").equalsIgnoreCase("yes");
        this.license = this.parseStringField(controlTable, "License");
        this.size = Long.parseLong(this.parseStringField(controlTable, "Size", "-1"));
        this.installedSize = Long.parseLong(this.parseStringField(controlTable, "Installed-Size", "-1"));
        this.maintainer = this.parseStringField(controlTable, "Maintainer");
        this.name = this.parseStringField(controlTable, "Package");
        this.priority = this.parseStringField(controlTable, "Priority");
        this.section = this.parseStringField(controlTable, "Section");
        this.version = new Version(controlTable.get("Version"));
        this.md5sum = this.parseStringField(controlTable, "MD5sum");
        this.filename = this.parseStringField(controlTable, "Filename");
        this.shortDescription = this.parseStringField(controlTable, "Short-Description");
        this.conflicts = this.parsePackageReference(controlTable, "Conflicts");
        this.depends = this.parsePackageReference(controlTable, "Depends");
        this.enhances = this.parsePackageReference(controlTable, "Enhances");
        this.preDepends = this.parsePackageReference(controlTable, "Pre-Depends");
        this.provides = this.parsePackageReference(controlTable, "Provides");
        this.recommends = this.parsePackageReference(controlTable, "Recommends");
        this.replaces = this.parsePackageReference(controlTable, "Replaces");
        this.suggests = this.parsePackageReference(controlTable, "Suggests");
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("  Package: ").append(this.name).append("\n");
        sb.append("  Version: ").append(this.version).append("\n");
        sb.append("  Architecture: ").append(this.architecture).append("\n");
        sb.append("  Changed-By: ").append(this.changedBy).append("\n");
        sb.append("  Date: ").append(this.date).append("\n");
        sb.append("  Essential: ").append(this.essential).append("\n");
        sb.append("  Is-Package-Manager: ").append(this.packageManager).append("\n");
        sb.append("  Distribution: ").append(this.distribution).append("\n");
        sb.append("  Installed-Size: ").append(this.installedSize).append("\n");
        sb.append("  Maintainer: ").append(this.maintainer).append("\n");
        sb.append("  Priority: ").append(this.priority).append("\n");
        sb.append("  Section: ").append(this.section).append("\n");
        sb.append("  MD5sum: ").append(this.md5sum).append("\n");
        sb.append("  Description: \n").append(this.description).append("\n\n");
        sb.append("  Dependencies:\n");
        sb.append("    Depends: ").append(this.depends).append("\n");
        sb.append("    Conflicts: ").append(this.conflicts).append("\n");
        sb.append("    Enhances: ").append(this.enhances).append("\n");
        sb.append("    Pre-Depends: ").append(this.preDepends).append("\n");
        sb.append("    Provides: ").append(this.provides).append("\n");
        sb.append("    Recommends: ").append(this.recommends).append("\n");
        sb.append("    Replaces: ").append(this.replaces).append("\n");
        sb.append("    Suggests: ").append(this.suggests).append("\n");
        return sb.toString();
    }

    @Override
    public String forConflictsToString() {
        StringBuffer sb = new StringBuffer();
        sb.append("  Package: ").append(this.name).append("\n");
        sb.append("  Version: ").append(this.version).append("\n");
        sb.append("  Conflicts: ").append(this.conflicts).append("\n");
        sb.append("  Description: \n").append(this.description).append("\n\n");
        return sb.toString();
    }

    private void verifyCompatibility(String archivesPath) throws IOException, PackageManagerException {
        if (this.findAREntry("debian-binary", new EntryCallback(){

            public void handleEntry(String entry, InputStream ais) throws IOException {
                String errorMessage;
                BufferedReader br = new BufferedReader(new InputStreamReader(ais, "ISO8859-1"));
                String signature = br.readLine().trim();
                String[] versionComponents = signature.split("\\.");
                if (versionComponents.length < 2) {
                    errorMessage = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("package.invalidDebianpackage", "No entry found for package.invalidDebianpackage") + " : " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("package.invalidDebianpackage.cantParseVersion", "No entry found for package.invalidDebianpackage.cantParseVersion") + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("package.invalidDebianpackage.versionNotSupported1", "No entry found for package.invalidDebianpackage.versionNotSupported1");
                    if (DPKGPackage.this.pm != null) {
                        DPKGPackage.this.pm.addWarning(errorMessage);
                        logger.error((Object)errorMessage);
                    } else {
                        logger.error((Object)errorMessage);
                    }
                }
                if (Integer.parseInt(versionComponents[0]) > 2 || Integer.parseInt(versionComponents[0]) == 2 && Integer.parseInt(versionComponents[1]) > 0) {
                    errorMessage = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("package.invalidDebianpackage", "No entry found for package.invalidDebianpackage") + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("package.invalidDebianpackage.versionNotSupported1", "No entry found for package.invalidDebianpackage.versionNotSupported1") + " : " + signature + " " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("package.invalidDebianpackage.versionNotSupported2", "No entry found for package.invalidDebianpackage.versionNotSupported2");
                    if (DPKGPackage.this.pm != null) {
                        DPKGPackage.this.pm.addWarning(errorMessage);
                        logger.error((Object)errorMessage);
                    } else {
                        logger.error((Object)errorMessage);
                    }
                }
            }
        }, archivesPath) == 0) {
            String errorMessage = PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("package.invalidDebianpackage", "No entry found for package.invalidDebianpackage") + " : " + PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("package.invalidDebianpackage.controlFile", "No entry found for package.invalidDebianpackage.controlFile");
            if (this.pm != null) {
                this.pm.addWarning(errorMessage);
                logger.error((Object)errorMessage);
            } else {
                logger.error((Object)errorMessage);
            }
        }
    }

    @Override
    public void setServerPath(String sePa) {
        this.serverPath = sePa;
    }

    @Override
    public String getServerPath() {
        return this.serverPath;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getMD5sum() {
        return this.md5sum;
    }

    @Override
    public List<File> getFileList() {
        return this.files;
    }

    @Override
    public List<File> getDirectoryList() {
        return this.directories;
    }

    @Override
    public void setVersion(String s) {
        this.version = new Version(s);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setFileList(List<File> fileList) {
        this.files = fileList;
    }

    @Override
    public void setDirectoryList(List<File> directoryList) {
        this.directories = directoryList;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isPackageManager() {
        return this.packageManager;
    }

    @Override
    public String getLicense() {
        return this.license;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getInstalledSize() {
        return this.installedSize;
    }

    @Override
    public String getChangelogDir() {
        return this.changelogDir;
    }

    @Override
    public void setChangelogDir(String changelogDir) {
        this.changelogDir = changelogDir;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    public int compareTo(Package o) {
        int c1 = this.getName().compareTo(o.getName());
        return c1 == 0 ? this.getVersion().compareTo(o.getVersion()) : c1;
    }

    @Override
    public String getSection() {
        return this.section;
    }

    @Override
    public String getPriority() {
        return this.priority;
    }

    public Package getThis() {
        return this;
    }

    @Override
    public String getoldFolder() {
        return this.oldFolder;
    }

    @Override
    public void setoldFolder(String rootDir) {
        this.oldFolder = rootDir;
    }

    private static interface EntryCallback {
        public void handleEntry(String var1, InputStream var2) throws IOException, PackageManagerException;
    }
}

