/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.util.dpkg;

import com.levigo.util.preferences.PreferenceStoreHolder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.util.dpkg.ANDReference;
import org.openthinclient.util.dpkg.Package;
import org.openthinclient.util.dpkg.PackageReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageDatabase
implements Serializable {
    private static final long serialVersionUID = 3761126046166234677L;
    private static final Logger logger = Logger.getLogger(PackageDatabase.class);
    private ArrayList<Package> packages;
    private transient Map<String, Package> providedPackages;
    private transient Map<File, Package> installedFiles;
    private transient LockFile lock;
    private transient File location;

    private PackageDatabase() {
    }

    public static PackageDatabase open(File databaseLocation) throws IOException {
        File databaseDirectory = databaseLocation.getParentFile();
        if (!databaseDirectory.canWrite()) {
            throw new IOException("Can't write to " + databaseDirectory);
        }
        LockFile lockFile = new LockFile(databaseLocation, new File(databaseLocation.getCanonicalPath() + ".lock"));
        if (databaseLocation.exists()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(databaseLocation));
                PackageDatabase db = (PackageDatabase)ois.readObject();
                ois.close();
                db.setLock(lockFile);
                db.setLocation(databaseLocation);
                logger.info((Object)("PackageDatabase at " + databaseLocation + " opened"));
                return db;
            }
            catch (Throwable e) {
                lockFile.unlock();
                throw new IOException("Package database seems to be corrupt: " + e);
            }
        }
        PackageDatabase db = new PackageDatabase();
        db.setLock(lockFile);
        db.setLocation(databaseLocation);
        logger.info((Object)("New PackageDatabase at " + databaseLocation + " created"));
        db.setPackages();
        return db;
    }

    protected void finalize() throws Throwable {
        if (this.lock.isLocked()) {
            logger.warn((Object)"Please close the PackageDatabase before dropping it on the floor");
            this.close();
        }
    }

    public void save() throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.location));
        oos.writeObject(this);
        oos.close();
    }

    public void close() {
        logger.info((Object)("PackageDatabase at " + this.location + " closed"));
        this.lock.unlock();
    }

    private void setLock(LockFile lock) {
        this.lock = lock;
    }

    private void setLocation(File location) {
        this.location = location;
    }

    public boolean isPackageInstalled(String name) {
        return this.getProvidedPackages().containsKey(name);
    }

    public boolean isPackageInstalledDontVerifyVersion(String name) {
        return null != this.getPackage(name);
    }

    public Map<String, Package> getProvidedPackages() {
        if (null == this.providedPackages) {
            this.providedPackages = new HashMap<String, Package>();
            for (Package pkg : this.getPackages()) {
                this.providedPackages.put(pkg.getName(), pkg);
                if (pkg.getProvides() instanceof ANDReference) {
                    for (PackageReference r : ((ANDReference)pkg.getProvides()).getRefs()) {
                        this.providedPackages.put(r.getName(), pkg);
                    }
                    continue;
                }
                this.providedPackages.put(pkg.getProvides().getName(), pkg);
            }
        }
        return this.providedPackages;
    }

    public Collection<Package> getPackages() {
        if (null == this.packages) {
            return Collections.EMPTY_LIST;
        }
        return this.packages;
    }

    public Map<File, Package> getInstalledFileMap() throws PackageManagerException {
        if (null == this.installedFiles) {
            this.installedFiles = new HashMap<File, Package>();
            for (Package pkg : this.getPackages()) {
                for (File f : pkg.getFiles(PreferenceStoreHolder.getPreferenceStoreByName((String)"tempPackageManager").getPreferenceAsString("installDir", null), null)) {
                    this.installedFiles.put(f, pkg);
                }
            }
        }
        return this.installedFiles;
    }

    public Package getPackageOwningFile(File f) throws PackageManagerException {
        return this.getInstalledFileMap().get(f);
    }

    public void addPackage(Package pkg) {
        if (null == this.packages) {
            this.packages = new ArrayList();
        }
        if (this.isPackageInstalled(pkg.getName())) {
            if (-1 == this.getPackage(pkg.getName()).getVersion().compareTo(pkg.getVersion())) {
                this.packages.remove(this.getPackage(pkg.getName()));
            }
            this.packages.add(pkg);
        } else {
            this.packages.add(pkg);
        }
        this.installedFiles = null;
        this.providedPackages = null;
    }

    public void addPackageDontVerifyVersion(Package pkg) {
        if (null == this.packages) {
            this.packages = new ArrayList();
        }
        Package temp = null;
        for (Package pkg2 : this.packages) {
            if (!pkg2.getName().equalsIgnoreCase(pkg.getName())) continue;
            temp = pkg2;
        }
        if (temp == null || -1 == temp.getVersion().compareTo(pkg.getVersion())) {
            this.packages.add(pkg);
        }
        this.installedFiles = null;
        this.providedPackages = null;
    }

    public Package getPackage(String name) {
        if (this.packages == null) {
            return null;
        }
        for (int i = 0; i < this.packages.size(); ++i) {
            if (!this.packages.get(i).getName().trim().equalsIgnoreCase(name.trim())) continue;
            return this.packages.get(i);
        }
        return null;
    }

    public List<Package> getProvidesPackages(String provided) {
        LinkedList<Package> providePackages = new LinkedList<Package>();
        for (int i = 0; i < this.packages.size(); ++i) {
            if (!this.packages.get(i).getProvides().toString().trim().equalsIgnoreCase(provided.trim())) continue;
            providePackages.add(this.packages.get(i));
        }
        return providePackages;
    }

    public List<Package> getDependency(Package pack) {
        ArrayList<Package> remove = new ArrayList<Package>();
        for (Package pkg : this.packages) {
            if (pkg.getDepends().matches(pack)) {
                remove.add(pkg);
            }
            if (!pkg.getPreDepends().matches(pack)) continue;
            remove.add(pkg);
        }
        return remove;
    }

    public boolean removePackage(Package pkg) {
        Package pack = this.getPackage(pkg.getName());
        boolean b = false;
        if (this.providedPackages != null) {
            if (pack == this.providedPackages.remove(pkg.getName()) && this.packages.remove(pack)) {
                b = true;
            }
        } else if (this.packages.remove(pack)) {
            b = true;
        }
        try {
            this.save();
        }
        catch (IOException e) {
            logger.error((Object)PreferenceStoreHolder.getPreferenceStoreByName((String)"Screen").getPreferenceAsString("packageDatabase.errorOnSavingDB", "No entry found for packageDatabase.errorOnSavingDB"));
            b = false;
            e.printStackTrace();
        }
        return b;
    }

    private void setPackages() {
        this.packages = new ArrayList(Collections.EMPTY_LIST);
    }

    private static class LockFile {
        private ServerSocket s;
        private Thread serverThread;
        private boolean goAway = false;
        private final File lockFile;

        private LockFile(File lockTarget, File lockFile) throws IOException {
            this.lockFile = lockFile;
            if (lockFile.exists()) {
                BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(lockFile)));
                String line = br.readLine();
                if (null == line) {
                    throw new IOException("The lock file at " + lockFile + " is broken. Please remove it manually.");
                }
                InetAddress host = InetAddress.getByName(line.trim());
                line = br.readLine();
                if (null == line) {
                    throw new IOException("The lock file at " + lockFile + " is broken. Please remove it manually.");
                }
                int port = Integer.parseInt(line.trim());
                br.close();
                try {
                    new Socket(host, port).close();
                    throw new IOException("The file at " + lockTarget + " is locked by " + lockFile + ".");
                }
                catch (IOException e) {
                    logger.warn((Object)("The lock on " + lockTarget + " held by " + host + " seems to be stale. Removing it."));
                }
            }
            this.startLockServer();
            this.writeLockFile(lockTarget, lockFile);
            this.startThread();
        }

        private void writeLockFile(File lockTarget, File lockFile) throws FileNotFoundException, IOException, UnknownHostException {
            OutputStreamWriter w = new OutputStreamWriter(new FileOutputStream(lockFile));
            String toString = InetAddress.getLocalHost().getCanonicalHostName();
            w.write(toString);
            w.write("\n");
            w.write(Integer.toString(this.s.getLocalPort()));
            w.write("\n");
            w.close();
            if (!lockFile.isFile()) {
                this.writeLockFile(lockTarget, lockFile);
            }
            logger.info((Object)("lockfile: " + lockFile + " locktarget: " + lockTarget));
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(lockFile)));
            InetAddress host = InetAddress.getByName(br.readLine().trim());
            int port = Integer.parseInt(br.readLine().trim());
            br.close();
            if (!host.equals(InetAddress.getLocalHost()) || port != this.s.getLocalPort()) {
                try {
                    this.s.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw new IOException("Locking of " + lockTarget + " failed: wasn't locked when I checked, but locker isn't me?!");
            }
        }

        private void startThread() {
            this.serverThread = new Thread("Lock file server at " + this.s.getLocalPort()){

                public void run() {
                    while (!LockFile.this.goAway) {
                        try {
                            LockFile.this.s.accept().close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            };
            this.serverThread.start();
        }

        private void startLockServer() throws IOException {
            int startPort = 34567;
            int tries = 10;
            while (tries > 0) {
                try {
                    this.s = new ServerSocket(startPort);
                    this.s.setReuseAddress(true);
                }
                catch (IOException e) {
                    --tries;
                    startPort = (int)((double)startPort + Math.random() * 100.0);
                }
            }
            if (null == this.s) {
                throw new IOException("Can't create lock server");
            }
        }

        public void unlock() {
            if (null != this.s) {
                this.goAway = true;
                try {
                    this.s.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public boolean isLocked() {
            return this.s != null && this.s.isBound() && !this.s.isClosed();
        }
    }
}

