/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.server;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.InputSource;

public class ServerConfiguration
implements Serializable {
    private static final long serialVersionUID = 3834308444944412977L;
    private static transient Mapping mapping;
    private transient File location;
    private File clientConfigurationBase;
    private File defaultLocation;
    private int tftpPort;
    private int nfsPort;
    private int nfsProgramNumber;
    private int mountdPort;
    private int mountdProgramNumber;
    private boolean tftpEnabled = true;
    private boolean nfsEnabled = true;

    public static ServerConfiguration load(File path) throws IOException, MappingException, MarshalException, ValidationException {
        FileReader reader = new FileReader(path);
        Unmarshaller unmarshaller = new Unmarshaller();
        unmarshaller.setMapping(ServerConfiguration.getMapping());
        ServerConfiguration unmarshal = (ServerConfiguration)unmarshaller.unmarshal((Reader)reader);
        unmarshal.location = path;
        return unmarshal;
    }

    public void save() throws IOException, MappingException, MarshalException, ValidationException {
        if (null == this.location) {
            throw new IOException("Can't save configuration: location not known");
        }
        File parentDir = this.location.getParentFile();
        File tmpFile = File.createTempFile("config", ".tmp", parentDir);
        FileWriter writer = new FileWriter(tmpFile);
        Marshaller marshaller = new Marshaller((Writer)writer);
        marshaller.setMapping(ServerConfiguration.getMapping());
        marshaller.marshal((Object)this);
        writer.close();
        File backup = new File(this.location.getCanonicalPath() + "~");
        backup.delete();
        this.location.renameTo(backup);
        tmpFile.renameTo(this.location);
    }

    private static Mapping getMapping() throws IOException, MappingException {
        if (null == mapping) {
            mapping = new Mapping();
            mapping.loadMapping(new InputSource(ServerConfiguration.class.getResourceAsStream("mapping.xml")));
        }
        return mapping;
    }

    public File getClientConfigurationBase() {
        return this.clientConfigurationBase;
    }

    public void setClientConfigurationBase(File clientConfigurationBase) {
        this.clientConfigurationBase = clientConfigurationBase;
    }

    public int getMountdProgramNumber() {
        return this.mountdProgramNumber;
    }

    public void setMountdProgramNumber(int mountdProgramNumber) {
        this.mountdProgramNumber = mountdProgramNumber;
    }

    public int getNfsPort() {
        return this.nfsPort;
    }

    public void setNfsPort(int nfsPort) {
        this.nfsPort = nfsPort;
    }

    public int getNfsProgramNumber() {
        return this.nfsProgramNumber;
    }

    public void setNfsProgramNumber(int nfsProgramNumber) {
        this.nfsProgramNumber = nfsProgramNumber;
    }

    public int getTftpPort() {
        return this.tftpPort;
    }

    public void setTftpPort(int tftpPort) {
        this.tftpPort = tftpPort;
    }

    public boolean isNfsEnabled() {
        return this.nfsEnabled;
    }

    public void setNfsEnabled(boolean nfsEnabled) {
        this.nfsEnabled = nfsEnabled;
    }

    public boolean isTftpEnabled() {
        return this.tftpEnabled;
    }

    public void setTftpEnabled(boolean tftpEnabled) {
        this.tftpEnabled = tftpEnabled;
    }

    public int getMountdPort() {
        return this.mountdPort;
    }

    public void setMountdPort(int mountdPort) {
        this.mountdPort = mountdPort;
    }

    public File getDefaultLocation() {
        return this.defaultLocation;
    }

    public void setDefaultLocation(File defaultLocation) {
        this.defaultLocation = defaultLocation;
    }
}

