/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.server;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.openthinclient.server.ServerConfiguration;
import org.openthinclient.server.TCATServerException;

public class ServerConfigurationFactory {
    public static ServerConfiguration getOnServer() throws TCATServerException {
        try {
            MBeanServer server = ServerConfigurationFactory.locateJBoss();
            if (null == server) {
                throw new IllegalStateException("Can't locate JBoss MBean server");
            }
            ObjectName objectName = new ObjectName("tcat:service=ConfigService");
            return (ServerConfiguration)server.invoke(objectName, "getConfiguration", new Object[0], new String[0]);
        }
        catch (Exception e) {
            throw new TCATServerException("Could not get current client configuration", e);
        }
    }

    public static MBeanServer locateJBoss() {
        for (MBeanServer server : MBeanServerFactory.findMBeanServer(null)) {
            if (!server.getDefaultDomain().equals("jboss")) continue;
            return server;
        }
        throw new IllegalStateException("No 'jboss' MBeanServer found!");
    }
}

