/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.jdbc;

import com.levigo.util.log.Log;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;

public class JDBCConnectionFactory
extends BaseKeyedPoolableObjectFactory {
    private Properties properties;

    public JDBCConnectionFactory(Properties properties) {
        this.properties = properties;
    }

    public Object makeObject(Object key) throws Exception {
        String contextName = (String)key;
        Connection connection = this.createConnection(contextName);
        Log.debug((String)((Object)((Object)this)).getClass().getName(), (String)("makeObject(): " + connection));
        return connection;
    }

    private Connection createConnection(String dbContextName) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        String propsPath = dbContextName + ".db.jdbc.";
        Connection dbConnection = null;
        if (this.properties.containsKey(propsPath + "url")) {
            Class.forName(this.properties.getProperty(propsPath + "class")).newInstance();
            dbConnection = DriverManager.getConnection(this.properties.getProperty(propsPath + "url"), this.properties.getProperty(propsPath + "user"), this.properties.getProperty(propsPath + "password"));
            String schema = this.properties.getProperty(propsPath + "schema");
            if (schema != null) {
                Statement stmt = dbConnection.createStatement();
                stmt.execute("set schema " + schema);
            }
        }
        return dbConnection;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (null != obj) {
            Connection con = (Connection)obj;
            Log.debug((String)((Object)((Object)this)).getClass().getName(), (String)("destroyObject() called for: " + obj));
            con.close();
            Log.debug((String)((Object)((Object)this)).getClass().getName(), (String)("Destroyed object: " + obj));
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
        if (null != obj) {
            Connection con = (Connection)obj;
            if (!con.getAutoCommit()) {
                con.rollback();
            }
            con.clearWarnings();
            con.setAutoCommit(true);
            Log.debug((String)((Object)((Object)this)).getClass().getName(), (String)("Passivated object: " + obj));
        }
    }

    public boolean validateObject(Object key, Object obj) {
        boolean result = false;
        if (obj != null) {
            try {
                result = !((Connection)obj).isClosed();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        if (!result) {
            Log.debug((String)((Object)((Object)this)).getClass().getName(), (String)("Validate: JDBC Connection nicht mehr wiederverwendbar: " + key));
        }
        return result;
    }
}

