/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.preferences;

import com.levigo.util.log.Log;
import com.levigo.util.preferences.AbstractPreferenceStore;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractSQLPreferenceStore
extends AbstractPreferenceStore {
    protected String contextName = "com.levigo.util.preferences";
    protected Connection connection = null;
    private String tableName = "preferences";
    private boolean useStatementCache = true;
    private Map cache = null;
    protected static final String QUERY_LOOKUP = "select value from $TN$ where context=? and prefkey=?";
    private static final String QUERY_FILL_CACHE = "select prefkey, value from $TN$ where context=?";
    protected static final String QUERY_UPDATE = "update $TN$ set value=?, modcount=1+modcount where context=? and prefkey=?";
    protected static final String QUERY_INSERT = "insert into $TN$ (context, prefkey, value, modcount) values (?,?,?,0)";
    protected static final String QUERY_REMOVE = "delete from $TN$ where context=? and prefkey=?";
    private Map statementCache = new HashMap();
    protected static final int QUERY_TIMEOUT = 5;

    protected PreparedStatement getPreparedStatement(String query) {
        if (!this.useStatementCache || !this.statementCache.containsKey(query)) {
            PreparedStatement ps = null;
            try {
                String q = query;
                if (q.indexOf("$TN$") >= 0) {
                    int p = q.indexOf("$TN$");
                    q = q.substring(0, p) + this.tableName + q.substring(p + 4);
                }
                if (null != this.connection) {
                    ps = this.connection.prepareStatement(q);
                }
            }
            catch (SQLException e) {
                Log.error((String)((Object)((Object)this)).getClass().getName(), (String)("Can't prepare this statement:\n" + query), (Throwable)e);
            }
            if (this.useStatementCache) {
                this.statementCache.put(query, ps);
            } else {
                return ps;
            }
        }
        return (PreparedStatement)this.statementCache.get(query);
    }

    protected void invalidateConnection() {
        if (null != this.connection) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.connection = null;
        this.statementCache.clear();
    }

    public Object getPreference(String preferenceKey, Object defaultValue) {
        if (null != this.cache) {
            Log.debug((String)((Object)((Object)this)).getClass().getName(), (String)("Cache lookup for " + preferenceKey));
            if (this.cache.containsKey(preferenceKey)) {
                return this.cache.get(preferenceKey);
            }
            return defaultValue;
        }
        Log.debug((String)((Object)((Object)this)).getClass().getName(), (String)("DB query for " + preferenceKey));
        Object lookupResult = this.queryPreferenceValue(preferenceKey);
        if (null != lookupResult) {
            return lookupResult;
        }
        return defaultValue;
    }

    protected abstract Object queryPreferenceValue(String var1);

    private void fillCache() {
        try {
            PreparedStatement query = this.getPreparedStatement(QUERY_FILL_CACHE);
            if (query != null) {
                query.setString(1, this.contextName);
                ResultSet rs = query.executeQuery();
                while (rs.next()) {
                    this.cache.put(rs.getObject(1), rs.getObject(2));
                }
                rs.close();
                Log.debug((String)((Object)((Object)this)).getClass().getName(), (String)"Cache filled.");
            } else {
                Log.error((String)((Object)((Object)this)).getClass().getName(), (String)"Can't fill cache: query is null.");
            }
        }
        catch (SQLException e) {
            Log.error((String)((Object)((Object)this)).getClass().getName(), (String)"Can't query preference values to fill cache", (Throwable)e);
        }
    }

    public void setCacheLookups(boolean cacheLookups) {
        if (cacheLookups) {
            if (null == this.cache) {
                this.cache = new HashMap();
                this.fillCache();
            }
        } else if (null != this.cache) {
            this.cache.clear();
            this.cache = null;
        }
    }

    public boolean isCacheLookups() {
        return null != this.cache;
    }

    public void putPreference(String preferenceKey, Object value) {
        if (null != this.cache) {
            this.cache.put(preferenceKey, value);
        }
        this.putPreferenceSQL(preferenceKey, value);
    }

    protected abstract void putPreferenceSQL(String var1, Object var2);

    public void removePreference(String preferenceKey) {
        if (null != this.cache) {
            this.cache.remove(preferenceKey);
        }
        this.removePreferenceSQL(preferenceKey);
    }

    protected void removePreferenceSQL(String preferenceKey) {
        try {
            PreparedStatement query = this.getPreparedStatement(QUERY_REMOVE);
            if (null != query) {
                query.setQueryTimeout(5);
                if (query != null) {
                    query.setString(1, this.contextName);
                    query.setString(2, preferenceKey);
                    query.execute();
                }
            }
        }
        catch (SQLException e) {
            Log.error((String)((Object)((Object)this)).getClass().getName(), (String)"Can't remove preference value.", (Throwable)e);
            this.invalidateConnection();
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean isAccessible() {
        return this.connection != null;
    }

    public void setUseStatementCache(boolean useStatementCache) {
        this.useStatementCache = useStatementCache;
    }
}

