/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.preferences;

import com.levigo.util.preferences.AbstractSQLPreferenceStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class OracleSQLPreferenceStore
extends AbstractSQLPreferenceStore {
    private static final Logger logger = Logger.getLogger((Class)OracleSQLPreferenceStore.class);

    public OracleSQLPreferenceStore(Connection connection) {
        this(connection, null);
    }

    public OracleSQLPreferenceStore(Connection connection, String contextName) {
        if (null != contextName) {
            this.contextName = contextName;
        }
        this.connection = connection;
    }

    protected synchronized Object queryPreferenceValue(String preferenceKey) {
        logger.debug((Object)("Querying SQL preference: /" + preferenceKey + "/"));
        try {
            PreparedStatement query = this.getPreparedStatement("select value from $TN$ where context=? and prefkey=?");
            if (null != query) {
                query.setQueryTimeout(5);
                if (null == query) {
                    return null;
                }
                query.setString(1, this.contextName);
                query.setString(2, preferenceKey);
                ResultSet rs = query.executeQuery();
                if (rs.next()) {
                    Object value = new ObjectInputStream(rs.getBinaryStream(1)).readObject();
                    rs.close();
                    return value;
                }
                rs.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)"SQLPreferenceStore: error: can't query pref value", (Throwable)e);
            this.invalidateConnection();
        }
        return null;
    }

    protected synchronized void putPreferenceSQL(String preferenceKey, Object value) {
        logger.debug((Object)("Putting SQL preference: /" + preferenceKey + "/ -> /" + value + "/ (Context:" + this.contextName + ")"));
        try {
            PreparedStatement query = this.getPreparedStatement("update $TN$ set value=?, modcount=1+modcount where context=? and prefkey=?");
            if (null != query) {
                query.setQueryTimeout(5);
                if (query != null) {
                    query.setString(2, this.contextName);
                    query.setString(3, preferenceKey);
                    this.serializeObjectValue(1, query, value);
                    if (query.executeUpdate() < 1) {
                        query = this.getPreparedStatement("insert into $TN$ (context, prefkey, value, modcount) values (?,?,?,0)");
                        query.setString(1, this.contextName);
                        query.setString(2, preferenceKey);
                        this.serializeObjectValue(3, query, value);
                        query.execute();
                    }
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"SQLPreferenceStore: error: can't update pref value", (Throwable)e);
            this.invalidateConnection();
        }
    }

    private void serializeObjectValue(int parameterIndex, PreparedStatement query, Object value) throws SQLException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            oos.close();
            query.setBinaryStream(parameterIndex, (InputStream)new ByteArrayInputStream(baos.toByteArray()), baos.toByteArray().length);
        }
        catch (IOException e) {
            logger.error((Object)"Could not serialize value", (Throwable)e);
        }
    }
}

