/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.preferences;

import com.levigo.util.preferences.AbstractPreferenceStore;
import com.levigo.util.preferences.SQLPreferenceStore;
import java.sql.Connection;

public class SQL2LayeredPreferenceStore
extends AbstractPreferenceStore {
    private SQLPreferenceStore userPrefStore = null;
    private SQLPreferenceStore systemPrefStore = null;

    public SQL2LayeredPreferenceStore(Connection connection) {
        this(connection, null, null);
    }

    public SQL2LayeredPreferenceStore(Connection connection, String contextName) {
        this(connection, contextName, null);
    }

    public SQL2LayeredPreferenceStore(Connection connection, String userContextName, String systemContextName) {
        if (null == userContextName) {
            userContextName = "com.levigo.util.preferences";
        }
        if (null == systemContextName) {
            systemContextName = "com.levigo.util.preferences";
        }
        this.userPrefStore = new SQLPreferenceStore(connection, userContextName);
        this.systemPrefStore = new SQLPreferenceStore(connection, systemContextName);
        this.userPrefStore.setUseStatementCache(false);
        this.systemPrefStore.setUseStatementCache(false);
    }

    public Object getPreference(String preferenceKey, Object defaultValue) {
        Object lookupResult = this.userPrefStore.getPreference(preferenceKey, null);
        if (null != lookupResult) {
            return lookupResult;
        }
        return this.systemPrefStore.getPreference(preferenceKey, defaultValue);
    }

    public void setCacheLookups(boolean cacheLookups) {
        this.userPrefStore.setCacheLookups(cacheLookups);
        this.systemPrefStore.setCacheLookups(cacheLookups);
    }

    public boolean isCacheLookups() {
        return this.userPrefStore.isCacheLookups();
    }

    public void putPreference(String preferenceKey, Object value) {
        this.userPrefStore.putPreference(preferenceKey, value);
    }

    public void removePreference(String preferenceKey) {
        this.userPrefStore.removePreference(preferenceKey);
    }

    public String getTableName() {
        return this.userPrefStore.getTableName();
    }

    public void setTableName(String tableName) {
        this.userPrefStore.setTableName(tableName);
        this.systemPrefStore.setTableName(tableName);
    }

    public boolean isAccessible() {
        return this.userPrefStore.isAccessible();
    }
}

