/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.preferences;

import com.levigo.util.log.Log;
import com.levigo.util.preferences.AbstractSQLPreferenceStore;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SQLPreferenceStore
extends AbstractSQLPreferenceStore {
    public SQLPreferenceStore(Connection connection) {
        this(connection, null);
    }

    public SQLPreferenceStore(Connection connection, String contextName) {
        if (null != contextName) {
            this.contextName = contextName;
        }
        this.connection = connection;
    }

    protected synchronized Object queryPreferenceValue(String preferenceKey) {
        try {
            PreparedStatement query = this.getPreparedStatement("select value from $TN$ where context=? and prefkey=?");
            if (null != query) {
                query.setQueryTimeout(5);
                if (null == query) {
                    return null;
                }
                query.setString(1, this.contextName);
                query.setString(2, preferenceKey);
                ResultSet rs = query.executeQuery();
                if (rs.next()) {
                    Object value = rs.getObject(1);
                    rs.close();
                    return value;
                }
                rs.close();
            }
        }
        catch (SQLException e) {
            Log.error((String)((Object)((Object)this)).getClass().getName(), (String)"Can't query preference value:", (Throwable)e);
            this.invalidateConnection();
        }
        return null;
    }

    protected void putPreferenceSQL(String preferenceKey, Object value) {
        try {
            PreparedStatement query = this.getPreparedStatement("update $TN$ set value=?, modcount=1+modcount where context=? and prefkey=?");
            if (null != query) {
                query.setQueryTimeout(5);
                if (query != null) {
                    query.setObject(1, value);
                    query.setString(2, this.contextName);
                    query.setString(3, preferenceKey);
                    if (query.executeUpdate() < 1) {
                        query = this.getPreparedStatement("insert into $TN$ (context, prefkey, value, modcount) values (?,?,?,0)");
                        query.setString(1, this.contextName);
                        query.setString(2, preferenceKey);
                        query.setObject(3, value);
                        query.execute();
                    }
                }
            }
        }
        catch (SQLException e) {
            this.invalidateConnection();
            Log.error((String)((Object)((Object)this)).getClass().getName(), (String)("Can't update pref value: " + preferenceKey + "/" + value + " in context " + this.contextName), (Throwable)e);
        }
    }
}

