/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.image;

import com.levigo.util.image.PixelUtils;
import com.levigo.util.image.TransferFilter;

public class ContrastFilter
extends TransferFilter {
    private float gain = 0.5f;
    private float bias = 0.5f;

    public ContrastFilter(float gain, float bias) {
        this.gain = gain;
        this.bias = bias;
    }

    public static float bias(float a, float b) {
        return (float)Math.pow(a, Math.log(b) / Math.log(0.5));
    }

    public static float gain(float a, float b) {
        float p = (float)Math.log(1.0 - (double)b) / (float)Math.log(0.5);
        if ((double)a < 0.001) {
            return 0.0f;
        }
        if ((double)a > 0.999) {
            return 1.0f;
        }
        if ((double)a < 0.5) {
            return (float)Math.pow(2.0f * a, p) / 2.0f;
        }
        return 1.0f - (float)Math.pow(2.0 * (1.0 - (double)a), p) / 2.0f;
    }

    protected int transferFunction(int v) {
        float f = (float)v / 255.0f;
        f = ContrastFilter.gain(f, this.gain);
        f = ContrastFilter.bias(f, this.bias);
        return PixelUtils.clamp((int)(f * 255.0f));
    }
}

