/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class ButtonRowLayout
implements LayoutManager {
    private int horizontalGap = 5;
    private int topMargin = 5;
    private int bottomMargin = 5;
    private int leftMargin = 5;
    private int rightMargin = 5;

    public ButtonRowLayout() {
        this(5, 5, 5, 5, 5);
    }

    public ButtonRowLayout(int hGap) {
        this(hGap, 5, 5, 5, 5);
    }

    public ButtonRowLayout(int hGap, int top, int left, int bottom, int right) {
        this.horizontalGap = Math.max(0, hGap);
        this.topMargin = Math.max(0, top);
        this.bottomMargin = Math.max(0, bottom);
        this.leftMargin = Math.max(0, left);
        this.rightMargin = Math.max(0, right);
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.minimumLayoutSize(parent);
    }

    public Dimension minimumLayoutSize(Container parent) {
        Component[] allComponents;
        if (parent != null && (allComponents = parent.getComponents()) != null && allComponents.length > 0) {
            int numberOfChildren = allComponents.length;
            Insets parentsInsets = parent.getInsets();
            int extraHeight = this.topMargin + parentsInsets.top + parentsInsets.bottom + this.bottomMargin;
            int extraWidth = this.leftMargin + parentsInsets.left + parentsInsets.right + this.rightMargin;
            int maxPrefHeight = 0;
            int maxPrefWidth = 0;
            for (int i = 0; i < numberOfChildren; ++i) {
                Dimension aSize = allComponents[i].getPreferredSize();
                maxPrefHeight = Math.max(maxPrefHeight, aSize.height);
                maxPrefWidth = Math.max(maxPrefWidth, aSize.width);
            }
            return new Dimension(extraWidth + numberOfChildren * maxPrefWidth + (numberOfChildren - 1) * this.horizontalGap, extraHeight + maxPrefHeight);
        }
        return new Dimension(0, 0);
    }

    public void layoutContainer(Container parent) {
        Component[] allComponents = parent.getComponents();
        if (allComponents != null && allComponents.length > 0) {
            int i;
            int numberOfChildren = allComponents.length;
            Dimension[] allComponentsSizes = new Dimension[numberOfChildren];
            Insets parentsInsets = parent.getInsets();
            int yLocation = parentsInsets.top + this.topMargin;
            int xLocation = 0;
            int xOffset = 0;
            int maxWidth = 0;
            for (i = 0; i < numberOfChildren; ++i) {
                allComponentsSizes[i] = allComponents[i].getPreferredSize();
                maxWidth = Math.max(maxWidth, allComponentsSizes[i].width);
            }
            if (parent.getComponentOrientation().isLeftToRight()) {
                xLocation = parent.getSize().width - parentsInsets.left - this.leftMargin - maxWidth - this.rightMargin;
                xOffset = this.horizontalGap + maxWidth;
            } else {
                xLocation = parentsInsets.left + this.leftMargin + this.rightMargin;
                xOffset = -(this.horizontalGap + maxWidth);
            }
            for (i = numberOfChildren - 1; i >= 0; --i) {
                allComponents[i].setBounds(xLocation, yLocation, maxWidth, allComponentsSizes[i].height);
                xLocation -= xOffset;
            }
        }
    }
}

