/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.messaging;

import com.levigo.util.messaging.DefaultMessageResource;
import com.levigo.util.messaging.Message;
import com.levigo.util.messaging.MessageFactory;
import com.levigo.util.messaging.MessageResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;

public class DefaultMessageFactory
implements MessageFactory {
    public static final String[] OK_CANCEL_ACTION_TEXTS = new String[]{"OK", "Abbrechen", null};
    public static final String[] OK_ACTION_TEXTS = new String[]{"OK", null, null};
    public static final String[] YES_NO_ACTION_TEXTS = new String[]{"Ja", "Nein", null};
    public static final String[] YES_NO_CANCEL_ACTION_TEXTS = new String[]{"Ja", "Nein", "Abbrechen"};
    private static final String YES = "YES";
    private static final String NO = "NO";
    private static final String isSuppressableMessageKey = ".isSuppressableMessage";
    private static final String isSuppressedMessageKey = ".isSuppressedMessage";
    private MessageResource messageResource = null;

    public DefaultMessageFactory(String bundleName) {
        this.messageResource = new DefaultMessageResource(bundleName);
    }

    public Message createMessage(String messageKey) {
        return this.createMessage(messageKey, null, null);
    }

    public Message createMessage(String messageKey, Object[] parameters, Throwable e) {
        return this.assembleMessage(messageKey, parameters, e);
    }

    private Message assembleMessage(String key, Object[] parameters, Throwable e) {
        String okLabelKey = key + ".acceptLabel";
        String denyLabelKey = key + ".denyLabel";
        String cancelLabelKey = key + ".cancelLabel";
        String okLabelMnemonicKey = okLabelKey + ".mnemonic";
        String denyLabelMnemonicKey = denyLabelKey + ".mnemonic";
        String cancelLabelMnemonicKey = cancelLabelKey + ".mnemonic";
        String typeKey = key + ".type";
        String isSuppressableKey = key + isSuppressableMessageKey;
        String isSuppressedKey = key + isSuppressedMessageKey;
        String[] buttonLabels = new String[3];
        String[] buttonMnemonics = new String[3];
        if (this.containsKey(typeKey) && this.getString(typeKey).equalsIgnoreCase("CHOICE")) {
            System.arraycopy(YES_NO_ACTION_TEXTS, 0, buttonLabels, 0, 3);
        } else if (this.containsKey(typeKey) && (this.getString(typeKey).equalsIgnoreCase("CONFIRM") || this.getString(typeKey).equalsIgnoreCase("DISPLAY"))) {
            System.arraycopy(OK_ACTION_TEXTS, 0, buttonLabels, 0, 3);
        } else {
            System.arraycopy(OK_CANCEL_ACTION_TEXTS, 0, buttonLabels, 0, 3);
        }
        if (this.containsKey(okLabelKey)) {
            buttonLabels[0] = this.getString(okLabelKey);
        }
        if (this.containsKey(denyLabelKey)) {
            buttonLabels[1] = this.getString(denyLabelKey);
        }
        if (this.containsKey(cancelLabelKey)) {
            buttonLabels[2] = this.getString(cancelLabelKey);
        }
        if (this.containsKey(okLabelMnemonicKey)) {
            buttonMnemonics[0] = this.getString(okLabelMnemonicKey);
        }
        if (this.containsKey(denyLabelMnemonicKey)) {
            buttonMnemonics[1] = this.getString(denyLabelMnemonicKey);
        }
        if (this.containsKey(cancelLabelMnemonicKey)) {
            buttonMnemonics[2] = this.getString(cancelLabelMnemonicKey);
        }
        boolean isSuppressable = false;
        boolean isSuppressed = false;
        if (this.containsKey(isSuppressableKey) && this.getString(isSuppressableKey).equals(YES)) {
            isSuppressable = true;
            if (this.containsKey(isSuppressedKey)) {
                isSuppressed = this.getString(isSuppressedKey).equals(YES);
            }
        }
        return new Message(key, this.getString(typeKey), this.getString(key + ".severity"), this.getString(key + ".title", parameters), this.getString(key + ".body", parameters), this.getString(key + ".details"), this.getString(key + ".description"), e, buttonLabels, buttonMnemonics, isSuppressable, isSuppressed);
    }

    public boolean containsKey(String key) {
        boolean found = false;
        if (key != null) {
            Enumeration en = this.messageResource.getKeys();
            while (en.hasMoreElements() && !found) {
                found = en.nextElement().toString().startsWith(key);
            }
        }
        return found;
    }

    private String getString(String key) {
        return this.messageResource.getString(key, null);
    }

    private String getString(String key, Object[] parameters) {
        return this.messageResource.getString(key, parameters);
    }

    public Collection getSuppressableMessages() {
        ArrayList suppressableMessages = new ArrayList();
        Enumeration keys = this.messageResource.getKeys();
        while (keys.hasMoreElements()) {
            String suppressedKey;
            Object next = keys.nextElement();
            if (next.toString().toLowerCase().indexOf(isSuppressableMessageKey.toLowerCase()) <= 0 || !this.messageResource.getString(next.toString(), null).equalsIgnoreCase(YES) || this.containsKey(suppressedKey = next.toString().substring(0, next.toString().indexOf(isSuppressableMessageKey)).concat(isSuppressedMessageKey)) && !this.messageResource.getString(suppressedKey, null).equalsIgnoreCase(NO)) continue;
            suppressableMessages.add(next);
        }
        return suppressableMessages;
    }
}

