/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.messaging;

import com.levigo.util.messaging.MessageResource;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DefaultMessageResource
implements MessageResource {
    private ResourceBundle resourceBundle = null;
    private String bundleName = null;

    public DefaultMessageResource(String bundleName) {
        this.setBundleName(bundleName);
        this.resourceBundle = ResourceBundle.getBundle(bundleName);
    }

    public String getBundleName() {
        return this.bundleName;
    }

    private void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultMessageResource) {
            return this.getBundleName().equalsIgnoreCase(((DefaultMessageResource)obj).getBundleName());
        }
        return false;
    }

    public String getString(String key, Object[] parameters) {
        try {
            return parameters != null ? MessageFormat.format(this.resourceBundle.getString(key), parameters) : this.resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return "";
        }
    }

    public boolean containsKey(String key) {
        try {
            this.resourceBundle.getString(key);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public Enumeration getKeys() {
        return this.resourceBundle.getKeys();
    }
}

