/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.messaging;

import com.levigo.util.messaging.Message;
import com.levigo.util.messaging.MessageFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MessageFactoryHolder
implements MessageFactory {
    private static MessageFactoryHolder theInstance = null;
    private List factories = null;
    private Message emptyMessage = new Message("", "CONFIRM", "WARNING", "Message Resource not found!", "", "", null, null);

    private MessageFactoryHolder() {
    }

    public static MessageFactoryHolder getInstance() {
        if (theInstance == null) {
            theInstance = new MessageFactoryHolder();
        }
        return theInstance;
    }

    private List getRegisteredMessageFactories() {
        if (this.factories == null) {
            this.factories = Collections.synchronizedList(new ArrayList());
        }
        return this.factories;
    }

    public static void addMessageFactory(MessageFactory aFactory) {
        if (aFactory == null) {
            return;
        }
        List allFactories = MessageFactoryHolder.getInstance().getRegisteredMessageFactories();
        if (allFactories.contains(aFactory)) {
            allFactories.remove(aFactory);
        }
        allFactories.add(0, aFactory);
    }

    public static void removeMessageFactory(MessageFactory aFactory) {
        if (aFactory == null) {
            return;
        }
        if (MessageFactoryHolder.getInstance().getRegisteredMessageFactories().contains(aFactory)) {
            MessageFactoryHolder.getInstance().getRegisteredMessageFactories().remove(aFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        List resList;
        boolean found = false;
        List list = resList = MessageFactoryHolder.getInstance().getRegisteredMessageFactories();
        synchronized (list) {
            for (int i = 0; i < resList.size() && !found; ++i) {
                found = ((MessageFactory)resList.get(i)).containsKey(key);
            }
        }
        return found;
    }

    public Message createMessage(String messageKey) {
        return this.createMessage(messageKey, null, null);
    }

    public Message createMessage(String messageKey, Throwable e) {
        return this.createMessage(messageKey, null, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message createMessage(String messageKey, Object[] parameters, Throwable e) {
        List resList;
        Message newMessage = null;
        List list = resList = MessageFactoryHolder.getInstance().getRegisteredMessageFactories();
        synchronized (list) {
            for (int i = 0; i < resList.size() && newMessage == null; ++i) {
                MessageFactory aFactory = (MessageFactory)resList.get(i);
                if (!aFactory.containsKey(messageKey)) continue;
                newMessage = aFactory.createMessage(messageKey, parameters, e);
                break;
            }
        }
        if (newMessage == null) {
            newMessage = this.emptyMessage;
            newMessage.setBodyText("Key: " + messageKey);
        }
        return newMessage;
    }

    public Collection getSuppressableMessages() {
        ArrayList suppressableMessages = new ArrayList();
        List messageFactories = MessageFactoryHolder.getInstance().getRegisteredMessageFactories();
        Iterator iter = messageFactories.iterator();
        while (iter.hasNext()) {
            MessageFactory factory = (MessageFactory)iter.next();
            suppressableMessages.addAll(factory.getSuppressableMessages());
        }
        return suppressableMessages;
    }
}

