/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.messaging;

import com.levigo.util.messaging.Message;
import com.levigo.util.messaging.MessageEvent;
import com.levigo.util.messaging.MessageFactory;
import com.levigo.util.messaging.MessageFactoryHolder;
import com.levigo.util.messaging.MessageListener;
import com.levigo.util.messaging.MessageResult;
import com.levigo.util.messaging.printstreams.MessageDefaultDebugStream;
import com.levigo.util.messaging.printstreams.MessageDefaultErrorStream;
import com.levigo.util.preferences.PreferenceStore;
import com.levigo.util.swing.SwingWorkerAdapter;
import java.awt.Component;
import java.util.Collection;
import javax.swing.event.EventListenerList;

public class MessageManager {
    private static MessageManager theInstance = null;
    private EventListenerList listenerList = new EventListenerList();
    private static PreferenceStore preferenceStore = null;
    private static final String SUPPRESSION_STRING = "suppressedMessage.";

    private MessageManager() {
    }

    private static MessageManager getInstance() {
        if (null == theInstance) {
            theInstance = new MessageManager();
        }
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDefaultErrorStream() {
        MessageManager messageManager = MessageManager.getInstance();
        synchronized (messageManager) {
            if (MessageManager.getListenerCount(MessageDefaultErrorStream.class) == 0) {
                MessageManager.addMessageListener(new MessageDefaultErrorStream());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getListenerCount(Class listenerClass) {
        MessageManager messageManager = MessageManager.getInstance();
        synchronized (messageManager) {
            int count = 0;
            Object[] listeners = MessageManager.getInstance().listenerList.getListenerList();
            for (int i = 1; i < listeners.length; i += 2) {
                if (!listeners[i].getClass().equals(listenerClass)) continue;
                ++count;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDefaultDebugStream() {
        MessageManager messageManager = MessageManager.getInstance();
        synchronized (messageManager) {
            if (MessageManager.getListenerCount(MessageDefaultDebugStream.class) == 0) {
                MessageManager.addMessageListener(new MessageDefaultDebugStream());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMessageListener(MessageListener l) {
        MessageManager messageManager = MessageManager.getInstance();
        synchronized (messageManager) {
            MessageManager.getInstance().listenerList.remove(MessageListener.class, l);
            MessageManager.getInstance().listenerList.add(MessageListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMessageListener(MessageListener l) {
        MessageManager messageManager = MessageManager.getInstance();
        synchronized (messageManager) {
            MessageManager.getInstance().listenerList.remove(MessageListener.class, l);
        }
    }

    public static MessageResult displayMessage(Component source, Message messageToDisplay) {
        if (messageToDisplay == null || MessageManager.getInstance().isSuppressedMessage(messageToDisplay.getIdentifier()) || MessageManager.getInstance().listenerList.getListenerCount() == 0) {
            return new MessageResult(null);
        }
        return MessageManager.displayMessage(new MessageEvent(source != null ? source : theInstance, messageToDisplay));
    }

    public static MessageResult displayMessage(Component source, String messageIdentifier) {
        if (MessageManager.getInstance().isSuppressedMessage(messageIdentifier) || MessageManager.getInstance().listenerList.getListenerCount() == 0) {
            return null;
        }
        return MessageManager.displayMessage(new MessageEvent(source != null ? source : theInstance, MessageFactoryHolder.getInstance().createMessage(messageIdentifier)));
    }

    public static MessageResult displayMessage(Component source, String messageIdentifier, Throwable e) {
        if (MessageManager.getInstance().isSuppressedMessage(messageIdentifier) || MessageManager.getInstance().listenerList.getListenerCount() == 0) {
            return null;
        }
        return MessageManager.displayMessage(new MessageEvent(source != null ? source : theInstance, MessageFactoryHolder.getInstance().createMessage(messageIdentifier, e)));
    }

    public static MessageResult displayMessage(Component source, String messageIdentifier, Throwable e, boolean ignoreSuppression) {
        if (ignoreSuppression) {
            MessageEvent evt = new MessageEvent(source != null ? source : theInstance, MessageFactoryHolder.getInstance().createMessage(messageIdentifier, e));
            if (evt == null) {
                return null;
            }
            return MessageManager.getInstance().fireMessageEvent(evt);
        }
        return MessageManager.displayMessage(source, messageIdentifier, e);
    }

    public static MessageResult displayMessage(Component source, String messageIdentifier, Object[] messageParameters, Throwable e) {
        if (MessageManager.getInstance().isSuppressedMessage(messageIdentifier) || MessageManager.getInstance().listenerList.getListenerCount() == 0) {
            return null;
        }
        return MessageManager.displayMessage(new MessageEvent(source != null ? source : theInstance, MessageFactoryHolder.getInstance().createMessage(messageIdentifier, messageParameters, e)));
    }

    public static MessageResult displayMessage(Component source, String messageIdentifier, Object[] messageParameters) {
        if (MessageManager.getInstance().isSuppressedMessage(messageIdentifier) || MessageManager.getInstance().listenerList.getListenerCount() == 0) {
            return null;
        }
        return MessageManager.displayMessage(new MessageEvent(source != null ? source : theInstance, MessageFactoryHolder.getInstance().createMessage(messageIdentifier, messageParameters, null)));
    }

    public static MessageResult displayMessage(MessageEvent evt) {
        if (evt == null || MessageManager.getInstance().isSuppressedMessage(evt.getMessage().getIdentifier()) || evt.getMessage().isSuppressed() || MessageManager.getInstance().listenerList.getListenerCount() == 0) {
            return null;
        }
        return MessageManager.getInstance().fireMessageEvent(evt);
    }

    private boolean isSuppressedMessage(String messageIdentifier) {
        return messageIdentifier != null && preferenceStore != null && preferenceStore.getPreferenceAsBoolean(SUPPRESSION_STRING + messageIdentifier, false);
    }

    private MessageResult fireMessageEvent(MessageEvent messageEvent) {
        if (messageEvent == null || MessageManager.getInstance().listenerList.getListenerCount() == 0) {
            return null;
        }
        MessageDeliveryWorker mdw = new MessageDeliveryWorker(messageEvent);
        mdw.run();
        mdw.waitForResult();
        return mdw.getMessageResult();
    }

    public static synchronized void suppressMessage(String messageIdentifier) {
        if (messageIdentifier == null || preferenceStore == null) {
            return;
        }
        preferenceStore.putPreference(SUPPRESSION_STRING + messageIdentifier, true);
        preferenceStore.flush();
    }

    public static synchronized void unsuppressMessage(String messageIdentifier) {
        if (messageIdentifier == null || preferenceStore == null) {
            return;
        }
        preferenceStore.removePreference(SUPPRESSION_STRING + messageIdentifier);
        preferenceStore.flush();
    }

    public static synchronized void addMessageFactory(MessageFactory aFactory) {
        MessageFactoryHolder.addMessageFactory(aFactory);
    }

    public static synchronized void removeMessageFactory(MessageFactory aFactory) {
        MessageFactoryHolder.removeMessageFactory(aFactory);
    }

    public static void setPreferenceStore(PreferenceStore prefStore) {
        preferenceStore = prefStore;
    }

    public static boolean isMessageSuppressed(String messageKey) {
        if (preferenceStore != null) {
            return preferenceStore.getPreferenceAsBoolean(SUPPRESSION_STRING + messageKey, false);
        }
        return false;
    }

    public static Collection getSuppressableMessages() {
        return MessageFactoryHolder.getInstance().getSuppressableMessages();
    }

    public static Message getMessage(String messageKey, Object[] messageParameters, Exception e) {
        return MessageFactoryHolder.getInstance().createMessage(messageKey, messageParameters, e);
    }

    private class MessageDeliveryWorker
    extends SwingWorkerAdapter {
        private MessageEvent event = null;
        private MessageResult result = null;

        public MessageDeliveryWorker(MessageEvent event) {
            this.event = event;
        }

        protected synchronized void performWork() {
            Object[] listeners = MessageManager.this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$com$levigo$util$messaging$MessageListener == null ? MessageManager.class$("com.levigo.util.messaging.MessageListener") : class$com$levigo$util$messaging$MessageListener)) continue;
                ((MessageListener)listeners[i + 1]).displayMessage(this.event);
            }
            this.result = this.event.getMessageResult();
            this.notifyAll();
        }

        public MessageResult getMessageResult() {
            return this.result;
        }

        public boolean isResultReady() {
            return this.result != null || MessageManager.this.listenerList.getListenerCount() == 0;
        }

        public synchronized void waitForResult() {
            while (!this.isResultReady()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

